/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.mvc;

import ghidra.app.plugin.core.functiongraph.FunctionGraphPlugin;
import ghidra.app.plugin.core.functiongraph.graph.FunctionGraph;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.app.plugin.core.functiongraph.graph.vertex.GroupedFunctionGraphVertex;
import ghidra.app.plugin.core.functiongraph.mvc.LazySaveableXML;
import ghidra.app.plugin.core.functiongraph.mvc.SaveableXML;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramUserData;
import ghidra.program.model.util.ObjectPropertyMap;
import ghidra.program.model.util.PropertyMap;
import ghidra.util.Saveable;
import ghidra.util.SaveableColor;
import ghidra.util.SaveablePoint;
import java.awt.Color;
import java.awt.Point;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;

public class FunctionGraphVertexAttributes {
    public static final String LOCATION_PROPERTY_NAME = "VERTEX_LOCATION";
    public static final String COLOR_PROPERTY_NAME = "VERTEX_COLOR";
    public static final String GROUP_SETTINGS_PROPERTY_NAME = "VERTEX_GROUP_SETTINGS";
    public static final String REGROUP_SETTINGS_PROPERTY_NAME = "VERTEX_REGROUP_SETTINGS";
    private static final String GROUP_LOCATION_PROPERTY_NAME = "GROUP_VERTEX_LOCATION";
    private Map<Address, Saveable> colorUpdateMap = new HashMap<Address, Saveable>();
    private Map<Address, Saveable> locationUpdateMap = new HashMap<Address, Saveable>();
    private Map<Address, Saveable> groupLocationUpdateMap = new HashMap<Address, Saveable>();
    private Map<Address, Saveable> groupedSettingsUpdateMap = new HashMap<Address, Saveable>();
    private Map<Address, Saveable> regroupSettingsUpdateMap = new HashMap<Address, Saveable>();
    private ProgramUserData programUserData;

    public FunctionGraphVertexAttributes(Program program) {
        this.programUserData = program.getProgramUserData();
    }

    public Map<FGVertex, Point> getVertexLocations(FunctionGraph functionGraph) {
        ObjectPropertyMap vertexLocationropertyMap = this.programUserData.getObjectProperty(FunctionGraphPlugin.class.getSimpleName(), LOCATION_PROPERTY_NAME, SaveablePoint.class, false);
        ObjectPropertyMap groupVertexLocationropertyMap = this.programUserData.getObjectProperty(FunctionGraphPlugin.class.getSimpleName(), GROUP_LOCATION_PROPERTY_NAME, SaveablePoint.class, false);
        return this.getVertexLocationsFromPropertyMaps(functionGraph, vertexLocationropertyMap, groupVertexLocationropertyMap);
    }

    private Map<FGVertex, Point> getVertexLocationsFromPropertyMaps(FunctionGraph functionGraph, ObjectPropertyMap vertexLocationPropertyMap, ObjectPropertyMap groupVertexLocationPropertyMap) {
        HashMap<FGVertex, Point> map = new HashMap<FGVertex, Point>();
        FunctionGraph graph = functionGraph;
        Collection vertices = graph.getVertices();
        for (FGVertex vertex : vertices) {
            SaveablePoint saveablePoint = this.getPointFromPropertyMap(vertex, vertexLocationPropertyMap, groupVertexLocationPropertyMap);
            if (saveablePoint == null) continue;
            Point point = saveablePoint.getPoint();
            map.put(vertex, point);
        }
        return map;
    }

    private SaveablePoint getPointFromPropertyMap(FGVertex vertex, ObjectPropertyMap vertexLocationPropertyMap, ObjectPropertyMap groupVertexLocationPropertyMap) {
        Address address = vertex.getVertexAddress();
        if (vertex instanceof GroupedFunctionGraphVertex) {
            if (groupVertexLocationPropertyMap == null) {
                return null;
            }
            return (SaveablePoint)groupVertexLocationPropertyMap.getObject(address);
        }
        if (vertexLocationPropertyMap == null) {
            return null;
        }
        return (SaveablePoint)vertexLocationPropertyMap.getObject(address);
    }

    public Element getGroupedVertexSettings(FunctionGraph functionGraph) {
        ObjectPropertyMap propertyMap = this.programUserData.getObjectProperty(FunctionGraphPlugin.class.getSimpleName(), GROUP_SETTINGS_PROPERTY_NAME, SaveableXML.class, false);
        if (propertyMap == null) {
            return null;
        }
        FGVertex rootVertex = functionGraph.getRootVertex();
        Address entryPoint = rootVertex.getVertexAddress();
        SaveableXML saveableXML = (SaveableXML)((Object)propertyMap.getObject(entryPoint));
        if (saveableXML != null) {
            return saveableXML.getElement();
        }
        return null;
    }

    public Element getRegroupVertexSettings(FunctionGraph functionGraph) {
        ObjectPropertyMap propertyMap = this.programUserData.getObjectProperty(FunctionGraphPlugin.class.getSimpleName(), REGROUP_SETTINGS_PROPERTY_NAME, SaveableXML.class, false);
        if (propertyMap == null) {
            return null;
        }
        FGVertex rootVertex = functionGraph.getRootVertex();
        Address entryPoint = rootVertex.getVertexAddress();
        SaveableXML saveableXML = (SaveableXML)((Object)propertyMap.getObject(entryPoint));
        if (saveableXML != null) {
            return saveableXML.getElement();
        }
        return null;
    }

    public Map<FGVertex, Color> getVertexColors(FunctionGraph functionGraph) {
        ObjectPropertyMap propertyMap = this.programUserData.getObjectProperty(FunctionGraphPlugin.class.getSimpleName(), COLOR_PROPERTY_NAME, SaveableColor.class, false);
        if (propertyMap == null) {
            return Collections.emptyMap();
        }
        HashMap<FGVertex, Color> map = new HashMap<FGVertex, Color>();
        FunctionGraph graph = functionGraph;
        Collection vertices = graph.getVertices();
        for (FGVertex vertex : vertices) {
            AddressSetView codeBlock = vertex.getAddresses();
            Address minAddress = codeBlock.getMinAddress();
            SaveableColor saveableColor = (SaveableColor)propertyMap.getObject(minAddress);
            if (saveableColor == null) continue;
            Color color = saveableColor.getColor();
            map.put(vertex, color);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearVertexLocations(FunctionGraph functionGraph) {
        this.locationUpdateMap.clear();
        this.groupLocationUpdateMap.clear();
        int transactionID = this.programUserData.startTransaction();
        try {
            ObjectPropertyMap vertexLocationPropertyMap = this.programUserData.getObjectProperty(FunctionGraphPlugin.class.getSimpleName(), LOCATION_PROPERTY_NAME, SaveablePoint.class, false);
            this.clearMap(vertexLocationPropertyMap, functionGraph);
            ObjectPropertyMap groupVertexLocationPropertyMap = this.programUserData.getObjectProperty(FunctionGraphPlugin.class.getSimpleName(), GROUP_LOCATION_PROPERTY_NAME, SaveablePoint.class, false);
            this.clearMap(groupVertexLocationPropertyMap, functionGraph);
        }
        finally {
            this.programUserData.endTransaction(transactionID);
        }
    }

    private void clearMap(ObjectPropertyMap propertyMap, FunctionGraph functionGraph) {
        if (propertyMap == null) {
            return;
        }
        FunctionGraph graph = functionGraph;
        Collection vertices = graph.getVertices();
        for (FGVertex vertex : vertices) {
            AddressSetView codeBlock = vertex.getAddresses();
            Address minAddress = codeBlock.getMinAddress();
            propertyMap.remove(minAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearGroupSettings(FunctionGraph functionGraph) {
        this.groupedSettingsUpdateMap.clear();
        int transactionID = this.programUserData.startTransaction();
        try {
            ObjectPropertyMap propertyMap = this.programUserData.getObjectProperty(FunctionGraphPlugin.class.getSimpleName(), GROUP_SETTINGS_PROPERTY_NAME, SaveableXML.class, false);
            if (propertyMap == null) {
                return;
            }
            FGVertex rootVertex = functionGraph.getRootVertex();
            propertyMap.remove(rootVertex.getVertexAddress());
        }
        finally {
            this.programUserData.endTransaction(transactionID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRegroupSettings(FunctionGraph functionGraph) {
        this.regroupSettingsUpdateMap.clear();
        int transactionID = this.programUserData.startTransaction();
        try {
            ObjectPropertyMap propertyMap = this.programUserData.getObjectProperty(FunctionGraphPlugin.class.getSimpleName(), REGROUP_SETTINGS_PROPERTY_NAME, SaveableXML.class, false);
            if (propertyMap == null) {
                return;
            }
            FGVertex rootVertex = functionGraph.getRootVertex();
            propertyMap.remove(rootVertex.getVertexAddress());
        }
        finally {
            this.programUserData.endTransaction(transactionID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllPropertiesForAddresses(AddressSetView addresses) {
        int transactionID = this.programUserData.startTransaction();
        try {
            List properties = this.programUserData.getProperties(FunctionGraphPlugin.class.getSimpleName());
            for (PropertyMap propertyMap : properties) {
                this.clearAllPropertiesForAddressRange(propertyMap, addresses);
            }
        }
        finally {
            this.programUserData.endTransaction(transactionID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPropertyForAddresses(String propertyName, AddressSetView addresses) {
        int transactionID = this.programUserData.startTransaction();
        try {
            List properties = this.programUserData.getProperties(FunctionGraphPlugin.class.getSimpleName());
            for (PropertyMap propertyMap : properties) {
                if (!propertyMap.getName().equals(propertyName)) continue;
                this.clearAllPropertiesForAddressRange(propertyMap, addresses);
                return;
            }
        }
        finally {
            this.programUserData.endTransaction(transactionID);
        }
    }

    private void clearAllPropertiesForAddressRange(PropertyMap propertyMap, AddressSetView addresses) {
        AddressIterator iterator = addresses.getAddresses(true);
        while (iterator.hasNext()) {
            Address address = iterator.next();
            propertyMap.remove(address);
        }
    }

    public void save() {
        int transactionID = this.programUserData.startTransaction();
        try {
            ObjectPropertyMap propertyMap;
            if (!this.colorUpdateMap.isEmpty()) {
                propertyMap = this.programUserData.getObjectProperty(FunctionGraphPlugin.class.getSimpleName(), COLOR_PROPERTY_NAME, SaveableColor.class, true);
                this.saveMap(this.colorUpdateMap, propertyMap);
            }
            if (!this.locationUpdateMap.isEmpty()) {
                propertyMap = this.programUserData.getObjectProperty(FunctionGraphPlugin.class.getSimpleName(), LOCATION_PROPERTY_NAME, SaveablePoint.class, true);
                this.saveMap(this.locationUpdateMap, propertyMap);
            }
            if (!this.groupLocationUpdateMap.isEmpty()) {
                propertyMap = this.programUserData.getObjectProperty(FunctionGraphPlugin.class.getSimpleName(), GROUP_LOCATION_PROPERTY_NAME, SaveablePoint.class, true);
                this.saveMap(this.groupLocationUpdateMap, propertyMap);
            }
            if (!this.groupedSettingsUpdateMap.isEmpty()) {
                propertyMap = this.programUserData.getObjectProperty(FunctionGraphPlugin.class.getSimpleName(), GROUP_SETTINGS_PROPERTY_NAME, SaveableXML.class, true);
                this.saveMap(this.groupedSettingsUpdateMap, propertyMap);
            }
            if (!this.regroupSettingsUpdateMap.isEmpty()) {
                propertyMap = this.programUserData.getObjectProperty(FunctionGraphPlugin.class.getSimpleName(), REGROUP_SETTINGS_PROPERTY_NAME, SaveableXML.class, true);
                this.saveMap(this.regroupSettingsUpdateMap, propertyMap);
            }
        }
        finally {
            this.programUserData.endTransaction(transactionID);
        }
    }

    private void saveMap(Map<Address, Saveable> map, ObjectPropertyMap propertyMap) {
        Set<Map.Entry<Address, Saveable>> entrySet = map.entrySet();
        for (Map.Entry<Address, Saveable> entry : entrySet) {
            Address key = entry.getKey();
            Saveable value = entry.getValue();
            if (value instanceof LazySaveableXML && ((LazySaveableXML)value).isEmpty()) continue;
            if (value != null) {
                propertyMap.add(key, value);
                continue;
            }
            propertyMap.remove(key);
        }
    }

    public Color getVertexColor(Address address) {
        ObjectPropertyMap propertyMap = this.programUserData.getObjectProperty(FunctionGraphPlugin.class.getSimpleName(), COLOR_PROPERTY_NAME, SaveableColor.class, false);
        if (propertyMap == null) {
            return null;
        }
        SaveableColor saveable = (SaveableColor)propertyMap.getObject(address);
        if (saveable == null) {
            return null;
        }
        return saveable.getColor();
    }

    public void clearVertexColor(Address address) {
        this.colorUpdateMap.put(address, null);
    }

    public void clearVertexLocation(FGVertex vertex) {
        Address address = vertex.getVertexAddress();
        if (vertex instanceof GroupedFunctionGraphVertex) {
            this.groupLocationUpdateMap.put(address, null);
        } else {
            this.locationUpdateMap.put(address, null);
        }
    }

    public void clearGroupedVertexSettings(Address address) {
        this.groupedSettingsUpdateMap.put(address, null);
    }

    public void clearRegroupVertexSettign(Address address) {
        this.regroupSettingsUpdateMap.put(address, null);
    }

    public void putVertexColor(Address address, Color color) {
        this.colorUpdateMap.put(address, (Saveable)new SaveableColor(color));
    }

    public void putVertexLocation(FGVertex vertex, Point point) {
        Address vertexAddress = vertex.getVertexAddress();
        Point pointCopy = new Point(point);
        if (vertex instanceof GroupedFunctionGraphVertex) {
            this.groupLocationUpdateMap.put(vertexAddress, (Saveable)new SaveablePoint(pointCopy));
        } else {
            this.locationUpdateMap.put(vertexAddress, (Saveable)new SaveablePoint(pointCopy));
        }
    }

    public void putGroupedVertexSettings(FunctionGraph functionGraph, SaveableXML saveableXML) {
        FGVertex rootVertex = functionGraph.getRootVertex();
        Address entryPoint = rootVertex.getVertexAddress();
        this.groupedSettingsUpdateMap.put(entryPoint, (Saveable)saveableXML);
    }

    public void putRegroupSettings(FunctionGraph functionGraph, SaveableXML saveableXML) {
        FGVertex rootVertex = functionGraph.getRootVertex();
        Address entryPoint = rootVertex.getVertexAddress();
        this.regroupSettingsUpdateMap.put(entryPoint, (Saveable)saveableXML);
    }
}

