/*
 * Decompiled with CFR 0.152.
 */
package docking.options.editor;

import com.toedter.calendar.JCalendar;
import ghidra.util.layout.HorizontalLayout;
import java.awt.Color;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

class Clock
extends JPanel
implements CaretListener {
    private JLabel dateLabel = new JLabel("Apr 18, 2006");
    private JTextField hoursField;
    private JTextField minutesField;
    private JTextField secondsField;
    private SimpleDateFormat formatter;
    private DocumentListener docListener;
    private boolean isEditing;
    private JTextField currentEditField;
    private int min;
    private int max;
    private int value;
    private Color defaultBackgroundColor;
    private static Color CURRENT_BACKGROUND_COLOR = new Color(204, 204, 255);
    private JCalendar jCalendar;

    Clock(JCalendar calendar) {
        super((LayoutManager)new HorizontalLayout(1));
        this.jCalendar = calendar;
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.create();
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        JTextField tf = (JTextField)e.getSource();
        Document doc = tf.getDocument();
        this.max = 59;
        if (this.hoursField.getDocument() == doc) {
            this.max = 23;
            this.currentEditField = this.hoursField;
            this.updateColors(this.minutesField);
            this.updateColors(this.secondsField);
        } else if (this.minutesField.getDocument() == doc) {
            this.currentEditField = this.minutesField;
            this.updateColors(this.hoursField);
            this.updateColors(this.secondsField);
        } else {
            this.currentEditField = this.secondsField;
            this.updateColors(this.hoursField);
            this.updateColors(this.minutesField);
        }
        this.currentEditField.setBackground(CURRENT_BACKGROUND_COLOR);
    }

    void update(Date date) {
        if (this.isEditing) {
            return;
        }
        this.removeDocumentListeners();
        try {
            String dateStr = this.formatter.format(date);
            this.dateLabel.setText(this.getDate(dateStr) + "  ");
            this.hoursField.setText(this.getHours(dateStr));
            this.minutesField.setText(this.getMinutes(dateStr));
            this.secondsField.setText(this.getSeconds(dateStr));
        }
        finally {
            this.addDocumentListeners();
        }
        if (this.currentEditField != null) {
            this.setValue(Integer.parseInt(this.currentEditField.getText()), false);
        }
    }

    private void create() {
        this.hoursField = new JTextField(2);
        this.minutesField = new JTextField(2);
        this.secondsField = new JTextField(2);
        this.hoursField.addCaretListener(this);
        this.minutesField.addCaretListener(this);
        this.secondsField.addCaretListener(this);
        this.hoursField.setName("Hours");
        this.minutesField.setName("Minutes");
        this.secondsField.setName("Seconds");
        this.dateLabel.setName("DateString");
        this.min = 0;
        this.max = 60;
        this.value = 0;
        this.add(this.dateLabel);
        this.add(this.hoursField);
        this.add(new JLabel(":"));
        this.add(this.minutesField);
        this.add(new JLabel(":"));
        this.add(this.secondsField);
        this.formatter = new SimpleDateFormat("HH:mm:ss MMM dd, yyyy");
        this.hoursField.setDocument(new TimeDocument(true));
        this.minutesField.setDocument(new TimeDocument(false));
        this.secondsField.setDocument(new TimeDocument(false));
        Calendar cal = Calendar.getInstance();
        Date date = cal.getTime();
        this.update(date);
        this.docListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                Clock.this.checkInput(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                Clock.this.checkInput(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                Clock.this.checkInput(e);
            }
        };
        this.addDocumentListeners();
        this.defaultBackgroundColor = this.hoursField.getBackground();
    }

    private void addDocumentListeners() {
        this.hoursField.getDocument().addDocumentListener(this.docListener);
        this.minutesField.getDocument().addDocumentListener(this.docListener);
        this.secondsField.getDocument().addDocumentListener(this.docListener);
    }

    private void removeDocumentListeners() {
        this.hoursField.getDocument().removeDocumentListener(this.docListener);
        this.minutesField.getDocument().removeDocumentListener(this.docListener);
        this.secondsField.getDocument().removeDocumentListener(this.docListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInput(DocumentEvent e) {
        this.isEditing = true;
        Calendar cal = this.jCalendar.getCalendar();
        try {
            int hourValue = Integer.parseInt(this.hoursField.getText());
            int minutesValue = Integer.parseInt(this.minutesField.getText());
            int secondsValue = Integer.parseInt(this.secondsField.getText());
            if (hourValue >= 0 && hourValue <= 23 && minutesValue >= 0 && minutesValue <= 59 && secondsValue >= 0 && secondsValue <= 59) {
                cal.set(11, hourValue);
                cal.set(12, minutesValue);
                cal.set(13, secondsValue);
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        finally {
            this.isEditing = false;
        }
    }

    private void updateColors(JTextField field) {
        field.setBackground(this.defaultBackgroundColor);
    }

    private void setValue(int newValue, boolean updateTextField) {
        this.value = newValue < this.min ? this.min : (newValue > this.max ? this.max : newValue);
        if (updateTextField) {
            Object str = Integer.toString(this.value);
            if (((String)str).length() < 2) {
                str = "0" + (String)str;
            }
            this.currentEditField.setText((String)str);
        }
    }

    private String getHours(String dateStr) {
        int pos = dateStr.indexOf(":");
        return dateStr.substring(0, pos);
    }

    private String getMinutes(String dateStr) {
        return dateStr.substring(3, 5);
    }

    private String getSeconds(String dateStr) {
        return dateStr.substring(6, 8);
    }

    private String getDate(String dateStr) {
        int pos = dateStr.indexOf(" ");
        return dateStr.substring(pos + 1);
    }

    private class TimeDocument
    extends PlainDocument {
        private boolean isHours;

        TimeDocument(boolean isHours) {
            this.isHours = isHours;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            char[] source = str.toCharArray();
            char[] result = new char[source.length];
            int j = 0;
            for (int i = 0; i < result.length; ++i) {
                if (Character.isDigit(source[i]) && this.isValidDigit(source[i])) {
                    result[j++] = source[i];
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
                Object s = this.getText(0, this.getLength());
                try {
                    if (((String)s).length() <= 0) continue;
                    s = offs == 0 ? str + (String)s : (String)s + str;
                    int numericValue = Integer.parseInt((String)s);
                    if (((String)s).length() <= 2 && (!this.isHours || numericValue >= 0 && numericValue <= 23) && (this.isHours || numericValue >= 0 && numericValue < 60)) continue;
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                catch (NumberFormatException e) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
            }
            super.insertString(offs, new String(result, 0, j), a);
        }

        private boolean isValidDigit(char c) {
            return c >= '0' && c <= '9';
        }
    }
}

