/*
 * Decompiled with CFR 0.152.
 */
package docking.options.editor;

import docking.options.editor.HistorySwatchPanel;
import docking.options.editor.MainSwatchPanel;
import docking.options.editor.RecentSwatchPanel;
import docking.options.editor.SwatchPanel;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.List;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;

public class SettableColorSwatchChooserPanel
extends AbstractColorChooserPanel {
    SwatchPanel swatchPanel;
    RecentSwatchPanel recentSwatchPanel;
    HistorySwatchPanel historySwatchPanel;
    MainSwatchListener mainSwatchListener;
    MouseListener recentSwatchListener;
    MouseListener historySwatchListener;
    private String recentStr = UIManager.getString("ColorChooser.swatchesRecentText");
    private List<Color> recentColors;

    public SettableColorSwatchChooserPanel(List<Color> recentColors) {
        this.setRecentColors(recentColors);
    }

    public void setRecentColors(List<Color> recentColors) {
        this.recentColors = recentColors;
        if (this.historySwatchPanel != null) {
            this.historySwatchPanel.setRecentColors(recentColors);
        }
    }

    @Override
    public String getDisplayName() {
        return UIManager.getString("ColorChooser.swatchesNameText");
    }

    private int overriddenGetInt(Object key, int defaultValue) {
        Object value = UIManager.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public int getMnemonic() {
        return this.overriddenGetInt("ColorChooser.swatchesMnemonic", -1);
    }

    @Override
    public int getDisplayedMnemonicIndex() {
        return this.overriddenGetInt("ColorChooser.swatchesDisplayedMnemonicIndex", -1);
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    public void installChooserPanel(JColorChooser enclosingChooser) {
        super.installChooserPanel(enclosingChooser);
    }

    @Override
    protected void buildChooser() {
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel superHolder = new JPanel(gb);
        this.swatchPanel = new MainSwatchPanel();
        this.swatchPanel.getAccessibleContext().setAccessibleName(this.getDisplayName());
        this.recentSwatchPanel = new RecentSwatchPanel();
        this.recentSwatchPanel.getAccessibleContext().setAccessibleName(this.recentStr);
        this.mainSwatchListener = new MainSwatchListener();
        this.swatchPanel.addMouseListener(this.mainSwatchListener);
        this.recentSwatchListener = new RecentSwatchListener();
        this.recentSwatchPanel.addMouseListener(this.recentSwatchListener);
        CompoundBorder border = new CompoundBorder(new LineBorder(Color.black), new LineBorder(Color.white));
        this.swatchPanel.setBorder(border);
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.gridheight = 2;
        gbc.weighty = 1.0;
        superHolder.add((Component)this.swatchPanel, gbc);
        this.recentSwatchPanel.addMouseListener(this.recentSwatchListener);
        this.recentSwatchPanel.setBorder(border);
        JPanel recentLabelHolder = new JPanel(new BorderLayout());
        JLabel l = new JLabel(this.recentStr);
        l.setLabelFor(this.recentSwatchPanel);
        recentLabelHolder.add((Component)l, "North");
        gbc.weighty = 0.0;
        gbc.gridwidth = 0;
        gbc.gridheight = 1;
        this.historySwatchPanel = new HistorySwatchPanel(this.recentColors);
        this.historySwatchListener = new HistorySwatchListener();
        this.historySwatchPanel.addMouseListener(this.historySwatchListener);
        this.historySwatchPanel.setBorder(border);
        JPanel historyLabelHolder = new JPanel(new BorderLayout());
        JLabel historyLabel = new JLabel("History:");
        historyLabel.setLabelFor(this.historySwatchPanel);
        historyLabelHolder.add((Component)historyLabel, "North");
        gbc.weighty = 0.0;
        gbc.gridwidth = 0;
        gbc.gridheight = 1;
        JPanel recentAndHistoryPanel = new JPanel((LayoutManager)new VerticalLayout(1));
        recentAndHistoryPanel.add(recentLabelHolder);
        recentAndHistoryPanel.add(this.recentSwatchPanel);
        recentAndHistoryPanel.add(Box.createVerticalStrut(2));
        recentAndHistoryPanel.add(historyLabelHolder);
        recentAndHistoryPanel.add(this.historySwatchPanel);
        superHolder.add(Box.createHorizontalStrut(5));
        superHolder.add(recentAndHistoryPanel);
        this.add(superHolder);
    }

    @Override
    public void uninstallChooserPanel(JColorChooser enclosingChooser) {
        super.uninstallChooserPanel(enclosingChooser);
        this.swatchPanel.removeMouseListener(this.mainSwatchListener);
        this.recentSwatchPanel.removeMouseListener(this.recentSwatchListener);
        this.historySwatchPanel.removeMouseListener(this.historySwatchListener);
        this.swatchPanel = null;
        this.recentSwatchPanel = null;
        this.recentSwatchListener = null;
        this.mainSwatchListener = null;
        this.removeAll();
    }

    @Override
    public void updateChooser() {
    }

    class MainSwatchListener
    extends MouseAdapter
    implements Serializable {
        MainSwatchListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Color color = SettableColorSwatchChooserPanel.this.swatchPanel.getColorForLocation(e.getX(), e.getY());
            SettableColorSwatchChooserPanel.this.getColorSelectionModel().setSelectedColor(color);
            SettableColorSwatchChooserPanel.this.recentSwatchPanel.setMostRecentColor(color);
        }
    }

    class RecentSwatchListener
    extends MouseAdapter {
        RecentSwatchListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Color color = SettableColorSwatchChooserPanel.this.recentSwatchPanel.getColorForLocation(e.getX(), e.getY());
            SettableColorSwatchChooserPanel.this.getColorSelectionModel().setSelectedColor(color);
        }
    }

    class HistorySwatchListener
    extends MouseAdapter {
        HistorySwatchListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Color color = SettableColorSwatchChooserPanel.this.historySwatchPanel.getColorForLocation(e.getX(), e.getY());
            SettableColorSwatchChooserPanel.this.getColorSelectionModel().setSelectedColor(color);
        }
    }
}

