/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.Util.AlignmentUtils;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.Input;

public abstract class Section<T extends Item> {
    protected final ArrayList<T> items;
    protected HashMap<T, T> uniqueItems = null;
    protected int offset = 0;
    public final ItemType ItemType;
    public final DexFile DexFile;

    protected Section(DexFile dexFile, ItemType itemType) {
        this.DexFile = dexFile;
        this.items = new ArrayList();
        this.ItemType = itemType;
    }

    protected int placeAt(int offset) {
        if (this.items.size() > 0) {
            offset = AlignmentUtils.alignOffset(offset, this.ItemType.ItemAlignment);
            assert (!this.DexFile.getInplace() || offset == this.offset);
            this.offset = offset;
            for (int i = 0; i < this.items.size(); ++i) {
                Item item = (Item)this.items.get(i);
                assert (item != null);
                offset = AlignmentUtils.alignOffset(offset, this.ItemType.ItemAlignment);
                offset = item.placeAt(offset, i);
            }
        } else {
            this.offset = 0;
        }
        return offset;
    }

    protected void writeTo(AnnotatedOutput out) {
        out.annotate(0, " ");
        out.annotate(0, "-----------------------------");
        out.annotate(0, this.ItemType.TypeName + " section");
        out.annotate(0, "-----------------------------");
        out.annotate(0, " ");
        for (Item item : this.items) {
            assert (item != null);
            out.alignTo(this.ItemType.ItemAlignment);
            item.writeTo(out);
            out.annotate(0, " ");
        }
    }

    protected void readFrom(int size, Input in, ReadContext readContext) {
        this.items.ensureCapacity(size);
        for (int i = this.items.size(); i < size; ++i) {
            this.items.add(null);
        }
        in.alignTo(this.ItemType.ItemAlignment);
        this.offset = in.getCursor();
        this.readItems(in, readContext);
    }

    protected abstract void readItems(Input var1, ReadContext var2);

    public int getOffset() {
        return this.offset;
    }

    public List<T> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    protected T intern(T item) {
        if (item == null) {
            return null;
        }
        T internedItem = this.getInternedItem(item);
        if (internedItem == null) {
            this.uniqueItems.put(item, item);
            this.items.add(item);
            return item;
        }
        return internedItem;
    }

    protected T getInternedItem(T item) {
        if (this.uniqueItems == null) {
            this.buildInternedItemMap();
        }
        return (T)((Item)this.uniqueItems.get(item));
    }

    private void buildInternedItemMap() {
        this.uniqueItems = new HashMap();
        for (Item item : this.items) {
            assert (item != null);
            this.uniqueItems.put(item, item);
        }
    }

    protected void sortSection() {
        Collections.sort(this.items);
    }
}

