/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.CursorPosition;
import docking.widgets.FindDialog;
import docking.widgets.FindDialogSearcher;
import docking.widgets.SearchLocation;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.decompiler.component.ClangTextField;
import ghidra.app.decompiler.component.DecompilerController;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.DecompilerCursorPosition;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.Component;
import java.util.List;

public class FindAction
extends DockingAction {
    private FindDialog findDialog;
    private final DecompilerPanel decompilerPanel;
    private final PluginTool tool;

    public FindAction(PluginTool tool, DecompilerController controller, String owner) {
        super("Find", owner);
        this.tool = tool;
        this.decompilerPanel = controller.getDecompilerPanel();
        this.setPopupMenuData(new MenuData(new String[]{"Find..."}, "Decompile"));
        this.setKeyBindingData(new KeyBindingData(70, 128));
        this.setEnabled(true);
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DecompilerActionContext)) {
            return false;
        }
        DecompilerActionContext decompilerActionContext = (DecompilerActionContext)context;
        if (decompilerActionContext.isDecompiling()) {
            return true;
        }
        return true;
    }

    public void actionPerformed(ActionContext context) {
        DecompilerActionContext decompilerActionContext = (DecompilerActionContext)context;
        if (decompilerActionContext.isDecompiling()) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)context.getComponentProvider().getComponent(), (String)"Decompiler Action Blocked", (Object)"You cannot perform Decompiler actions while the Decompiler is busy");
            return;
        }
        FindDialog dialog = this.getFindDialog();
        String text = this.decompilerPanel.getHighlightedText();
        if (text != null) {
            dialog.setSearchText(text);
        }
        this.tool.showDialog((DialogComponentProvider)dialog);
    }

    protected FindDialog getFindDialog() {
        if (this.findDialog == null) {
            this.findDialog = new FindDialog("Decompiler Find Text", new DecompilerSearcher()){

                protected void dialogClosed() {
                    FindAction.this.decompilerPanel.setSearchResults(null);
                }
            };
            this.findDialog.setHelpLocation(new HelpLocation("DecompilePlugin", "Find"));
        }
        return this.findDialog;
    }

    private class DecompilerSearcher
    implements FindDialogSearcher {
        private DecompilerSearcher() {
        }

        public CursorPosition getCursorPosition() {
            FieldLocation fieldLocation = FindAction.this.decompilerPanel.getCursorPosition();
            return new DecompilerCursorPosition(fieldLocation);
        }

        public CursorPosition getStart() {
            int lineNumber = 0;
            int fieldNumber = 0;
            int column = 0;
            FieldLocation fieldLocation = new FieldLocation(lineNumber, fieldNumber, 0, column);
            return new DecompilerCursorPosition(fieldLocation);
        }

        public CursorPosition getEnd() {
            List<Field> lines = FindAction.this.decompilerPanel.getFields();
            int lineNumber = lines.size() - 1;
            ClangTextField textLine = (ClangTextField)lines.get(lineNumber);
            int fieldNumber = 0;
            int rowCount = textLine.getNumRows();
            int row = rowCount - 1;
            int column = textLine.getNumCols(row);
            FieldLocation fieldLocation = new FieldLocation(lineNumber, fieldNumber, row, column);
            return new DecompilerCursorPosition(fieldLocation);
        }

        public void setCursorPosition(CursorPosition position) {
            FindAction.this.decompilerPanel.setCursorPosition(((DecompilerCursorPosition)position).getFieldLocation());
        }

        public void highlightSearchResults(SearchLocation location) {
            FindAction.this.decompilerPanel.setSearchResults(location);
        }

        public SearchLocation search(String text, CursorPosition position, boolean searchForward, boolean useRegex) {
            DecompilerCursorPosition decompilerCursorPosition = (DecompilerCursorPosition)position;
            FieldLocation fieldLocation = decompilerCursorPosition.getFieldLocation();
            return useRegex ? FindAction.this.decompilerPanel.searchTextRegex(text, fieldLocation, searchForward) : FindAction.this.decompilerPanel.searchText(text, fieldLocation, searchForward);
        }
    }
}

