/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangVariableToken;
import ghidra.app.decompiler.component.DecompilerController;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.RenameGlobalVariableTask;
import ghidra.app.plugin.core.decompile.actions.RenameStructureFieldTask;
import ghidra.app.plugin.core.decompile.actions.RenameTask;
import ghidra.app.plugin.core.decompile.actions.RenameVariableTask;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighGlobal;
import ghidra.program.model.pcode.HighLocal;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.LocalSymbolMap;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.Msg;
import ghidra.util.UndefinedFunction;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.awt.Component;

public class RenameVariableAction
extends DockingAction {
    private final DecompilerController controller;
    private final PluginTool tool;
    private RenameTask nameTask = null;

    public RenameVariableAction(String owner, PluginTool tool, DecompilerController controller) {
        super("Rename Variable", owner);
        this.tool = tool;
        this.controller = controller;
        this.setPopupMenuData(new MenuData(new String[]{"Rename Variable"}, "Decompile"));
        this.setKeyBindingData(new KeyBindingData(76, 0));
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DecompilerActionContext)) {
            return false;
        }
        Function function = this.controller.getFunction();
        if (function instanceof UndefinedFunction) {
            return false;
        }
        DecompilerActionContext decompilerActionContext = (DecompilerActionContext)context;
        if (decompilerActionContext.isDecompiling()) {
            return true;
        }
        DecompilerPanel decompilerPanel = this.controller.getDecompilerPanel();
        ClangToken tokenAtCursor = decompilerPanel.getTokenAtCursor();
        if (tokenAtCursor == null) {
            return false;
        }
        if (tokenAtCursor instanceof ClangFieldToken) {
            Structure dt = RenameVariableAction.getStructDataType(tokenAtCursor);
            if (dt == null) {
                return false;
            }
            this.getPopupMenuData().setMenuItemName("Rename Field");
            return true;
        }
        HighVariable variable = tokenAtCursor.getHighVariable();
        if (variable == null) {
            Address storageAddress = RenameVariableAction.getStorageAddress(tokenAtCursor, this.controller);
            if (storageAddress == null) {
                return false;
            }
            variable = RenameVariableAction.forgeHighVariable(storageAddress, this.controller);
            if (variable == null) {
                return false;
            }
        }
        if (variable instanceof HighLocal) {
            this.getPopupMenuData().setMenuItemName("Rename Variable");
            return true;
        }
        if (variable instanceof HighGlobal) {
            this.getPopupMenuData().setMenuItemName("Rename Global");
            return true;
        }
        return false;
    }

    public static Address getStorageAddress(ClangToken tokenAtCursor, DecompilerController controller) {
        Varnode vnode = tokenAtCursor.getVarnode();
        Address storageAddress = null;
        if (vnode != null) {
            storageAddress = vnode.getAddress();
        } else if (tokenAtCursor instanceof ClangVariableToken) {
            PcodeOp op = ((ClangVariableToken)tokenAtCursor).getPcodeOp();
            if (op == null) {
                return null;
            }
            if (op.getOpcode() == 66) {
                vnode = op.getInput(0);
                if (vnode.isRegister()) {
                    AddressSpace stackspace = controller.getProgram().getAddressFactory().getStackSpace();
                    if (stackspace != null) {
                        Address caddr = op.getInput(1).getAddress();
                        storageAddress = stackspace.getAddress(caddr.getOffset());
                    }
                } else {
                    Address caddr = op.getInput(1).getAddress();
                    storageAddress = controller.getLocation().getAddress().getNewAddress(caddr.getOffset());
                }
            }
        }
        return storageAddress;
    }

    public static HighVariable forgeHighVariable(Address addr, DecompilerController controller) {
        HighVariable res = null;
        Program program = controller.getProgram();
        HighFunction hfunc = controller.getDecompileData().getHighFunction();
        if (addr.isStackAddress()) {
            LocalSymbolMap lsym = hfunc.getLocalSymbolMap();
            HighSymbol hsym = lsym.findLocal(addr, null);
            if (hsym != null) {
                res = hsym.getHighVariable();
            }
        } else {
            Data data = program.getListing().getDataAt(addr);
            if (data != null) {
                DataType dt = data.getDataType();
                try {
                    res = new HighGlobal(data.getLabel(), dt, new Varnode(addr, dt.getLength()), null, hfunc);
                }
                catch (InvalidInputException e) {
                    Msg.error(RenameVariableAction.class, (Object)e.getMessage());
                }
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionContext context) {
        Address addr;
        DecompilerActionContext decompilerActionContext = (DecompilerActionContext)context;
        if (decompilerActionContext.isDecompiling()) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)context.getComponentProvider().getComponent(), (String)"Decompiler Action Blocked", (Object)"You cannot perform Decompiler actions while the Decompiler is busy");
            return;
        }
        DecompilerPanel decompilerPanel = this.controller.getDecompilerPanel();
        ClangToken tokenAtCursor = decompilerPanel.getTokenAtCursor();
        HighVariable variable = tokenAtCursor.getHighVariable();
        if (variable == null && tokenAtCursor instanceof ClangVariableToken) {
            addr = RenameVariableAction.getStorageAddress(tokenAtCursor, this.controller);
            variable = RenameVariableAction.forgeHighVariable(addr, this.controller);
        }
        if (variable instanceof HighLocal) {
            this.nameTask = new RenameVariableTask(this.tool, variable.getName(), this.controller.getHighFunction(), variable, tokenAtCursor.getVarnode(), SourceType.USER_DEFINED);
        } else if (variable instanceof HighGlobal) {
            addr = variable.getRepresentative().getAddress();
            if (addr == null || !addr.isMemoryAddress()) {
                Msg.showError((Object)((Object)this), (Component)this.tool.getToolFrame(), (String)"Rename Failed", (Object)"Memory storage not found for global variable");
                return;
            }
            this.nameTask = new RenameGlobalVariableTask(this.tool, tokenAtCursor.getText(), addr, this.controller.getProgram());
        } else if (tokenAtCursor instanceof ClangFieldToken) {
            Structure dt = RenameVariableAction.getStructDataType(tokenAtCursor);
            if (dt == null) {
                Msg.showError((Object)((Object)this), (Component)this.tool.getToolFrame(), (String)"Rename Failed", (Object)"Could not find structure datatype");
                return;
            }
            int offset = RenameVariableAction.getDataTypeOffset(tokenAtCursor);
            if (offset < 0 || offset >= dt.getLength()) {
                Msg.showError((Object)((Object)this), (Component)this.tool.getToolFrame(), (String)"Rename Failed", (Object)"Could not resolve field within structure");
                return;
            }
            this.nameTask = new RenameStructureFieldTask(this.tool, tokenAtCursor.getText(), dt, offset);
        } else {
            Msg.showError((Object)((Object)this), (Component)this.tool.getToolFrame(), (String)"Rename Failed", (Object)"Selected variable does not support renaming");
            return;
        }
        boolean dialogres = this.nameTask.runDialog();
        if (dialogres) {
            Program program = this.controller.getProgram();
            int transaction = program.startTransaction(this.nameTask.getTransactionName());
            boolean commit = false;
            try {
                this.nameTask.commit();
                commit = true;
            }
            catch (DuplicateNameException e) {
                Msg.showError((Object)((Object)this), (Component)this.tool.getToolFrame(), (String)"Rename Failed", (Object)e.getMessage());
            }
            catch (InvalidInputException e) {
                Msg.showError((Object)((Object)this), (Component)this.tool.getToolFrame(), (String)"Rename Failed", (Object)e.getMessage());
            }
            finally {
                program.endTransaction(transaction, commit);
            }
        }
    }

    public static Structure getStructDataType(ClangToken tok) {
        ClangFieldToken fieldtok = (ClangFieldToken)tok;
        DataType dt = fieldtok.getDataType();
        if (dt == null) {
            return null;
        }
        if (dt instanceof TypeDef) {
            dt = ((TypeDef)dt).getBaseDataType();
        }
        if (dt instanceof Structure) {
            return (Structure)dt;
        }
        return null;
    }

    public static int getDataTypeOffset(ClangToken tok) {
        return ((ClangFieldToken)tok).getOffset();
    }
}

