/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.util.VariableLocation;

public class VariableLocFieldLocation
extends VariableLocation {
    private String loc;

    public VariableLocFieldLocation(Program program, Address locationAddr, Variable var, int charOffset) {
        super(program, locationAddr, var, 0, charOffset);
        this.loc = var.getVariableStorage().toString();
    }

    public VariableLocFieldLocation(Program program, Variable var, int charOffset) {
        super(program, var, 0, charOffset);
        this.loc = var.getVariableStorage().toString();
    }

    public VariableLocFieldLocation() {
    }

    public String getLoc() {
        return this.loc;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.loc == null ? 0 : this.loc.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariableLocFieldLocation other = (VariableLocFieldLocation)obj;
        return !(this.loc == null ? other.loc != null : !this.loc.equals(other.loc));
    }

    @Override
    public void restoreState(Program program1, SaveState obj) {
        super.restoreState(program1, obj);
        this.loc = obj.getString("_LOC", "");
    }

    @Override
    public void saveState(SaveState obj) {
        super.saveState(obj);
        obj.putString("_LOC", this.loc);
    }
}

