/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework;

import ghidra.framework.Architecture;
import ghidra.framework.OperatingSystem;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public enum Platform {
    WIN_32(OperatingSystem.WINDOWS, Architecture.X86, "win32", ".dll", ".exe"),
    WIN_64(OperatingSystem.WINDOWS, Architecture.X86_64, "win64", ".dll", ".exe"),
    WIN_UNKOWN(OperatingSystem.WINDOWS, Architecture.UNKNOWN, "win32", ".dll", ".exe"),
    LINUX(OperatingSystem.LINUX, Architecture.X86, "linux32", ".so", ""),
    LINUX_64(OperatingSystem.LINUX, Architecture.X86_64, "linux64", ".so", ""),
    LINUX_UKNOWN(OperatingSystem.LINUX, Architecture.UNKNOWN, "linux32", ".so", ""),
    MAC_OSX_32(OperatingSystem.MAC_OS_X, Architecture.X86, "osx32", ".dylib", ""),
    MAC_OSX_64(OperatingSystem.MAC_OS_X, Architecture.X86_64, "osx64", ".dylib", ""),
    MAC_UNKNOWN(OperatingSystem.MAC_OS_X, Architecture.UNKNOWN, "osx64", ".dylib", ""),
    UNSUPPORTED(OperatingSystem.UNSUPPORTED, Architecture.UNKNOWN, null, null, "");

    public static final Platform CURRENT_PLATFORM;
    private OperatingSystem operatingSystem;
    private Architecture architecture;
    private String directoryName;
    private String libraryExtension;
    private final String executableExtension;

    private Platform(OperatingSystem operatingSystem, Architecture architecture, String directoryName, String libraryExtension, String executableExtension) {
        this.operatingSystem = operatingSystem;
        this.architecture = architecture;
        this.directoryName = directoryName;
        this.libraryExtension = libraryExtension;
        this.executableExtension = executableExtension;
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public Architecture getArchitecture() {
        return this.architecture;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public String getLibraryExtension() {
        return this.libraryExtension;
    }

    public List<String> getAdditionalLibraryPaths() {
        File syswow64;
        String windir;
        ArrayList<String> paths = new ArrayList<String>();
        if (this.operatingSystem == OperatingSystem.LINUX) {
            paths.add("/bin");
            paths.add("/lib");
            paths.add("/usr/bin");
            paths.add("/usr/lib");
            paths.add("/usr/X11R6/bin");
            paths.add("/usr/X11R6/lib");
        } else if (CURRENT_PLATFORM == WIN_64 && (windir = System.getenv("SystemRoot")) != null && (syswow64 = new File(windir, "SysWOW64")).isDirectory()) {
            paths.add(syswow64.getAbsolutePath());
        }
        return paths;
    }

    public String toString() {
        return this.operatingSystem.toString() + " " + this.architecture.toString();
    }

    private static Platform findCurrentPlatform() {
        for (Platform platform : Platform.values()) {
            if (!Platform.matchesCurrentPlatform(platform)) continue;
            return platform;
        }
        return UNSUPPORTED;
    }

    private static boolean matchesCurrentPlatform(Platform platform) {
        return platform.operatingSystem == OperatingSystem.CURRENT_OPERATING_SYSTEM && platform.architecture == Architecture.CURRENT_ARCHITECTURE;
    }

    public String getExecutableExtension() {
        return this.executableExtension;
    }

    static {
        CURRENT_PLATFORM = Platform.findCurrentPlatform();
    }
}

