/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.prop;

import ghidra.util.Saveable;
import ghidra.util.datastruct.BitTree;
import ghidra.util.datastruct.DataTable;
import ghidra.util.datastruct.FullKeySet;
import ghidra.util.datastruct.RedBlackKeySet;
import ghidra.util.datastruct.ShortKeyIndexer;
import ghidra.util.datastruct.ShortKeySet;
import ghidra.util.exception.NoValueException;
import ghidra.util.prop.ObjectStorageAdapter;
import java.io.Serializable;

class PropertyPage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ShortKeyIndexer indexer;
    private ShortKeySet keySet;
    private DataTable table;
    private short pageSize;
    private int switchSize;
    private Class<?> objectClass;
    private NoValueException noValueException;
    private final int threshold;

    PropertyPage(short pageSize, long pageID, int valueSize, Class<?> objectClass) {
        this.keySet = new RedBlackKeySet((short)(pageSize - 1));
        this.pageSize = pageSize;
        this.objectClass = objectClass;
        this.table = new DataTable();
        this.indexer = new ShortKeyIndexer();
        this.threshold = pageSize / 60;
        this.switchSize = valueSize * pageSize / (12 + valueSize);
        this.noValueException = new NoValueException();
    }

    short getNext(short offset) {
        return this.keySet.getNext(offset);
    }

    void addKey(short key) {
        short oldKey;
        if (this.keySet.size() == this.switchSize && this.indexer != null) {
            DataTable newTable = new DataTable();
            oldKey = this.keySet.getFirst();
            while (oldKey != -1) {
                this.table.copyRowTo(this.indexer.get(oldKey), newTable, oldKey);
                oldKey = this.keySet.getNext(oldKey);
            }
            this.indexer = null;
            this.table = newTable;
        }
        if (this.keySet.size() == this.threshold && this.keySet instanceof RedBlackKeySet) {
            BitTree newKeySet = new BitTree((short)(this.pageSize - 1));
            oldKey = this.keySet.getFirst();
            while (oldKey != -1) {
                newKeySet.put(oldKey);
                oldKey = this.keySet.getNext(oldKey);
            }
            this.keySet = newKeySet;
        }
        this.keySet.put(key);
        if (this.keySet.size() == this.pageSize && !(this.keySet instanceof FullKeySet)) {
            this.keySet = new FullKeySet(this.pageSize);
        }
    }

    void addKeys(short startKey, short endKey) {
        if (startKey == 0 && endKey == this.pageSize - 1) {
            this.keySet = new FullKeySet(this.pageSize);
        } else {
            for (short i = startKey; i <= endKey; i = (short)(i + 1)) {
                this.addKey(i);
            }
        }
    }

    short getPrevious(short offset) {
        return this.keySet.getPrevious(offset);
    }

    short getFirst() {
        return this.keySet.getFirst();
    }

    short getLast() {
        return this.keySet.getLast();
    }

    boolean isEmpty() {
        return this.keySet.isEmpty();
    }

    boolean hasProperty(short offset) {
        return this.keySet.containsKey(offset);
    }

    private int getRow(short offset, boolean forceRow) {
        if (this.indexer != null) {
            if (forceRow) {
                return this.indexer.put(offset);
            }
            return this.indexer.get(offset);
        }
        return offset;
    }

    Saveable getSaveableObject(short offset) {
        if (this.keySet.containsKey(offset)) {
            int row = this.getRow(offset, false);
            try {
                Saveable so = (Saveable)this.objectClass.newInstance();
                so.restore(new ObjectStorageAdapter(this.table, row));
                return so;
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
        }
        return null;
    }

    void addSaveableObject(short offset, Saveable value) {
        this.addKey(offset);
        int row = this.getRow(offset, true);
        value.save(new ObjectStorageAdapter(this.table, row));
    }

    Object getObject(short offset) {
        if (this.keySet.containsKey(offset)) {
            int row = this.getRow(offset, false);
            return this.table.getObject(row, 0);
        }
        return null;
    }

    void addObject(short offset, Object value) {
        this.addKey(offset);
        int row = this.getRow(offset, true);
        this.table.putObject(row, 0, value);
    }

    String getString(short offset) {
        if (this.keySet.containsKey(offset)) {
            int row = this.getRow(offset, false);
            return this.table.getString(row, 0);
        }
        return null;
    }

    void addString(short offset, String value) {
        this.addKey(offset);
        int row = this.getRow(offset, true);
        this.table.putString(row, 0, value);
    }

    int getInt(short offset) throws NoValueException {
        if (this.keySet.containsKey(offset)) {
            int row = this.getRow(offset, false);
            return this.table.getInt(row, 0);
        }
        throw this.noValueException;
    }

    void addInt(short offset, int value) {
        this.addKey(offset);
        int row = this.getRow(offset, true);
        this.table.putInt(row, 0, value);
    }

    long getLong(short offset) throws NoValueException {
        if (this.keySet.containsKey(offset)) {
            int row = this.getRow(offset, false);
            return this.table.getLong(row, 0);
        }
        throw this.noValueException;
    }

    void addLong(short offset, long value) {
        this.addKey(offset);
        int row = this.getRow(offset, true);
        this.table.putLong(row, 0, value);
    }

    short getShort(short offset) throws NoValueException {
        if (this.keySet.containsKey(offset)) {
            int row = this.getRow(offset, false);
            return this.table.getShort(row, 0);
        }
        throw this.noValueException;
    }

    void addShort(short offset, short value) {
        this.addKey(offset);
        int row = this.getRow(offset, true);
        this.table.putShort(row, 0, value);
    }

    byte getByte(short offset) throws NoValueException {
        if (this.keySet.containsKey(offset)) {
            int row = this.getRow(offset, false);
            return this.table.getByte(row, 0);
        }
        throw this.noValueException;
    }

    void addByte(short offset, byte value) {
        this.addKey(offset);
        int row = this.getRow(offset, true);
        this.table.putByte(row, 0, value);
    }

    void add(short offset) {
        this.addKey(offset);
    }

    void addRange(short startOffset, short endOffset) {
        this.addKeys(startOffset, endOffset);
    }

    int getSize() {
        return this.keySet.size();
    }

    boolean remove(short offset) {
        int row;
        if (this.keySet instanceof FullKeySet) {
            this.keySet = new BitTree((short)(this.pageSize - 1), true);
        }
        boolean result = this.keySet.remove(offset);
        if (this.keySet.size() == 0) {
            this.keySet = new RedBlackKeySet((short)(this.pageSize - 1));
        }
        if ((row = this.getRow(offset, false)) >= 0) {
            this.table.removeRow(row);
        }
        if (this.keySet.size() < this.switchSize / 2 && this.indexer == null) {
            DataTable newTable = new DataTable();
            this.indexer = new ShortKeyIndexer();
            short oldKey = this.keySet.getFirst();
            while (oldKey != -1) {
                short newRow = this.indexer.put(oldKey);
                this.table.copyRowTo(oldKey, newTable, newRow);
                oldKey = this.keySet.getNext(oldKey);
            }
            this.table = newTable;
        }
        return result;
    }
}

