/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.instructionsearch.ui;

import ghidra.app.plugin.core.instructionsearch.ui.ControlPanelWidget;
import ghidra.app.plugin.core.instructionsearch.ui.InsertBytesWidget;
import ghidra.app.plugin.core.instructionsearch.util.InstructionSearchUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SelectionModeWidget
extends ControlPanelWidget {
    public JRadioButton hexRB;
    public JRadioButton binaryRB;
    private InputMode inputMode = InputMode.HEX;
    InsertBytesWidget parent;

    public SelectionModeWidget(String title, InsertBytesWidget parent) {
        super(title);
        this.parent = parent;
    }

    @Override
    protected JPanel createContent() {
        JPanel rbPanel = new JPanel();
        this.hexRB = new JRadioButton("hex");
        this.binaryRB = new JRadioButton("binary");
        ButtonGroup inputGroup = new ButtonGroup();
        inputGroup.add(this.hexRB);
        inputGroup.add(this.binaryRB);
        rbPanel.add(this.hexRB);
        rbPanel.add(this.binaryRB);
        this.hexRB.setSelected(true);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)rbPanel, "Center");
        this.hexRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SelectionModeWidget.this.parent.validateInput()) {
                    return;
                }
                if (SelectionModeWidget.this.inputMode == InputMode.HEX) {
                    return;
                }
                SelectionModeWidget.this.inputMode = InputMode.HEX;
                List<String> whitespaces = InstructionSearchUtils.getWhitespace(SelectionModeWidget.this.parent.getInputString().trim());
                try {
                    List<Integer> groups = InstructionSearchUtils.getGroupSizes(SelectionModeWidget.this.parent.getInputString().trim(), InputMode.BINARY);
                    String hexStr = InstructionSearchUtils.toHex(SelectionModeWidget.this.parent.getInputString().trim(), true);
                    hexStr = SelectionModeWidget.this.restoreGroupingAndWhitespace(hexStr, groups, whitespaces, InputMode.HEX);
                    SelectionModeWidget.this.parent.setInputString(hexStr);
                    SelectionModeWidget.this.parent.validateInput();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.binaryRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SelectionModeWidget.this.parent.validateInput()) {
                    return;
                }
                if (SelectionModeWidget.this.inputMode == InputMode.BINARY) {
                    return;
                }
                SelectionModeWidget.this.inputMode = InputMode.BINARY;
                List<String> whitespaces = InstructionSearchUtils.getWhitespace(SelectionModeWidget.this.parent.getInputString().trim());
                try {
                    List<Integer> groups = InstructionSearchUtils.getGroupSizes(SelectionModeWidget.this.parent.getInputString().trim(), InputMode.HEX);
                    String binaryStr = InstructionSearchUtils.toBinary(SelectionModeWidget.this.parent.getInputString().trim());
                    binaryStr = SelectionModeWidget.this.restoreGroupingAndWhitespace(binaryStr, groups, whitespaces, InputMode.BINARY);
                    SelectionModeWidget.this.parent.setInputString(binaryStr);
                    SelectionModeWidget.this.parent.validateInput();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        return mainPanel;
    }

    public InputMode getInputMode() {
        if (this.hexRB.isSelected()) {
            this.inputMode = InputMode.HEX;
        } else if (this.binaryRB.isSelected()) {
            this.inputMode = InputMode.BINARY;
        }
        return this.inputMode;
    }

    public void setInputMode(InputMode mode) {
        this.inputMode = mode;
        if (mode == InputMode.BINARY) {
            this.binaryRB.setSelected(true);
        } else if (mode == InputMode.HEX) {
            this.hexRB.setSelected(true);
        }
    }

    private String restoreGroupingAndWhitespace(String source, List<Integer> groups, List<String> whitespace, InputMode mode) {
        source = source.replaceAll("\\s", "");
        int modeModifier = mode == InputMode.BINARY ? 8 : 2;
        int whitespaceIndex = 0;
        StringBuilder sb = new StringBuilder();
        for (Integer group : groups) {
            sb.append(source.substring(0, group * modeModifier));
            if (whitespaceIndex < whitespace.size()) {
                sb.append(whitespace.get(whitespaceIndex));
                ++whitespaceIndex;
            }
            source = source.substring(group * modeModifier);
        }
        return sb.toString();
    }

    public static enum InputMode {
        BINARY,
        HEX;

    }
}

