/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation.locationreferences;

import docking.widgets.fieldpanel.support.Highlight;
import ghidra.app.plugin.core.navigation.locationreferences.LocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReference;
import ghidra.app.plugin.core.navigation.locationreferences.ReferenceUtils;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.FieldNameFieldFactory;
import ghidra.app.util.viewer.field.MnemonicFieldFactory;
import ghidra.app.util.viewer.field.OperandFieldFactory;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.Msg;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class StructureMemberLocationDescriptor
extends LocationDescriptor {
    private Data parentData;
    private Address parentAddress;
    private List<Data> dataPathList;
    private String fieldName;

    public StructureMemberLocationDescriptor(ProgramLocation memberLocation, String fieldName, Program program) {
        super(memberLocation, program);
        Listing listing = program.getListing();
        CodeUnit codeUnit = listing.getCodeUnitContaining(memberLocation.getAddress());
        if (codeUnit == null) {
            throw new AssertException("Expected a structure at the given location: " + memberLocation);
        }
        if (!(codeUnit instanceof Data)) {
            throw new AssertException("Expected a structure at the given location: " + memberLocation);
        }
        this.parentData = (Data)codeUnit;
        this.parentAddress = this.parentData.getMinAddress();
        long offset = memberLocation.getAddress().subtract(this.parentAddress);
        Data lowestLevelData = this.parentData.getPrimitiveAt((int)offset);
        this.label = lowestLevelData.getPathName();
        this.homeAddress = memberLocation.getAddress();
        this.dataPathList = this.getDataPath(lowestLevelData);
        this.fieldName = fieldName;
    }

    private List<Data> getDataPath(Data leafData) {
        ArrayList<Data> list = new ArrayList<Data>();
        list.add(leafData);
        for (Data parent = leafData.getParent(); parent != null; parent = parent.getParent()) {
            list.add(parent);
        }
        return list;
    }

    @Override
    public String getTypeName() {
        Composite composite = this.getLowestNonLeafComposite();
        String name = composite.getDisplayName();
        if (this.fieldName != null) {
            return name + "." + this.fieldName;
        }
        return name;
    }

    @Override
    protected void doGetReferences(Accumulator<LocationReference> accumulator, TaskMonitor monitor) throws CancelledException {
        Composite composite = this.getLowestNonLeafComposite();
        ReferenceUtils.findDataTypeReferences(accumulator, (DataType)composite, this.fieldName, this.program, this.useDynamicSearching, monitor);
    }

    private Composite getLowestNonLeafComposite() {
        int i = 0;
        if (this.fieldName != null) {
            i = 1;
        }
        while (i < this.dataPathList.size()) {
            Data data = this.dataPathList.get(i);
            DataType dt = data.getDataType();
            if (dt instanceof Composite) {
                return (Composite)dt;
            }
            ++i;
        }
        Msg.error((Object)this, (Object)("Could not find a Composite inside of a Structure Member location: " + this.toString()));
        return null;
    }

    @Override
    ProgramLocation getHomeLocation() {
        return this.programLocation;
    }

    @Override
    protected boolean isInAddresses(Address address) {
        if (address == null) {
            return false;
        }
        if (super.isInAddresses(address)) {
            return true;
        }
        return this.isAddressInDataPath(address);
    }

    private boolean isAddressInDataPath(Address address) {
        if (address == null) {
            return false;
        }
        for (Data component : this.dataPathList) {
            Address componentAddress = component.getMinAddress();
            if (!address.equals((Object)componentAddress)) continue;
            return true;
        }
        return false;
    }

    private Data getFieldData(Address address, String fieldNameText) {
        for (Data component : this.dataPathList) {
            String name;
            Address componentAddress = component.getMinAddress();
            if (!address.equals((Object)componentAddress) || !fieldNameText.equals(name = component.getFieldName())) continue;
            return component;
        }
        return null;
    }

    @Override
    Highlight[] getHighlights(String text, Object object, Class<? extends FieldFactory> fieldFactoryClass, Color highlightColor) {
        Data data;
        Address currentAddress = this.getAddressForHighlightObject(object);
        if (!this.isInAddresses(currentAddress)) {
            return this.EMPTY_HIGHLIGHTS;
        }
        if (MnemonicFieldFactory.class.isAssignableFrom(fieldFactoryClass) && object instanceof Data) {
            String representation;
            int offset;
            if (currentAddress.equals((Object)this.parentAddress) && (offset = text.indexOf(representation = this.parentData.toString().trim())) != -1) {
                return new Highlight[]{new Highlight(offset, this.label.length() + offset - 1, highlightColor)};
            }
        } else if (OperandFieldFactory.class.isAssignableFrom(fieldFactoryClass)) {
            int offset = text.indexOf(this.label);
            if (offset != -1) {
                return new Highlight[]{new Highlight(offset, offset + this.label.length() - 1, highlightColor)};
            }
        } else if (FieldNameFieldFactory.class.isAssignableFrom(fieldFactoryClass) && (data = this.getFieldData(currentAddress, text)) != null) {
            return new Highlight[]{new Highlight(0, text.length(), highlightColor)};
        }
        return this.EMPTY_HIGHLIGHTS;
    }
}

