/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree;

import docking.DialogComponentProvider;
import ghidra.app.plugin.core.symboltree.EditExternalLocationPanel;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class EditExternalLocationDialog
extends DialogComponentProvider {
    static final int PREFERRED_CREATE_PANEL_HEIGHT = 240;
    static final int PREFERRED_EDIT_PANEL_HEIGHT = 220;
    static final int PREFERRED_PANEL_WIDTH = 450;
    private static final HelpLocation CREATE_HELP = new HelpLocation("SymbolTreePlugin", "createExternalLocation");
    private static final HelpLocation EDIT_HELP = new HelpLocation("SymbolTreePlugin", "editExternalLocation");
    private EditExternalLocationPanel extLocPanel;
    private Program program;
    private ExternalLocation externalLocation;
    private String externalLibraryName;
    private String locationName;
    private Address address;

    public EditExternalLocationDialog(ExternalLocation externalLocation) {
        super("Edit External Location", true);
        this.externalLocation = externalLocation;
        this.program = externalLocation.getSymbol().getProgram();
        this.setRememberSize(false);
        this.addWorkPanel(this.buildMainPanel());
        this.addApplyButton();
        this.addCancelButton();
        this.initDialog();
        this.setDefaultButton(this.applyButton);
    }

    public EditExternalLocationDialog(Program program, String externalLibraryName) {
        super("Create External Location", true);
        this.program = program;
        this.externalLibraryName = externalLibraryName;
        this.setRememberSize(false);
        this.addWorkPanel(this.buildMainPanel());
        this.addApplyButton();
        this.addCancelButton();
        this.initDialog();
        this.setDefaultButton(this.applyButton);
    }

    public void dispose() {
        this.close();
        this.cleanup();
    }

    private void cleanup() {
        this.extLocPanel.cleanup();
    }

    private JComponent buildMainPanel() {
        EmptyBorder panelBorder = new EmptyBorder(5, 10, 5, 10);
        this.extLocPanel = this.externalLocation != null ? new EditExternalLocationPanel(this.externalLocation) : new EditExternalLocationPanel(this.program, this.externalLibraryName);
        this.extLocPanel.setBorder(panelBorder);
        int panelHeight = this.externalLocation != null ? 220 : 240;
        this.extLocPanel.setPreferredSize(new Dimension(450, panelHeight));
        JPanel workPanel = new JPanel(new BorderLayout());
        workPanel.add((Component)this.extLocPanel, "Center");
        return workPanel;
    }

    void initDialog() {
        if (this.externalLocation != null) {
            this.setTitle("Edit External Location (" + this.getEditName() + ")");
            this.setHelpLocation(EDIT_HELP);
            this.applyButton.setText("Update");
        } else {
            this.setTitle("Create External Location");
            this.setHelpLocation(CREATE_HELP);
            this.applyButton.setText("Create");
        }
    }

    private String getEditName() {
        boolean hasName;
        if (this.externalLocation != null) {
            Symbol symbol = this.externalLocation.getSymbol();
            Object name = symbol.getName(true);
            Address addr = this.externalLocation.getAddress();
            if (addr != null) {
                name = (String)name + " @ " + addr.toString(true);
            }
            return name;
        }
        Object editName = this.externalLocation.getSymbol().getParentNamespace().getName(true);
        boolean bl = hasName = this.locationName != null && this.locationName.length() > 0;
        if (hasName) {
            editName = (String)editName + "::" + this.locationName;
        }
        if (this.address != null) {
            editName = (String)editName + " @ " + this.address.toString();
        }
        return editName;
    }

    protected void applyCallback() {
        if (this.extLocPanel.applyLocation()) {
            this.close();
            this.cleanup();
        }
    }

    protected void cancelCallback() {
        this.close();
        this.cleanup();
    }
}

