/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symtable;

import ghidra.app.plugin.core.symtable.ReferenceProvider;
import ghidra.app.plugin.core.symtable.SymbolReferenceModel;
import ghidra.app.plugin.core.symtable.SymbolRenderer;
import ghidra.app.services.GoToService;
import ghidra.program.model.symbol.Reference;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraThreadedTablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

class ReferencePanel
extends JPanel {
    private ReferenceProvider referenceProvider;
    private GhidraTable refTable;
    private TableModelListener listener;
    private GhidraThreadedTablePanel<Reference> threadedTablePanel;

    ReferencePanel(ReferenceProvider provider, SymbolReferenceModel model, SymbolRenderer renderer, GoToService gotoService) {
        super(new BorderLayout());
        this.referenceProvider = provider;
        this.threadedTablePanel = new GhidraThreadedTablePanel<Reference>(model);
        this.refTable = this.threadedTablePanel.getTable();
        this.refTable.setAutoLookupColumn(1);
        this.refTable.setName("ReferenceTable");
        this.refTable.setPreferredScrollableViewportSize(new Dimension(250, 200));
        this.refTable.setSelectionMode(0);
        this.refTable.installNavigation(gotoService, gotoService.getDefaultNavigatable());
        this.listener = e -> this.referenceProvider.updateTitle();
        this.refTable.getModel().addTableModelListener(this.listener);
        for (int i = 0; i < this.refTable.getColumnCount(); ++i) {
            TableColumn column = this.refTable.getColumnModel().getColumn(i);
            if (column.getModelIndex() != 1) continue;
            column.setCellRenderer((TableCellRenderer)((Object)renderer));
        }
        this.add((Component)((Object)this.threadedTablePanel), "Center");
    }

    GhidraTable getTable() {
        return this.refTable;
    }

    void dispose() {
        TableModel model = this.refTable.getModel();
        model.removeTableModelListener(this.listener);
        this.threadedTablePanel.dispose();
        this.refTable.dispose();
        this.referenceProvider = null;
    }
}

