/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.GhidraRandomAccessFile;
import ghidra.formats.gfilesystem.FSRL;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RandomAccessByteProvider
implements ByteProvider {
    protected File file;
    protected GhidraRandomAccessFile randomAccessFile;
    private FSRL fsrl;

    public RandomAccessByteProvider(File file) throws IOException {
        this.file = file;
        this.randomAccessFile = new GhidraRandomAccessFile(file, "r");
    }

    public RandomAccessByteProvider(File file, FSRL fsrl) throws IOException {
        this.file = file;
        this.fsrl = fsrl;
        this.randomAccessFile = new GhidraRandomAccessFile(file, "r");
    }

    public RandomAccessByteProvider(File file, String permissions) throws IOException {
        this.file = file;
        this.randomAccessFile = new GhidraRandomAccessFile(file, permissions);
    }

    @Override
    public FSRL getFSRL() {
        return this.fsrl;
    }

    public void setFSRL(FSRL fsrl) {
        this.fsrl = fsrl;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public String getName() {
        return this.fsrl == null ? this.file.getName() : this.fsrl.getName();
    }

    @Override
    public String getAbsolutePath() {
        return this.fsrl == null ? this.file.getAbsolutePath() : this.fsrl.getPath();
    }

    @Override
    public InputStream getInputStream(long index) throws IOException {
        FileInputStream is = new FileInputStream(this.file);
        is.skip(index);
        return is;
    }

    @Override
    public void close() throws IOException {
        this.randomAccessFile.close();
    }

    @Override
    public long length() throws IOException {
        return this.randomAccessFile.length();
    }

    @Override
    public boolean isValidIndex(long index) {
        try {
            return index >= 0L && index < this.randomAccessFile.length();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public byte readByte(long index) throws IOException {
        this.randomAccessFile.seek(index);
        return this.randomAccessFile.readByte();
    }

    @Override
    public byte[] readBytes(long index, long length) throws IOException {
        this.randomAccessFile.seek(index);
        byte[] b = new byte[(int)length];
        int nRead = this.randomAccessFile.read(b);
        if ((long)nRead != length) {
            throw new IOException("Unable to read " + length + " bytes");
        }
        return b;
    }
}

