/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.OmfRecord;
import java.io.IOException;

public class OmfCommentRecord
extends OmfRecord {
    private byte commentType;
    private byte commentClass;
    private String value;

    public OmfCommentRecord(BinaryReader reader) throws IOException {
        this.readRecordHeader(reader);
        this.commentType = reader.readNextByte();
        this.commentClass = reader.readNextByte();
        byte[] bytes = reader.readNextByteArray(this.getRecordLength() - 3);
        if (this.commentClass == 0 || this.commentClass == -93) {
            int len = bytes[0] & 0xFF;
            this.value = new String(bytes, 1, len);
        }
        this.readCheckSumByte(reader);
    }

    public byte getCommentClass() {
        return this.commentClass;
    }

    public String getValue() {
        return this.value;
    }
}

