/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.blobs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig;
import ghidra.app.util.bin.format.pe.cli.blobs.CliBlob;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;

public class CliSigMethodDef
extends CliAbstractSig {
    private CliAbstractSig.CliRetType retType;
    private CliAbstractSig.CliParam[] params;
    private int sizeOfCount;
    private int genericParamCount;
    private int sizeOfGenericCount;

    public CliSigMethodDef(CliBlob blob) throws IOException {
        super(blob);
        long origIndex;
        BinaryReader reader = this.getContentsReader();
        byte firstByte = reader.readNextByte();
        if ((firstByte & 0x10) == 16) {
            origIndex = reader.getPointerIndex();
            this.genericParamCount = CliSigMethodDef.decodeCompressedUnsignedInt(reader);
            this.sizeOfGenericCount = (int)(reader.getPointerIndex() - origIndex);
        }
        origIndex = reader.getPointerIndex();
        int paramCount = CliSigMethodDef.decodeCompressedUnsignedInt(reader);
        this.sizeOfCount = (int)(reader.getPointerIndex() - origIndex);
        try {
            this.retType = new CliAbstractSig.CliRetType(this, reader);
        }
        catch (InvalidInputException e) {
            this.retType = null;
        }
        this.params = new CliAbstractSig.CliParam[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            try {
                this.params[i] = new CliAbstractSig.CliParam(this, reader);
                continue;
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getContentsName() {
        return "MethodDefSig";
    }

    @Override
    public String getContentsComment() {
        return "Type info for method return and params";
    }

    @Override
    public DataType getContentsDataType() {
        StructureDataType struct = new StructureDataType(new CategoryPath("/PE/CLI/Blobs/Signatures"), this.getName(), 0);
        struct.add(BYTE, "FirstByte", "ORed calling convention and THIS presence");
        if (this.genericParamCount > 0) {
            struct.add(CliSigMethodDef.getDataTypeForBytes(this.sizeOfGenericCount), "GenParamCount", "Number of generic paramameters for the method");
        }
        struct.add(CliSigMethodDef.getDataTypeForBytes(this.sizeOfCount), "Count", "Number of param types to follow RetType");
        struct.add(this.retType.getDefinitionDataType(), "RetType", null);
        for (CliAbstractSig.CliParam param : this.params) {
            struct.add(param.getDefinitionDataType(), null, null);
        }
        return struct;
    }

    public CliAbstractSig.CliRetType getReturnType() {
        return this.retType;
    }

    public CliAbstractSig.CliParam[] getParamTypes() {
        return (CliAbstractSig.CliParam[])this.params.clone();
    }

    @Override
    protected String getRepresentationCommon(CliStreamMetadata stream, boolean isShort) {
        Object rep = this.getRepresentationOf(this.retType, stream, isShort);
        rep = (String)rep + " fn(";
        for (CliAbstractSig.CliParam param : this.params) {
            rep = param == null ? (String)rep + "unidentified_param_type, " : (String)rep + this.getRepresentationOf(param, stream, isShort) + ", ";
        }
        if (this.params.length > 0) {
            rep = ((String)rep).substring(0, ((String)rep).length() - 2);
        }
        rep = (String)rep + ")";
        return rep;
    }
}

