/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.app.util.bin.format.pe.cli.tables.indexes.CliIndexTypeDefOrRef;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;

public class CliTableGenericParamConstraint
extends CliAbstractTable {
    public CliTableGenericParamConstraint(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        for (int i = 0; i < this.numRows; ++i) {
            this.rows.add(new CliGenericParamConstraintRow(this.readTableIndex(reader, CliTypeTable.GenericParam), CliIndexTypeDefOrRef.readCodedIndex(reader, stream)));
        }
        reader.setPointerIndex(this.readerOffset);
    }

    public StructureDataType getRowDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "GenericParamConstraint Row", 0);
        rowDt.add(this.metadataStream.getTableIndexDataType(CliTypeTable.GenericParam), "Owner", "index into GenericParam table");
        rowDt.add(CliIndexTypeDefOrRef.toDataType(this.metadataStream), "Constraint", "class/interface this param is constrained to derive/implement");
        return rowDt;
    }

    public class CliGenericParamConstraintRow
    extends CliAbstractTableRow {
        public int ownerIndex;
        public int constraintIndex;

        public CliGenericParamConstraintRow(int ownerIndex, int constraintIndex) {
            this.ownerIndex = ownerIndex;
            this.constraintIndex = constraintIndex;
        }

        @Override
        public String getRepresentation() {
            String constraintRep;
            try {
                constraintRep = CliTableGenericParamConstraint.this.getRowRepresentationSafe(CliIndexTypeDefOrRef.getTableName(this.constraintIndex), CliIndexTypeDefOrRef.getRowIndex(this.constraintIndex));
            }
            catch (InvalidInputException e) {
                constraintRep = Integer.toHexString(this.constraintIndex);
            }
            return String.format("Constraint %s Owner %s", constraintRep, CliTableGenericParamConstraint.this.getRowRepresentationSafe(CliTypeTable.GenericParam, this.ownerIndex));
        }
    }
}

