/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.html;

import ghidra.app.util.datatype.DataTypeIdUrl;
import ghidra.app.util.html.DataTypeLine;
import ghidra.app.util.html.EmptyDataTypeLine;
import ghidra.app.util.html.HTMLDataTypeRepresentation;
import ghidra.app.util.html.HTMLDataTypeRepresentationDiffInput;
import ghidra.app.util.html.PlaceHolderLine;
import ghidra.app.util.html.TextLine;
import ghidra.app.util.html.ValidatableLine;
import ghidra.app.util.html.diff.DataTypeDiff;
import ghidra.app.util.html.diff.DataTypeDiffBuilder;
import ghidra.app.util.html.diff.DiffLines;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.Union;
import ghidra.util.HTMLUtilities;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class CompositeDataTypeHTMLRepresentation
extends HTMLDataTypeRepresentation {
    private static final int MAX_COMPONENT_COUNT = 100;
    protected List<String> warningLines;
    protected List<ValidatableLine> headerContent;
    protected List<ValidatableLine> bodyContent;
    protected TextLine footerText;
    protected TextLine displayName;
    protected List<ValidatableLine> alignmentText;
    protected TextLine alignmentValueText;
    protected static final String ALIGNMENT_VALUE_PREFIX = "Alignment: ";

    protected CompositeDataTypeHTMLRepresentation(List<String> warningLines, List<ValidatableLine> header, List<ValidatableLine> bodyContent, List<ValidatableLine> alignmentText, TextLine footerText, TextLine displayName, TextLine alignmentValue) {
        this.warningLines = warningLines;
        this.headerContent = header;
        this.bodyContent = bodyContent;
        this.footerText = footerText;
        this.displayName = displayName;
        this.alignmentText = alignmentText;
        this.alignmentValueText = alignmentValue;
        this.originalHTMLData = CompositeDataTypeHTMLRepresentation.buildHTMLText(warningLines, header, displayName, bodyContent, alignmentText, footerText, this.alignmentValueText);
    }

    public CompositeDataTypeHTMLRepresentation(Composite comp) {
        this.warningLines = this.buildWarnings(comp);
        this.headerContent = this.buildHeaderText((DataType)comp);
        this.bodyContent = this.buildContent(comp);
        this.alignmentText = this.buildAlignmentText(comp);
        this.footerText = this.buildFooterText((DataType)comp);
        String type = "";
        if (comp instanceof Union) {
            type = "union ";
        } else if (comp instanceof Structure) {
            type = "struct ";
        }
        this.displayName = new TextLine(type + comp.getDisplayName() + " ");
        this.alignmentValueText = this.buildAlignmentValueText(comp);
        this.originalHTMLData = CompositeDataTypeHTMLRepresentation.buildHTMLText(this.warningLines, this.headerContent, this.displayName, this.bodyContent, this.alignmentText, this.footerText, this.alignmentValueText);
    }

    protected List<String> buildWarnings(Composite comp) {
        if (!comp.isNotYetDefined()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add("WARNING! Empty " + (comp instanceof Structure ? "Structure" : "Union"));
        return list;
    }

    @Override
    protected TextLine buildFooterText(DataType dataType) {
        if (dataType.isNotYetDefined()) {
            return new TextLine("0");
        }
        return super.buildFooterText(dataType);
    }

    protected List<ValidatableLine> buildAlignmentText(Composite dataType) {
        ArrayList<ValidatableLine> list = new ArrayList<ValidatableLine>();
        if (!dataType.isInternallyAligned()) {
            list.add(new TextLine("unaligned"));
        } else if (dataType.isDefaultAligned()) {
            list.add(new TextLine("align()"));
        } else if (dataType.isMachineAligned()) {
            list.add(new TextLine("align(machine)"));
        } else {
            long alignment = dataType.getMinimumAlignment();
            list.add(new TextLine("align(" + alignment + ")"));
        }
        TextLine packingText = this.buildPackingText(dataType);
        if (packingText != null) {
            list.add(packingText);
        }
        return list;
    }

    protected TextLine buildPackingText(Composite dataType) {
        if (!dataType.isInternallyAligned()) {
            return null;
        }
        long packingValue = dataType.getPackingValue();
        if (packingValue == 0L) {
            return null;
        }
        return new TextLine(" pack(" + packingValue + ")");
    }

    protected TextLine buildAlignmentValueText(Composite composite) {
        return new TextLine("" + composite.getAlignment());
    }

    private List<ValidatableLine> buildContent(Composite comp) {
        DataTypeComponent[] components;
        ArrayList<ValidatableLine> list = new ArrayList<ValidatableLine>();
        if (comp.isNotYetDefined()) {
            return list;
        }
        int count = 0;
        for (DataTypeComponent dataTypeComponent : components = comp.getComponents()) {
            String fieldName = dataTypeComponent.getFieldName();
            String comment = dataTypeComponent.getComment();
            DataType dataType = dataTypeComponent.getDataType();
            String type = "<unknown type>";
            DataType locatableType = null;
            if (dataType != null) {
                type = dataType.getDisplayName();
                locatableType = CompositeDataTypeHTMLRepresentation.getLocatableDataType(dataType);
            }
            list.add(new DataTypeLine(fieldName, type, comment, locatableType, false));
            if (count++ < 100) continue;
            list.add(new DataTypeLine("Warning: Too many components to display...", "", "", null, false));
            break;
        }
        if (comp instanceof Structure) {
            Structure struct = (Structure)comp;
            DataTypeComponent flexibleArrayComponent = struct.getFlexibleArrayComponent();
            if (count < 100 && flexibleArrayComponent != null) {
                String fieldName = flexibleArrayComponent.getFieldName();
                String comment = flexibleArrayComponent.getComment();
                DataType dataType = flexibleArrayComponent.getDataType();
                String type = dataType.getDisplayName();
                DataType locatableType = CompositeDataTypeHTMLRepresentation.getLocatableDataType(dataType);
                list.add(new DataTypeLine(fieldName, type, comment, locatableType, true));
            }
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private static String buildHTMLText(List<String> warningLines, List<ValidatableLine> headerLines, TextLine displayName, List<ValidatableLine> bodyLines, List<ValidatableLine> alignmentLines, TextLine footerLine, TextLine alignmentValueLine) {
        StringBuffer buffy = new StringBuffer();
        for (String warning : warningLines) {
            String string = CompositeDataTypeHTMLRepresentation.wrapStringInColor(warning, Color.RED);
            buffy.append(string).append("<BR>");
        }
        for (TextLine textLine : headerLines) {
            String headerLine = CompositeDataTypeHTMLRepresentation.wrapStringInColor(textLine.getText(), textLine.getTextColor());
            buffy.append(headerLine);
        }
        String string2 = HTMLUtilities.friendlyEncodeHTML((String)displayName.getText());
        string2 = CompositeDataTypeHTMLRepresentation.wrapStringInColor(string2, displayName.getTextColor());
        buffy.append("<TT>").append(string2).append("</TT>").append("&nbsp;").append("{").append("&nbsp;");
        buffy.append("<TABLE BORDER=0 CELLSPACING=5 CELLPADDING=0>");
        Iterator<ValidatableLine> iterator = bodyLines.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            void var13_19;
            DataTypeLine line = (DataTypeLine)iterator.next();
            String string3 = CompositeDataTypeHTMLRepresentation.generateTypeName(line);
            if (line.isFlexibleArray()) {
                String string4 = string3 + "[0]";
            }
            String fieldName = HTMLUtilities.friendlyEncodeHTML((String)line.getName());
            fieldName = CompositeDataTypeHTMLRepresentation.wrapStringInColor(fieldName, line.getNameColor());
            int commentLength = 80;
            String typeComment = CompositeDataTypeHTMLRepresentation.truncateAsNecessary(line.getComment(), commentLength);
            typeComment = HTMLUtilities.friendlyEncodeHTML((String)typeComment);
            typeComment = CompositeDataTypeHTMLRepresentation.wrapStringInColor(typeComment, line.getCommentColor());
            buffy.append("<TR>");
            buffy.append("<TD ALIGN=LEFT VALIGN=TOP>").append("<TT>").append(TAB).append((String)var13_19).append("</TT>").append("</TD>");
            buffy.append("<TD ALIGN=LEFT VALIGN=TOP>").append("&nbsp;").append(fieldName).append("</TD>");
            buffy.append("<TD ALIGN=LEFT VALIGN=TOP>").append("&nbsp;").append(typeComment).append("&nbsp;").append("</TD>");
            buffy.append("</TR>");
            if (i > 50) {
                buffy.append(TAB).append("...").append("<BR>");
                break;
            }
            ++i;
        }
        Object alignmentLine = "";
        for (TextLine textLine : alignmentLines) {
            alignmentLine = (String)alignmentLine + "&nbsp;" + CompositeDataTypeHTMLRepresentation.wrapStringInColor(textLine.getText(), textLine.getTextColor());
        }
        buffy.append("</TABLE>").append("}").append("<TT>").append((String)alignmentLine).append("</TT>").append("<BR>");
        CompositeDataTypeHTMLRepresentation.addAlignmentValue(alignmentValueLine.getText(), buffy);
        CompositeDataTypeHTMLRepresentation.addDataTypeLength(footerLine.getText(), buffy);
        buffy.append("<BR>");
        return buffy.toString();
    }

    private static String generateTypeName(DataTypeLine line) {
        String type = CompositeDataTypeHTMLRepresentation.truncateAsNecessary(line.getType());
        type = HTMLUtilities.friendlyEncodeHTML((String)type);
        type = CompositeDataTypeHTMLRepresentation.wrapStringInColor(type, line.getTypeColor());
        if (!line.hasUniversalId()) {
            return type;
        }
        DataType dt = line.getDataType();
        DataTypeIdUrl url = new DataTypeIdUrl(dt);
        String wrapped = HTMLUtilities.wrapWithLinkPlaceholder((String)type, (String)url.toString());
        return wrapped;
    }

    protected static StringBuffer addAlignmentValue(String alignmentValueString, StringBuffer buffer) {
        buffer.append("<BR>");
        buffer.append(ALIGNMENT_VALUE_PREFIX + alignmentValueString);
        return buffer;
    }

    @Override
    protected PlaceHolderLine createPlaceHolderLine(ValidatableLine oppositeLine) {
        return new EmptyDataTypeLine();
    }

    @Override
    public HTMLDataTypeRepresentation[] diff(HTMLDataTypeRepresentation otherRepresentation) {
        if (this == otherRepresentation) {
            return new HTMLDataTypeRepresentation[]{this, this};
        }
        if (!(otherRepresentation instanceof CompositeDataTypeHTMLRepresentation)) {
            return this.completelyDifferentDiff(otherRepresentation);
        }
        CompositeDataTypeHTMLRepresentation compositeRepresentation = (CompositeDataTypeHTMLRepresentation)otherRepresentation;
        List<ValidatableLine> header = this.copyLines(this.headerContent);
        List<ValidatableLine> body = this.copyLines(this.bodyContent);
        TextLine name = new TextLine(this.displayName.getText());
        List<ValidatableLine> alignment = this.copyLines(this.alignmentText);
        List<ValidatableLine> otherHeader = this.copyLines(compositeRepresentation.headerContent);
        List<ValidatableLine> otherBody = this.copyLines(compositeRepresentation.bodyContent);
        TextLine otherName = new TextLine(compositeRepresentation.displayName.getText());
        List<ValidatableLine> otherAlignment = this.copyLines(compositeRepresentation.alignmentText);
        DataTypeDiff headerDiff = DataTypeDiffBuilder.diffHeader(this.getDiffInput(header), this.getDiffInput(otherHeader));
        DataTypeDiff bodyDiff = DataTypeDiffBuilder.diffBody(this.getDiffInput(body), this.getDiffInput(otherBody));
        this.diffTextLine(name, otherName);
        this.diffAlignment(alignment, otherAlignment);
        List<String> noWarnings = Collections.emptyList();
        return new HTMLDataTypeRepresentation[]{new CompositeDataTypeHTMLRepresentation(noWarnings, headerDiff.getLeftLines(), bodyDiff.getLeftLines(), alignment, this.footerText, name, this.alignmentValueText), new CompositeDataTypeHTMLRepresentation(noWarnings, headerDiff.getRightLines(), bodyDiff.getRightLines(), otherAlignment, compositeRepresentation.footerText, otherName, compositeRepresentation.alignmentValueText)};
    }

    protected void diffAlignment(List<ValidatableLine> myLines, List<ValidatableLine> otherLines) {
        HTMLDataTypeRepresentationDiffInput myInput = this.getDiffInput(myLines);
        HTMLDataTypeRepresentationDiffInput otherInput = this.getDiffInput(otherLines);
        DiffLines mine = new DiffLines(myInput);
        DiffLines other = new DiffLines(otherInput);
        DataTypeDiffBuilder.padLines(mine, other);
        DataTypeDiffBuilder.highlightDifferences(mine, other);
    }
}

