/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.query;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DiscoverableTableUtils;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.field.AddressTableColumn;
import ghidra.util.table.field.LabelTableColumn;
import ghidra.util.table.field.NamespaceTableColumn;
import ghidra.util.table.field.PreviewTableColumn;
import ghidra.util.task.TaskMonitor;

public abstract class ProgramLocationPreviewTableModel
extends AddressBasedTableModel<ProgramLocation> {
    protected ProgramLocationPreviewTableModel(String modelName, ServiceProvider sp, Program prog, TaskMonitor monitor) {
        this(modelName, sp, prog, monitor, false);
    }

    protected ProgramLocationPreviewTableModel(String modelName, ServiceProvider sp, Program prog, TaskMonitor monitor, boolean loadIncrementally) {
        super(modelName, sp, prog, monitor, loadIncrementally);
    }

    @Override
    protected TableColumnDescriptor<ProgramLocation> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new AddressTableColumn()), 1, true);
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new LabelTableColumn()));
        descriptor.addVisibleColumn((DynamicTableColumn)new NamespaceTableColumn());
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new PreviewTableColumn()));
        return descriptor;
    }

    @Override
    public Address getAddress(int row) {
        ProgramLocation loc = (ProgramLocation)this.getRowObject(row);
        return loc.getAddress();
    }
}

