/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util.string;

import ghidra.program.model.data.AbstractStringDataType;
import ghidra.program.model.data.PascalString255DataType;
import ghidra.program.model.data.PascalStringDataType;
import ghidra.program.model.data.PascalUnicodeDataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.UnicodeDataType;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.ascii.Sequence;

public class PascalUtil {
    private static final int ONE_BYTE_OFFSET = -1;
    private static final int TWO_BYTE_OFFSET = -2;
    private static final int NO_OFFSET = 0;
    private static final int ASCII_CHAR_WIDTH = 1;
    private static final int UNICODE16_CHAR_WIDTH = 2;
    private static final int PASCAL_LENGTH_SIZE = 2;
    private static final int PASCAL255_LENGTH_SIZE = 1;

    public static Sequence findPascalSequence(MemBuffer buf, Sequence sequence, int alignment) {
        AbstractStringDataType stringDataType = sequence.getStringDataType();
        if (stringDataType instanceof PascalUnicodeDataType || stringDataType instanceof UnicodeDataType) {
            return PascalUtil.findUnicodePascal(buf, sequence);
        }
        if (stringDataType instanceof PascalStringDataType || stringDataType instanceof PascalString255DataType || stringDataType instanceof StringDataType) {
            return PascalUtil.findAsciiPascal(buf, sequence, alignment);
        }
        return null;
    }

    private static Sequence findUnicodePascal(MemBuffer buf, Sequence sequence) {
        Sequence pascalSequence = PascalUtil.checkForPascalUnicodeSequence(buf, sequence, -2);
        if (pascalSequence != null) {
            return pascalSequence;
        }
        pascalSequence = PascalUtil.checkForPascalUnicodeSequence(buf, sequence, 0);
        return pascalSequence;
    }

    private static Sequence findAsciiPascal(MemBuffer buf, Sequence sequence, int alignment) {
        Sequence pascalSequence = PascalUtil.checkForPascalAsciiSequence(buf, sequence, -2);
        if (pascalSequence != null) {
            return pascalSequence;
        }
        if (alignment == 1) {
            pascalSequence = PascalUtil.checkForPascal255AsciiSequence(buf, sequence, -1);
            if (pascalSequence != null) {
                return pascalSequence;
            }
            pascalSequence = PascalUtil.checkForPascalAsciiSequence(buf, sequence, -1);
            if (pascalSequence != null) {
                return pascalSequence;
            }
        }
        if ((pascalSequence = PascalUtil.checkForPascal255AsciiSequence(buf, sequence, 0)) != null) {
            return pascalSequence;
        }
        pascalSequence = PascalUtil.checkForPascalAsciiSequence(buf, sequence, 0);
        return pascalSequence;
    }

    private static Sequence checkForPascalUnicodeSequence(MemBuffer buf, Sequence sequence, int offset) {
        int pascalLengthOffset = (int)sequence.getStart() + offset;
        if (pascalLengthOffset < 0) {
            return null;
        }
        int length = PascalUtil.getShort(buf, pascalLengthOffset);
        int sequenceLength = (sequence.getLength() - offset - 2) / 2;
        if (sequence.isNullTerminated()) {
            if (length == --sequenceLength) {
                return new Sequence(pascalLengthOffset, sequence.getEnd() - 2L, (AbstractStringDataType)PascalUnicodeDataType.dataType, false);
            }
        } else if (length == sequenceLength) {
            return new Sequence(pascalLengthOffset, sequence.getEnd(), (AbstractStringDataType)PascalUnicodeDataType.dataType, false);
        }
        return null;
    }

    private static Sequence checkForPascalAsciiSequence(MemBuffer buf, Sequence sequence, int offset) {
        int pascalLengthOffset = (int)sequence.getStart() + offset;
        if (pascalLengthOffset < 0) {
            return null;
        }
        int length = PascalUtil.getShort(buf, pascalLengthOffset);
        int sequenceLength = sequence.getLength() - offset - 2;
        if (sequence.isNullTerminated()) {
            if (length == --sequenceLength) {
                return new Sequence(pascalLengthOffset, sequence.getEnd() - 1L, (AbstractStringDataType)PascalStringDataType.dataType, false);
            }
        } else if (length == sequenceLength) {
            return new Sequence(pascalLengthOffset, sequence.getEnd(), (AbstractStringDataType)PascalStringDataType.dataType, false);
        }
        return null;
    }

    private static Sequence checkForPascal255AsciiSequence(MemBuffer buf, Sequence sequence, int offset) {
        int pascalLengthOffset = (int)sequence.getStart() + offset;
        if (pascalLengthOffset < 0) {
            return null;
        }
        int length = PascalUtil.getByte(buf, pascalLengthOffset);
        int sequenceLength = sequence.getLength() - offset - 1;
        if (sequence.isNullTerminated()) {
            if (length == --sequenceLength) {
                return new Sequence(pascalLengthOffset, sequence.getEnd() - 1L, (AbstractStringDataType)PascalString255DataType.dataType, false);
            }
        } else if (length == sequenceLength) {
            return new Sequence(pascalLengthOffset, sequence.getEnd(), (AbstractStringDataType)PascalString255DataType.dataType, false);
        }
        return null;
    }

    private static int getShort(MemBuffer buf, int offset) {
        try {
            return buf.getShort(offset);
        }
        catch (MemoryAccessException e) {
            return -1;
        }
    }

    private static int getByte(MemBuffer buf, int offset) {
        try {
            return buf.getByte(offset) & 0xFF;
        }
        catch (MemoryAccessException e) {
            return -1;
        }
    }
}

