/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.state;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.SequenceNumber;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.state.ResultsState;
import ghidra.util.state.SequenceRange;
import ghidra.util.state.VarnodeOperation;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ContextState {
    private static boolean DEBUG = false;
    private static final long[] VALUE_MASK = new long[]{0L, 255L, 65535L, 0xFFFFFFL, 0xFFFFFFFFL, 0xFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, -1L};
    private static final long[] SIGN_BIT = new long[]{0L, 128L, 32768L, 0x800000L, 0x80000000L, 0x8000000000L, 0x800000000000L, 0x80000000000000L};
    private final Program program;
    private final Language language;
    private final AddressFactory addrFactory;
    private final SequenceNumber pcodeEntry;
    private SequenceRange sequenceRange;
    private final HashSet<SequenceNumber> flowFrom = new HashSet();
    private final ContextState previousState;
    private final Memory memory;
    private HashMap<Address, Varnode> memoryMap = new HashMap();
    private HashMap<String, HashMap<Long, Varnode>> frameMaps;
    private HashMap<Long, Varnode> uniqueMap;
    private int cachedSpaceId;
    private Varnode cachedLocation;
    private Varnode cachedValue;
    private boolean locked = false;
    private Varnode debugVarnode;

    public ContextState(Address entryPt, Program program) {
        this(entryPt, program.getProgramContext(), program);
    }

    public ContextState(Address entryPt, ProgramContext programCtx, Program program) {
        this.program = program;
        this.previousState = null;
        this.memory = program.getMemory();
        this.pcodeEntry = new SequenceNumber(entryPt, 0);
        this.language = program.getLanguage();
        this.addrFactory = program.getAddressFactory();
        if (programCtx != null) {
            this.copyEntryContext(this.pcodeEntry.getTarget(), programCtx);
        }
    }

    public ContextState(SequenceNumber pcodeEntry, ContextState previousState) {
        this.pcodeEntry = pcodeEntry;
        this.previousState = previousState;
        this.program = previousState.program;
        this.memory = previousState.memory;
        this.language = previousState.language;
        this.addrFactory = this.program.getAddressFactory();
        this.debugVarnode = previousState.debugVarnode;
    }

    public Program getProgram() {
        return this.program;
    }

    public ContextState getPreviousContextState() {
        return this.previousState;
    }

    public boolean isFlowFrom(SequenceNumber seq) {
        return this.flowFrom.contains(seq);
    }

    void addFlowFrom(SequenceNumber seq) {
        if (seq != null) {
            this.flowFrom.add(seq);
        }
    }

    public Set<SequenceNumber> getFlowFroms() {
        return this.flowFrom;
    }

    void setExitPoint(SequenceNumber end) {
        this.sequenceRange = new SequenceRange(this.pcodeEntry, end);
    }

    public SequenceNumber getExitPoint() {
        if (this.sequenceRange != null) {
            return this.sequenceRange.getEnd();
        }
        return null;
    }

    public SequenceRange getSequenceRange() {
        return this.sequenceRange;
    }

    public void setDebugVarnod(Varnode varnode) {
        this.debugVarnode = varnode;
    }

    public ContextState branchState(SequenceNumber pcodeEntry) {
        ContextState newState = new ContextState(pcodeEntry, this);
        newState.uniqueMap = this.uniqueMap;
        if (this.uniqueMap != null) {
            this.uniqueMap.clear();
        }
        return newState;
    }

    private void copyEntryContext(Address entryAddr, ProgramContext entryContext) {
        for (Register reg : entryContext.getRegistersWithValues()) {
            RegisterValue regValue = entryContext.getRegisterValue(reg, entryAddr);
            if (regValue == null) continue;
            if (reg.isProcessorContext()) {
                this.storeRegisterValue(reg, regValue.getUnsignedValueIgnoreMask());
                continue;
            }
            if (!regValue.hasValue()) continue;
            this.storeRegisterValue(reg, regValue.getUnsignedValue());
        }
    }

    private void storeRegisterValue(Register reg, BigInteger unsignedValue) {
        byte[] bytes = unsignedValue.toByteArray();
        int bytesIndex = 0;
        if (bytes[0] == 0) {
            bytesIndex = 1;
        }
        Address baseAddr = reg.getAddress();
        int size = reg.getMinimumByteSize();
        byte signextend = (byte)(unsignedValue.signum() < 0 ? -1 : 0);
        int lengthDiff = size - bytes.length + bytesIndex;
        for (int i = 0; i < size; ++i) {
            byte val;
            if (lengthDiff > 0) {
                val = signextend;
                --lengthDiff;
            } else {
                val = bytes[bytesIndex++];
            }
            Varnode byteValue = new Varnode(this.addrFactory.getConstantAddress((long)val), 1);
            byteValue.trim();
            long byteOffset = this.language.isBigEndian() ? (long)i : (long)(size - i - 1);
            this.memoryMap.put(baseAddr.addWrap(byteOffset), byteValue);
        }
    }

    public SequenceNumber getEntryPoint() {
        return this.pcodeEntry;
    }

    public HashMap<Long, Varnode> clearUniqueState() {
        HashMap<Long, Varnode> oldMap = this.uniqueMap;
        if (this.uniqueMap != null) {
            this.uniqueMap = new HashMap();
        }
        return oldMap;
    }

    public void lock() {
        this.uniqueMap = null;
        this.locked = true;
    }

    private String getFrameMapName(String spaceName, Varnode framePointer) {
        if (framePointer.isUnique() || framePointer.isConstant()) {
            throw new IllegalArgumentException("Invalid frame pointer");
        }
        return spaceName + "/" + framePointer.getAddress().toString(true);
    }

    private HashMap<Long, Varnode> getFrameMap(String frameMapName, boolean forUpdate) {
        HashMap<Long, Object> map = null;
        if (this.frameMaps == null) {
            if (!forUpdate) {
                return null;
            }
            this.frameMaps = new HashMap();
        } else {
            map = this.frameMaps.get(frameMapName);
        }
        if (map == null && forUpdate) {
            map = new HashMap();
            this.frameMaps.put(frameMapName, map);
        }
        return map;
    }

    private VarnodeOperation getOperation(Address addr, int opcode, Varnode[] inputs, Varnode output) {
        if (addr == null) {
            addr = Address.NO_ADDRESS;
        }
        return new VarnodeOperation(new PcodeOp(addr, -1, opcode, inputs, output), inputs);
    }

    private Varnode getVarnodeByte(Varnode varnode, int bytePos) {
        if (varnode instanceof VarnodeOperation) {
            return new MaskedVarnodeOperation((VarnodeOperation)varnode, bytePos, 1);
        }
        if (varnode.isConstant()) {
            long val = varnode.getOffset() >>> 8 * bytePos & 0xFFL;
            return new Varnode(this.addrFactory.getConstantAddress(val), 1);
        }
        long offset = this.language.isBigEndian() ? (long)(varnode.getSize() - bytePos - 1) : (long)bytePos;
        Address addr = varnode.getAddress().addWrap(offset);
        return new Varnode(addr, 1);
    }

    static FrameNode getFrameNode(Varnode offsetValue, Language language) {
        Varnode framePointer;
        long frameOffset = 0L;
        if (offsetValue instanceof VarnodeOperation) {
            VarnodeOperation op = (VarnodeOperation)offsetValue;
            int opCode = op.getPCodeOp().getOpcode();
            if (opCode != 19 && opCode != 20) {
                return null;
            }
            Varnode[] inputValues = op.getInputValues();
            if (inputValues[0].isConstant()) {
                frameOffset = ResultsState.getSignedOffset(inputValues[0]);
                framePointer = inputValues[1];
            } else if (inputValues[1].isConstant()) {
                frameOffset = ResultsState.getSignedOffset(inputValues[1]);
                framePointer = inputValues[0];
            } else {
                return null;
            }
            if (opCode == 20) {
                frameOffset = -frameOffset;
            }
        } else {
            framePointer = offsetValue;
        }
        return new FrameNode(framePointer, frameOffset, language);
    }

    public boolean store(int spaceID, Varnode offsetValue, Varnode storedValue, int size) {
        if (this.locked) {
            throw new IllegalStateException("State is locked");
        }
        AddressSpace addressSpace = this.addrFactory.getAddressSpace(spaceID);
        if (addressSpace == null) {
            throw new IllegalArgumentException("Unknown spaceID");
        }
        if (storedValue.isConstant() && storedValue.getSize() == 0) {
            storedValue = new Varnode(this.addrFactory.getConstantAddress(storedValue.getOffset()), size);
        } else if (size != storedValue.getSize()) {
            throw new IllegalArgumentException("storeValue size mismatch");
        }
        this.cachedLocation = null;
        this.cachedValue = null;
        if (offsetValue.isConstant()) {
            try {
                Address addr = addressSpace.getAddress(offsetValue.getOffset(), true);
                this.store(new Varnode(addr, size), storedValue);
                return true;
            }
            catch (AddressOutOfBoundsException addr) {
                if (DEBUG) {
                    Msg.debug((Object)this, (Object)(" Store failed: spaceID=" + spaceID + ", offsetValue: " + offsetValue.getOffset()));
                }
                return false;
            }
        }
        FrameNode frameNode = ContextState.getFrameNode(offsetValue, this.language);
        if (frameNode == null) {
            if (DEBUG) {
                Msg.debug((Object)this, (Object)(" Store failed: spaceID=" + spaceID + ", offsetValue: " + offsetValue.toString(this.language)));
            }
            return false;
        }
        if ((this.debugVarnode == null || frameNode.framePointer.equals((Object)this.debugVarnode)) && DEBUG) {
            Msg.debug((Object)this, (Object)(" Store: " + frameNode + " <- " + storedValue.toString(this.language)));
        }
        String frameMapName = this.getFrameMapName(addressSpace.getName(), frameNode.framePointer);
        HashMap<Long, Varnode> frameMap = this.getFrameMap(frameMapName, true);
        if (size == 1) {
            frameMap.put(frameNode.frameOffset, storedValue);
        } else {
            long baseOffset = frameNode.frameOffset;
            for (int i = 0; i < size; ++i) {
                Varnode byteValue = this.getVarnodeByte(storedValue, i);
                long byteOffset = this.language.isBigEndian() ? (long)(size - i - 1) : (long)i;
                frameMap.put(baseOffset + byteOffset, byteValue);
            }
        }
        return true;
    }

    public void store(Varnode addressVarnode, Varnode storedValue) {
        if (addressVarnode instanceof VarnodeOperation || addressVarnode.isConstant()) {
            throw new IllegalArgumentException("May not store value to constant varnode");
        }
        if (this.locked) {
            throw new IllegalStateException("State is locked");
        }
        int size = addressVarnode.getSize();
        if (storedValue.getSize() != size) {
            throw new IllegalArgumentException("Argument size mismatch");
        }
        this.cachedLocation = null;
        this.cachedValue = null;
        if ((this.debugVarnode == null || addressVarnode.equals((Object)this.debugVarnode)) && DEBUG) {
            Msg.debug((Object)this, (Object)(" Store: " + addressVarnode.toString(this.language) + " <- " + storedValue.toString(this.language)));
        }
        if (addressVarnode.isUnique()) {
            if (this.uniqueMap == null) {
                this.uniqueMap = new HashMap();
            }
            this.uniqueMap.put(addressVarnode.getOffset(), storedValue);
            return;
        }
        if (addressVarnode.equals((Object)storedValue) && DEBUG) {
            Msg.debug((Object)this, (Object)("Location value restored: " + addressVarnode.toString(this.language)));
        }
        if (size == 1) {
            this.memoryMap.put(addressVarnode.getAddress(), storedValue);
        } else {
            Address baseAddr = addressVarnode.getAddress();
            for (int i = 0; i < size; ++i) {
                Varnode byteValue = this.getVarnodeByte(storedValue, i);
                long byteOffset = this.language.isBigEndian() ? (long)(size - i - 1) : (long)i;
                this.memoryMap.put(baseAddr.addWrap(byteOffset), byteValue);
            }
        }
    }

    public Varnode get(int spaceID, Varnode offsetValue, int size) {
        try {
            return this.get(spaceID, offsetValue, size, TaskMonitorAdapter.DUMMY_MONITOR);
        }
        catch (CancelledException e) {
            throw new AssertException((Throwable)e);
        }
    }

    public Varnode get(int spaceID, Varnode offsetValue, int size, TaskMonitor monitor) throws CancelledException {
        AddressSpace addressSpace = this.addrFactory.getAddressSpace(spaceID);
        if (addressSpace == null) {
            throw new IllegalArgumentException("Unknown spaceID: " + spaceID);
        }
        if (spaceID == this.cachedSpaceId && offsetValue.equals((Object)this.cachedLocation) && (this.cachedValue == null || this.cachedValue.getSize() == size)) {
            return this.cachedValue;
        }
        this.cachedSpaceId = spaceID;
        this.cachedLocation = offsetValue;
        if (offsetValue.isConstant()) {
            try {
                Varnode value;
                Address addr = addressSpace.getAddress(offsetValue.getOffset());
                this.cachedValue = value = this.get(new Varnode(addr, size), monitor);
                return value;
            }
            catch (AddressOutOfBoundsException addr) {
                if (DEBUG) {
                    Msg.debug((Object)this, (Object)(" Get failed: spaceID=" + spaceID + ", offsetValue: " + offsetValue.getOffset()));
                }
                this.cachedValue = null;
                return null;
            }
        }
        FrameNode frameNode = ContextState.getFrameNode(offsetValue, this.language);
        if (frameNode == null) {
            if (DEBUG) {
                Msg.debug((Object)this, (Object)(" Get failed: spaceID=" + spaceID + ", offsetValue: " + offsetValue.toString(this.language)));
            }
            this.cachedValue = null;
            return null;
        }
        String frameMapName = this.getFrameMapName(addressSpace.getName(), frameNode.framePointer);
        Varnode[] bytes = new Varnode[size];
        long baseOffset = frameNode.frameOffset;
        for (int i = 0; i < size; ++i) {
            int bytePos = this.language.isBigEndian() ? size - i - 1 : i;
            bytes[bytePos] = this.getByte(frameMapName, baseOffset + (long)i);
            if (bytes[bytePos] != null) continue;
            if ((this.debugVarnode == null || frameNode.framePointer.equals((Object)this.debugVarnode)) && DEBUG) {
                Msg.debug((Object)this, (Object)(" Get failed: " + frameNode + " has unknown bytes"));
            }
            this.cachedValue = null;
            return null;
        }
        Varnode returnVal = this.combineByteValues(bytes, monitor);
        if ((this.debugVarnode == null || frameNode.framePointer.equals((Object)this.debugVarnode)) && DEBUG) {
            Msg.debug((Object)this, (Object)(" Get: " + frameNode + " [" + size + "] is " + returnVal.toString(this.language)));
        }
        this.cachedValue = returnVal;
        return returnVal;
    }

    public Varnode get(Varnode varnode) {
        try {
            return this.get(varnode, TaskMonitorAdapter.DUMMY_MONITOR);
        }
        catch (CancelledException e) {
            throw new AssertException((Throwable)e);
        }
    }

    public Varnode get(Varnode varnode, TaskMonitor monitor) throws CancelledException {
        if (varnode instanceof VarnodeOperation) {
            return null;
        }
        if (varnode.isConstant()) {
            return varnode;
        }
        if (varnode.isUnique()) {
            if (this.uniqueMap == null) {
                return null;
            }
            return this.uniqueMap.get(varnode.getOffset());
        }
        if (this.cachedSpaceId == -1 && varnode.equals((Object)this.cachedLocation)) {
            return this.cachedValue;
        }
        this.cachedSpaceId = -1;
        this.cachedLocation = varnode;
        Address baseAddr = varnode.getAddress();
        int size = varnode.getSize();
        int zeroMemoryByteCnt = 0;
        Varnode[] bytes = new Varnode[size];
        try {
            for (int i = 0; i < size; ++i) {
                int bytePos = this.language.isBigEndian() ? size - i - 1 : i;
                bytes[bytePos] = this.getByte(baseAddr.add((long)i));
                if (bytes[bytePos] == null) {
                    bytes = null;
                    break;
                }
                if (!(bytes[bytePos] instanceof MemoryByteVarnode) || bytes[bytePos].getOffset() != 0L) continue;
                ++zeroMemoryByteCnt;
            }
        }
        catch (MemoryAccessException e) {
            bytes = null;
        }
        catch (AddressOutOfBoundsException e) {
            bytes = null;
        }
        if (bytes == null || zeroMemoryByteCnt == bytes.length) {
            if (varnode.isAddress()) {
                this.cachedValue = varnode;
                return varnode;
            }
            this.cachedValue = null;
            return null;
        }
        Varnode returnVal = this.combineByteValues(bytes, monitor);
        if (this.debugVarnode == null || varnode.equals((Object)this.debugVarnode)) {
            Object str = varnode.toString(this.language);
            if (((String)str).indexOf(58) < 0) {
                str = (String)str + ":" + varnode.getSize();
            }
            if (DEBUG) {
                Msg.debug((Object)this, (Object)(" Get: " + (String)str + " is " + returnVal.toString(this.language)));
            }
        }
        this.cachedValue = returnVal;
        return returnVal;
    }

    private Varnode combineByteValues(Varnode[] byteValues, TaskMonitor monitor) throws CancelledException {
        Varnode result;
        ArrayList<Varnode> resultList = new ArrayList<Varnode>();
        Varnode v = byteValues[0];
        int nextIndex = 1;
        int size = 1;
        while (nextIndex < byteValues.length) {
            result = this.combineValues(byteValues[nextIndex], v);
            if (result == null) {
                resultList.add(v);
                v = byteValues[nextIndex++];
                size = 1;
                continue;
            }
            v = result;
            ++nextIndex;
            ++size;
        }
        resultList.add(v);
        result = (Varnode)resultList.get(0);
        int cnt = resultList.size();
        if (cnt == 1 || result == null) {
            return this.normalizeExpression(result, byteValues.length);
        }
        result = this.leftShiftExpression(result, 0, result.getSize(), monitor);
        for (int i = 1; i < cnt; ++i) {
            Varnode next = (Varnode)resultList.get(i);
            if (next == null) {
                return null;
            }
            size = result.getSize() + next.getSize();
            next = this.leftShiftExpression(next, result.getSize(), size, monitor);
            Varnode[] inputs = new Varnode[]{this.zeroExtendExpression(result, size), next};
            PcodeOp op = new PcodeOp(Address.NO_ADDRESS, -1, 19, inputs, new Varnode(Address.NO_ADDRESS, size));
            if ((result = ResultsState.simplify(op, inputs, this.addrFactory, monitor)) != null) continue;
            result = new VarnodeOperation(op, inputs);
        }
        return result;
    }

    private Varnode zeroExtendExpression(Varnode v, int size) {
        if (v.isConstant()) {
            return new Varnode(this.addrFactory.getConstantAddress(v.getOffset()), size);
        }
        if (v instanceof MaskedVarnodeOperation) {
            MaskedVarnodeOperation mvOp = (MaskedVarnodeOperation)v;
            return new MaskedVarnodeOperation(mvOp.op, mvOp.byteShift, size);
        }
        Varnode[] inputs = new Varnode[]{v};
        return this.getOperation(Address.NO_ADDRESS, 17, inputs, new Varnode(Address.NO_ADDRESS, size));
    }

    private Varnode leftShiftExpression(Varnode v, int byteShift, int size, TaskMonitor monitor) throws CancelledException {
        if (size <= byteShift) {
            return new Varnode(this.addrFactory.getConstantAddress(0L), size);
        }
        if (v instanceof MaskedVarnodeOperation) {
            MaskedVarnodeOperation mvOp = (MaskedVarnodeOperation)v;
            if (byteShift == mvOp.byteShift && mvOp.op.getSize() <= 8) {
                long mask = VALUE_MASK[mvOp.op.getSize()] & (VALUE_MASK[byteShift] ^ 0xFFFFFFFFFFFFFFFFL);
                Varnode[] inputs = new Varnode[]{mvOp.op, new Varnode(this.addrFactory.getConstantAddress(mask), mvOp.op.getSize())};
                PcodeOp op = new PcodeOp(Address.NO_ADDRESS, -1, 27, inputs, new Varnode(Address.NO_ADDRESS, size));
                v = ResultsState.simplify(op, inputs, this.addrFactory, monitor);
                if (v == null) {
                    v = new VarnodeOperation(op, inputs);
                }
                if (v.getSize() != size) {
                    v = this.zeroExtendExpression(v, size);
                }
                return v;
            }
            v = this.normalizeExpression(v, size);
        }
        if (v.isConstant()) {
            return new Varnode(this.addrFactory.getConstantAddress(v.getOffset() << byteShift * 8), size);
        }
        if (v.getSize() != size) {
            v = this.zeroExtendExpression(v, size);
        }
        if (byteShift == 0) {
            return v;
        }
        Varnode[] inputs = new Varnode[]{v, new Varnode(this.addrFactory.getConstantAddress((long)(byteShift * 8)), 1)};
        return this.getOperation(Address.NO_ADDRESS, 29, inputs, new Varnode(Address.NO_ADDRESS, size));
    }

    private Varnode combineValues(Varnode leftValue, Varnode rightValue) {
        Address addr;
        if (leftValue == null || rightValue == null) {
            return null;
        }
        if (leftValue instanceof MaskedVarnodeOperation) {
            if (rightValue instanceof MaskedVarnodeOperation) {
                MaskedVarnodeOperation leftOp = (MaskedVarnodeOperation)leftValue;
                MaskedVarnodeOperation rightOp = (MaskedVarnodeOperation)rightValue;
                if (leftOp.op == rightOp.op && leftOp.byteShift == rightOp.getSize() + rightOp.byteShift) {
                    int size = leftOp.getSize() + rightOp.getSize();
                    if (rightOp.byteShift == 0 && size == rightOp.op.getSize()) {
                        return rightOp.op;
                    }
                    return new MaskedVarnodeOperation(rightOp.op, rightOp.byteShift, size);
                }
            }
            return null;
        }
        if (leftValue.isConstant()) {
            if (rightValue.isConstant()) {
                int leftShift = rightValue.getSize() * 8;
                long rightMask = (1L << leftShift) - 1L;
                long val = (rightValue.getOffset() & rightMask) + (leftValue.getOffset() << leftShift);
                return new Varnode(this.addrFactory.getConstantAddress(val), leftValue.getSize() + rightValue.getSize());
            }
            return null;
        }
        if (leftValue.getSpace() != rightValue.getSpace()) {
            return null;
        }
        if (this.language.isBigEndian()) {
            if (rightValue.getOffset() != leftValue.getOffset() + (long)leftValue.getSize()) {
                return null;
            }
            addr = leftValue.getAddress();
        } else {
            if (leftValue.getOffset() != rightValue.getOffset() + (long)rightValue.getSize()) {
                return null;
            }
            addr = rightValue.getAddress();
        }
        return new Varnode(addr, leftValue.getSize() + rightValue.getSize());
    }

    private Varnode normalizeExpression(Varnode v, int targetSize) {
        Varnode result = v;
        if (v instanceof MaskedVarnodeOperation) {
            MaskedVarnodeOperation maskedOp = (MaskedVarnodeOperation)v;
            result = maskedOp.op;
            int opcode = maskedOp.op.getPCodeOp().getOpcode();
            Varnode[] opInputs = maskedOp.op.getInputValues();
            if (maskedOp.byteShift == 0) {
                if ((opcode == 17 || opcode == 18) && opInputs[0].getSize() >= targetSize) {
                    result = opInputs[0];
                }
            } else {
                if (opcode == 17 && opInputs[0].getSize() <= maskedOp.byteShift) {
                    return new Varnode(this.addrFactory.getConstantAddress(0L), targetSize);
                }
                Varnode mask = new Varnode(this.addrFactory.getConstantAddress(-(1L << 8 * maskedOp.byteShift)), result.getSize());
                mask.trim();
                Varnode[] inputs = new Varnode[]{result, mask};
                result = this.getOperation(result.getAddress(), 27, inputs, new Varnode(Address.NO_ADDRESS, result.getSize()));
            }
        }
        if (result != null) {
            Varnode[] inputs;
            if (result.isConstant()) {
                if (result.getSize() != targetSize) {
                    long val = result.getOffset();
                    result = new Varnode(this.addrFactory.getConstantAddress(val), targetSize);
                }
            } else if (result.getSize() < targetSize) {
                inputs = new Varnode[]{result};
                result = this.getOperation(Address.NO_ADDRESS, 17, inputs, new Varnode(Address.NO_ADDRESS, targetSize));
            } else if (result.getSize() > targetSize) {
                inputs = new Varnode[]{result, new Varnode(this.addrFactory.getConstantAddress((long)targetSize), 1)};
                result = this.getOperation(Address.NO_ADDRESS, 63, inputs, new Varnode(Address.NO_ADDRESS, targetSize));
            }
        }
        return result;
    }

    private Varnode getByte(String frameMapName, long offset) {
        Varnode v;
        HashMap<Long, Varnode> frameMap = this.getFrameMap(frameMapName, false);
        if (frameMap != null && (v = frameMap.get(offset)) != null) {
            return v;
        }
        if (this.previousState != null) {
            return this.previousState.getByte(frameMapName, offset);
        }
        return null;
    }

    private Varnode getByte(Address address) throws MemoryAccessException {
        Varnode value = this.memoryMap.get(address);
        if (value != null) {
            return value;
        }
        if (this.previousState != null) {
            return this.previousState.getByte(address);
        }
        if (address.isMemoryAddress()) {
            if (this.memory == null) {
                throw new MemoryAccessException("No memory found for " + address);
            }
            MemoryBlock block = this.memory.getBlock(address);
            if (block != null && block.isInitialized() && !block.isVolatile()) {
                byte val = block.getByte(address);
                return new MemoryByteVarnode(val);
            }
        }
        return null;
    }

    public List<Register> getDifferingRegisters(ContextState other) {
        ArrayList<Register> regList = null;
        for (Register reg : this.language.getRegisters()) {
            if (reg.isProcessorContext() || reg.isProgramCounter()) continue;
            Varnode v = new Varnode(reg.getAddress(), reg.getMinimumByteSize());
            Varnode val1 = this.get(v);
            Varnode val2 = other.get(v);
            if (val1 == null || val2 == null || val1.equals((Object)val2)) continue;
            if (regList == null) {
                regList = new ArrayList<Register>();
            }
            regList.add(reg);
        }
        return regList;
    }

    public boolean hasDifferingRegisters(ContextState other) {
        for (Register reg : this.language.getRegisters()) {
            if (reg.isProcessorContext() || reg.isProgramCounter()) continue;
            Varnode v = new Varnode(reg.getAddress(), reg.getMinimumByteSize());
            Varnode val1 = this.get(v);
            Varnode val2 = other.get(v);
            if (val1 == null || val2 == null || val1.equals((Object)val2)) continue;
            return true;
        }
        return false;
    }

    private class MemoryByteVarnode
    extends Varnode {
        public MemoryByteVarnode(byte val) {
            super(ContextState.this.addrFactory.getConstantAddress((long)val), 1);
        }
    }

    private static class MaskedVarnodeOperation
    extends Varnode {
        private final VarnodeOperation op;
        private final int byteShift;

        MaskedVarnodeOperation(VarnodeOperation op, int byteShift, int size) {
            super(op.getAddress(), size);
            this.op = op;
            this.byteShift = byteShift;
        }

        public String toString() {
            return "MaskedVarnodeOperation(" + this.byteShift + ", " + this.getSize() + "):" + this.op.toString();
        }
    }

    static class FrameNode {
        private long frameOffset;
        private Varnode framePointer;
        private Language language;

        FrameNode(Varnode framePointer, long frameOffset, Language language) {
            this.framePointer = framePointer;
            this.frameOffset = frameOffset;
            this.language = language;
        }

        public String toString() {
            return this.framePointer.toString(this.language) + "[" + NumericUtilities.toSignedHexString((long)this.frameOffset) + "]";
        }

        Varnode getFramePointer() {
            return this.framePointer;
        }

        long getFrameOffset() {
            return this.frameOffset;
        }
    }
}

