/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.projectdata.column;

import ghidra.docking.settings.Settings;
import ghidra.framework.main.datatable.DomainFileInfo;
import ghidra.framework.main.datatable.ProjectDataColumn;
import ghidra.framework.model.ProjectData;
import ghidra.framework.plugintool.ServiceProvider;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CreationDateProjectDataColumn
extends ProjectDataColumn<Date> {
    private static final DateFormat format = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy");

    public String getColumnName() {
        return "Created";
    }

    public Date getValue(DomainFileInfo info, Settings settings, ProjectData data, ServiceProvider services) throws IllegalArgumentException {
        String dateString = info.getMetaDataValue("Date Created");
        if (dateString != null) {
            return this.getDate(dateString);
        }
        return null;
    }

    private Date getDate(String dateString) {
        if (dateString != null) {
            try {
                return format.parse(dateString);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return new Date(0L);
    }

    public int getColumnPreferredWidth() {
        return 200;
    }

    public boolean isDefaultColumn() {
        return false;
    }

    public int getPriority() {
        return 7;
    }
}

