/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.event.mouse;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.picking.PickedState;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualGraphViewUpdater;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.event.mouse.VisualGraphAbstractGraphMousePlugin;
import ghidra.graph.viewer.event.picking.GPickedState;
import java.awt.Cursor;
import java.awt.event.MouseEvent;

public class VisualGraphEdgeSelectionGraphMousePlugin<V extends VisualVertex, E extends VisualEdge<V>>
extends VisualGraphAbstractGraphMousePlugin<V, E> {
    public VisualGraphEdgeSelectionGraphMousePlugin() {
        this.cursor = Cursor.getPredefinedCursor(12);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.checkModifiers(e)) {
            return;
        }
        if (e.getClickCount() != 2) {
            return;
        }
        this.checkForEdge(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.isHandlingMouseEvents) {
            return;
        }
        VisualEdge edgeReference = this.selectedEdge;
        e.consume();
        this.resetState();
        GraphViewer viewer = this.getGraphViewer(e);
        PickedState pickedVertexState = viewer.getPickedVertexState();
        Layout layout = viewer.getGraphLayout();
        Graph graph = layout.getGraph();
        VisualVertex destination = (VisualVertex)graph.getDest((Object)edgeReference);
        if (!pickedVertexState.isPicked((Object)destination)) {
            this.pickAndShowVertex(destination, pickedVertexState, viewer);
            return;
        }
        VisualVertex source = (VisualVertex)graph.getSource((Object)edgeReference);
        this.pickAndShowVertex(source, pickedVertexState, viewer);
    }

    private void pickAndShowVertex(V vertex, PickedState<V> pickedVertexState, GraphViewer<V, E> viewer) {
        GPickedState pickedStateWrapper = (GPickedState)pickedVertexState;
        pickedStateWrapper.pickToActivate(vertex);
        VisualGraphViewUpdater<V, E> updater = viewer.getViewUpdater();
        updater.moveVertexToCenterWithAnimation(vertex);
    }

    @Override
    protected boolean shouldShowCursor(MouseEvent e) {
        return this.isOverEdge(e);
    }
}

