/* ###
 * IP: GHIDRA
 * REVIEWED: YES
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ghidra.app.util;

public class GenericHelpTopics {
    /**
     * Help Topic for "About."
     */
    public final static String ABOUT = "About";

    /**
     * Name of options for the help topic for the front end
     * (Project Window).
     */
    public final static String FRONT_END = "FrontEndPlugin";

    /**
     * Help Topic for the glossary.
     */
    public final static String GLOSSARY = "Glossary";

    /**
     * Help for Intro topics.
     */
    public final static String INTRO = "Intro";
    
    /**
     * Help Topic for the project repository.
     */
    public final static String REPOSITORY = "Repository";

    /**
     * Help Topic for tools.
     */
    public final static String TOOL = "Tool";
}
