/*
 * Decompiled with CFR 0.152.
 */
import java.net.InetAddress;
import java.util.Vector;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.winsecurity.Credentials;
import oracle.cluster.winsecurity.PermissionType;
import oracle.cluster.winsecurity.User;
import oracle.cluster.winsecurity.UserPrivilege;
import oracle.cluster.winsecurity.WinSecurityFactory;
import oracle.cluster.winsecurity.WindowsSecurityException;
import oracle.cluster.winsecurity.WindowsStorageType;
import oracle.ops.mgmt.cluster.Version;
import oracle.sysman.oii.oiil.OiilAction;
import oracle.sysman.oii.oiil.OiilActionCloneCapable;
import oracle.sysman.oii.oiil.OiilActionClusterOps;
import oracle.sysman.oii.oiil.OiilActionException;
import oracle.sysman.oii.oiil.OiilActionInputElement;
import oracle.sysman.oii.oiil.OiilCommitException;
import oracle.sysman.oii.oiil.OiilDeinstallException;
import oracle.sysman.oii.oiil.OiilUndoException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class SetACLForUser
implements OiilAction,
OiilActionCloneCapable,
OiilActionClusterOps {
    private Object retItem(Vector inputs, String param) {
        int pos = OiixVectorOps.vectIndexOf((Vector)inputs, (Object)param);
        if (pos == -1) {
            return null;
        }
        OiilActionInputElement aie = (OiilActionInputElement)inputs.elementAt(pos);
        return aie.getObject();
    }

    public void installAction(Vector inputs, Vector outLogObjects) throws OiilActionException {
        String machineName;
        block18: {
            machineName = new String();
            try {
                machineName = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                if (OiiolTextLogger.getLogLevel() < OiiolTextLogger.LOG_DETAILED) break block18;
                OiiolTextLogger.appendText((String)"Exception has occurred");
                OiiolTextLogger.appendException((Throwable)e);
            }
        }
        if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
            OiiolTextLogger.appendText((String)("Setting ACL on Node : " + machineName));
        }
        String userOrGroupName = (String)this.retItem(inputs, "userName");
        String windowsObjectType = (String)this.retItem(inputs, "windowsObjectType");
        String path = (String)this.retItem(inputs, "path");
        String permissionType = (String)this.retItem(inputs, "permissionType");
        String OracleHomeBin = (String)this.retItem(inputs, "OracleHomeBin");
        boolean isInheritable = (Boolean)this.retItem(inputs, "inheritable");
        boolean isBuildInAccount = (Boolean)this.retItem(inputs, "isBuildInAccount");
        boolean isSharedPath = (Boolean)this.retItem(inputs, "isSharedPath");
        String[] nodes = (String[])this.retItem(inputs, "nodeList");
        String[] skipFolders = (String[])this.retItem(inputs, "skipFolders");
        if (skipFolders != null && skipFolders.length == 0) {
            skipFolders = null;
        }
        UserPrivilege m_userPriv = null;
        try {
            Credentials m_cred;
            Version m_version = new Version();
            if (!isBuildInAccount) {
                m_cred = new Credentials(userOrGroupName);
            } else {
                m_cred = new Credentials(Credentials.BuiltinUser.LOCALSYSTEM);
                if (userOrGroupName.equals(Credentials.BuiltinUser.LOCALSYSTEM.toString())) {
                    m_cred = new Credentials(Credentials.BuiltinUser.LOCALSYSTEM);
                }
                if (userOrGroupName.equals(Credentials.BuiltinUser.LOCALSERVICE.toString())) {
                    m_cred = new Credentials(Credentials.BuiltinUser.LOCALSERVICE);
                }
                if (userOrGroupName.equals(Credentials.BuiltinUser.NETWORKSERVICE.toString())) {
                    m_cred = new Credentials(Credentials.BuiltinUser.NETWORKSERVICE);
                }
            }
            WinSecurityFactory m_winSecFactory = WinSecurityFactory.getInstance((String)OracleHomeBin, null);
            m_userPriv = m_winSecFactory.getUserPrivilege(m_cred, m_version);
            User m_user = m_winSecFactory.getUser(m_cred, m_version);
            WindowsStorageType m_storeType = WindowsStorageType.valueOf((String)windowsObjectType);
            if (permissionType != null && permissionType.length() > 0) {
                PermissionType m_permType = PermissionType.valueOf((String)permissionType);
                if (skipFolders != null) {
                    m_userPriv.setAclsForUser(m_storeType, path, m_permType, isInheritable, skipFolders);
                } else {
                    m_userPriv.setAclsForUser(m_storeType, path, m_permType, isInheritable);
                }
            } else if (skipFolders != null) {
                m_userPriv.setAclsForUser(m_storeType, path, null, isInheritable, skipFolders);
            } else {
                m_userPriv.setAclsForUser(m_storeType, path, null, isInheritable);
            }
        }
        catch (WindowsSecurityException we) {
            String excepStr = OiActionIniRes.getString("SetACLForUserException_desc");
            String excep = new String("WindowsSecurityException has occurred");
            OiiolTextLogger.appendText((String)excep);
            OiiolTextLogger.appendException((Throwable)we);
            throw new OiilActionException(excep, excepStr);
        }
        catch (Exception e) {
            String excepStr = OiActionIniRes.getString("Exception_desc");
            OiiolTextLogger.appendText((String)excepStr);
            OiiolTextLogger.appendException((Throwable)e);
            throw new OiilActionException(excepStr, e.getMessage());
        }
    }

    public void clusterInstallAction(Vector inputs, Vector inLogObjects) throws OiilActionException {
        String excep;
        String excepStr;
        PermissionType m_permType;
        WindowsStorageType m_storeType;
        String machineName;
        block26: {
            machineName = new String();
            try {
                machineName = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                if (OiiolTextLogger.getLogLevel() < OiiolTextLogger.LOG_DETAILED) break block26;
                OiiolTextLogger.appendText((String)"Exception Occurred");
                OiiolTextLogger.appendException((Throwable)e);
            }
        }
        String userOrGroupName = (String)this.retItem(inputs, "userName");
        String windowsObjectType = (String)this.retItem(inputs, "windowsObjectType");
        String path = (String)this.retItem(inputs, "path");
        String permissionType = (String)this.retItem(inputs, "permissionType");
        String OracleHomeBin = (String)this.retItem(inputs, "OracleHomeBin");
        boolean isInheritable = (Boolean)this.retItem(inputs, "inheritable");
        boolean isBuildInAccount = (Boolean)this.retItem(inputs, "isBuildInAccount");
        boolean isSharedPath = (Boolean)this.retItem(inputs, "isSharedPath");
        String[] remoteNodes = (String[])this.retItem(inputs, "remoteNodes");
        String[] skipFolders = (String[])this.retItem(inputs, "skipFolders");
        if (skipFolders != null && skipFolders.length == 0) {
            skipFolders = null;
        }
        UserPrivilege m_userPriv = null;
        try {
            Credentials m_cred;
            Version m_version = new Version();
            if (!isBuildInAccount) {
                m_cred = new Credentials(userOrGroupName);
            } else {
                m_cred = new Credentials(Credentials.BuiltinUser.LOCALSYSTEM);
                if (userOrGroupName.equals(Credentials.BuiltinUser.LOCALSYSTEM.toString())) {
                    m_cred = new Credentials(Credentials.BuiltinUser.LOCALSYSTEM);
                }
                if (userOrGroupName.equals(Credentials.BuiltinUser.LOCALSERVICE.toString())) {
                    m_cred = new Credentials(Credentials.BuiltinUser.LOCALSERVICE);
                }
                if (userOrGroupName.equals(Credentials.BuiltinUser.NETWORKSERVICE.toString())) {
                    m_cred = new Credentials(Credentials.BuiltinUser.NETWORKSERVICE);
                }
            }
            WinSecurityFactory m_winSecFactory = WinSecurityFactory.getInstance((String)OracleHomeBin, null);
            m_userPriv = m_winSecFactory.getUserPrivilege(m_cred, m_version);
            User user = m_winSecFactory.getUser(m_cred, m_version);
        }
        catch (WindowsSecurityException we) {
            String excepStr2 = OiActionIniRes.getString("SetACLForUserException_desc");
            String excep2 = new String("WindowsSecurityException has occurred");
            OiiolTextLogger.appendText((String)excep2);
            OiiolTextLogger.appendException((Throwable)we);
            throw new OiilActionException(excep2, excepStr2);
        }
        catch (Exception e) {
            String excepStr3 = OiActionIniRes.getString("Exception_desc");
            OiiolTextLogger.appendText((String)excepStr3);
            OiiolTextLogger.appendException((Throwable)e);
            throw new OiilActionException(excepStr3, e.getMessage());
        }
        if (!isSharedPath) {
            if (remoteNodes != null && remoteNodes.length > 0) {
                if (OiiolTextLogger.getLogLevel() >= OiiolTextLogger.LOG_DETAILED) {
                    OiiolTextLogger.appendText((String)("***Setting ACL on Node : " + OiixFunctionOps.implodeList((String[])remoteNodes, (String)",")));
                }
                try {
                    m_storeType = WindowsStorageType.valueOf((String)windowsObjectType);
                    if (permissionType != null && permissionType.length() > 0) {
                        m_permType = PermissionType.valueOf((String)permissionType);
                        if (skipFolders != null) {
                            m_userPriv.setAclsForUser(m_storeType, path, m_permType, isInheritable, machineName, remoteNodes, skipFolders);
                        }
                        m_userPriv.setAclsForUser(m_storeType, path, m_permType, isInheritable, machineName, remoteNodes);
                    }
                    if (skipFolders != null) {
                        m_userPriv.setAclsForUser(m_storeType, path, null, isInheritable, machineName, remoteNodes, skipFolders);
                    }
                    m_userPriv.setAclsForUser(m_storeType, path, null, isInheritable, machineName, remoteNodes);
                }
                catch (WindowsSecurityException e) {
                    excepStr = OiActionIniRes.getString("SetACLForUserException_desc");
                    excep = new String("WindowsSecurityException has occurred");
                    OiiolTextLogger.appendText((String)excep);
                    OiiolTextLogger.appendException((Throwable)e);
                    throw new OiilActionException(excep, excepStr);
                }
                catch (CompositeOperationException e) {
                    excepStr = OiActionIniRes.getString("SetACLForUserException_desc");
                    excep = new String("CompositeOperationException has occurred");
                    OiiolTextLogger.appendText((String)excep);
                    OiiolTextLogger.appendException((Throwable)e);
                    throw new OiilActionException(excep, excepStr);
                }
            }
        } else {
            try {
                m_storeType = WindowsStorageType.valueOf((String)windowsObjectType);
                m_permType = PermissionType.valueOf((String)permissionType);
                if (skipFolders != null) {
                    m_userPriv.setAclsForUser(m_storeType, path, m_permType, false, machineName, remoteNodes, skipFolders);
                } else {
                    m_userPriv.setAclsForUser(m_storeType, path, m_permType, false, machineName, remoteNodes);
                }
            }
            catch (WindowsSecurityException we) {
                excepStr = OiActionIniRes.getString("SetACLForUserException_desc");
                excep = new String("WindowsSecurityException has occurred");
                OiiolTextLogger.appendText((String)excep);
                OiiolTextLogger.appendException((Throwable)we);
                throw new OiilActionException(excep, excepStr);
            }
            catch (Exception e) {
                excepStr = OiActionIniRes.getString("Exception_desc");
                OiiolTextLogger.appendText((String)excepStr);
                OiiolTextLogger.appendException((Throwable)e);
                throw new OiilActionException(excepStr, e.getMessage());
            }
        }
    }

    public void cloneAction(Vector inputs, Vector outLogObjects) throws OiilActionException {
        this.installAction(inputs, outLogObjects);
    }

    public String getDescription(Vector inputs) {
        return null;
    }

    public void saveAndInstallAction(Vector vector, Vector vector1, Vector vector2) throws OiilActionException {
    }

    public void deinstallAction(Vector vector, Vector vector1) throws OiilDeinstallException {
    }

    public void clusterDeinstallAction(Vector vector, Vector vector1) throws OiilDeinstallException {
    }

    public void saveAndDeinstallAction(Vector vector, Vector vector1, Vector vector2, Vector vector3) throws OiilDeinstallException {
    }

    public void undoInstallAction(Vector vector, Vector vector1, Vector vector2) throws OiilUndoException {
    }

    public void undoDeinstallAction(Vector vector, Vector vector1, Vector vector2, Vector vector3) throws OiilUndoException {
    }

    public void commitInstallAction(Vector vector, Vector vector1, Vector vector2, Vector vector3) throws OiilCommitException {
    }

    public void commitDeinstallAction(Vector vector, Vector vector1, Vector vector2) throws OiilCommitException {
    }

    public static void main(String[] args) {
        SetACLForUser atodg = new SetACLForUser();
        Vector<OiilActionInputElement> i = new Vector<OiilActionInputElement>();
        Vector olo = new Vector();
        i.addElement(new OiilActionInputElement("userName", (Object)"ORA_OraClient12g_home2_SVCSIDS"));
        i.addElement(new OiilActionInputElement("OracleHomeBin", (Object)"c:\\sujatha\\clientlocal\\product\\12.1.0\\client_1\\bin"));
        i.addElement(new OiilActionInputElement("windowsObjectType", (Object)"Directory"));
        i.addElement(new OiilActionInputElement("path", (Object)"c:\\sujatha\\clientlocal"));
        i.addElement(new OiilActionInputElement("permissionType", (Object)"ClientBase"));
        i.addElement(new OiilActionInputElement("inheritable", (Object)true));
        i.addElement(new OiilActionInputElement("isBuildInAccount", (Object)false));
        try {
            atodg.installAction(i, olo);
        }
        catch (OiilActionException ne) {
            System.out.println(ne.getExceptionName());
        }
    }
}

