/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;

public class OipchAIXPackageReader {
    private OipchAIXPackageReader() {
    }

    static Collection readPackageDetails(String sFile) throws IOException {
        String currentLine;
        BufferedReader reader = new BufferedReader(new FileReader(sFile));
        ArrayList<String> oElements = new ArrayList<String>();
        Object oElement = null;
        while ((currentLine = reader.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(currentLine);
            if (st.countTokens() < 4) continue;
            String name = st.nextToken();
            String version = st.nextToken();
            if (!OipchAIXPackageReader.isVersionOK(version)) continue;
            oElements.add(name + ":" + version);
        }
        reader.close();
        return oElements;
    }

    static boolean isVersionOK(String vers) {
        boolean rv = true;
        StringTokenizer st = new StringTokenizer(vers, ".");
        if (st.countTokens() < 1) {
            rv = false;
        }
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            try {
                int n = Integer.parseInt(token);
            }
            catch (NumberFormatException e) {
                rv = false;
            }
        }
        return rv;
    }
}

