/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.prereqs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipch.OipchGenericRefHost;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipck.OipckNoReferenceSpecifiedException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownBuilderException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipcr.OipcrExecuteRuleException;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrResult;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class UserInputChecks {
    public static final String S_ORATAB_DELIMINATOR = ":";
    public static final String S_ORATAB_NO_DB = "*";
    public static final String S_ORATAB_COMMENT = "#";
    public static final int S_ORATAB_COLS = 3;

    private UserInputChecks() {
    }

    public static OipcrIResult checkClustername(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        if (oRulesEngine != null) {
            try {
                String sValue = UserInputChecks.getRefInfo(oRulesEngine, sRefFile, "CLUSTERNAME");
                OipcrIResult oRes = null;
                ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
                oRes = UserInputChecks.validateClustername(sValue) ? OipcrResult.PASSED_RESULT : OipcrResult.FAILED_RESULT;
                oResDetails.add(new OipcrResultDetails(null, (Object)sValue, oRes));
                oResult = new OipcrResult(oResDetails);
            }
            catch (OipcrExecuteRuleException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckUnknownKnowledgeSourceException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckKnowledgeSourceException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckNoReferenceSpecifiedException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckUnknownBuilderException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    public static OipcrIResult checkSID(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        if (oRulesEngine != null) {
            try {
                String sValue = UserInputChecks.getRefInfo(oRulesEngine, sRefFile, "SID");
                OipcrIResult oRes = null;
                ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
                oRes = UserInputChecks.validateSID(sValue) ? OipcrResult.PASSED_RESULT : OipcrResult.FAILED_RESULT;
                oResDetails.add(new OipcrResultDetails(null, (Object)sValue, oRes));
                oResult = new OipcrResult(oResDetails);
            }
            catch (OipcrExecuteRuleException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckUnknownKnowledgeSourceException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckKnowledgeSourceException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckNoReferenceSpecifiedException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckUnknownBuilderException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    private static boolean validateSID(String sName) {
        boolean bValid = true;
        if (sName != null) {
            int SIDlength = sName.length();
            int maxLen = 8;
            String badChars = "!@%^&*()-+=\\|`~[{]};:'\",<>/?.#_$ ";
            for (int i = 0; i < SIDlength; ++i) {
                char ch = sName.charAt(i);
                if (badChars.indexOf(ch) == -1) continue;
                return false;
            }
            switch (OiixPlatform.getCurrentPlatform()) {
                case 2: 
                case 46: 
                case 87: 
                case 110: 
                case 197: 
                case 211: 
                case 453: 
                case 610: {
                    maxLen = 8;
                    break;
                }
                case 208: 
                case 233: 
                case 912: {
                    maxLen = 64;
                }
            }
            if (SIDlength <= 0 || SIDlength > maxLen) {
                return false;
            }
            bValid = UserInputChecks.validateSIDUniqueness(sName);
        }
        return bValid;
    }

    private static boolean validateSIDUniqueness(String sName) {
        boolean bValid = true;
        switch (OiixPlatform.getCurrentPlatform()) {
            case 2: 
            case 46: 
            case 87: 
            case 110: 
            case 197: 
            case 211: 
            case 453: 
            case 610: {
                bValid = UserInputChecks.validateSIDUniquenessOnUnix(sName);
                break;
            }
        }
        return bValid;
    }

    private static boolean validateSIDUniquenessOnUnix(String sName) {
        File oratab;
        boolean bValid = true;
        OiixPlatform oiiPl = new OiixPlatform();
        int platID = oiiPl.getCurrentPlatform();
        String orafileLoc = "/etc/oratab";
        if (platID == 453) {
            orafileLoc = "/var/opt/oracle/oratab";
        }
        if (!(oratab = new File(orafileLoc)).exists()) {
            bValid = true;
        } else {
            StringTokenizer toker = null;
            String input = "";
            try {
                FileInputStream fis = new FileInputStream(oratab);
                InputStreamReader is = new InputStreamReader(fis);
                BufferedReader bf = new BufferedReader(is);
                while ((input = bf.readLine()) != null) {
                    if (input.startsWith(S_ORATAB_COMMENT) || input.startsWith(S_ORATAB_NO_DB) || input.trim().compareTo("") == 0) continue;
                    toker = null;
                    toker = new StringTokenizer(input, S_ORATAB_DELIMINATOR);
                    if (toker.countTokens() < 3) {
                        bValid = true;
                        continue;
                    }
                    String sCurSID = toker.nextToken();
                    if (!sCurSID.equalsIgnoreCase(sName)) continue;
                    bValid = false;
                    return bValid;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bValid;
    }

    private static boolean validateClustername(String sName) {
        boolean bValid = true;
        if (sName != null) {
            String badChars = "!@%^&*()+=\\|`~[{]};'\",:<>/?#$";
            int iSize = sName.length();
            for (int j = 0; j < iSize; ++j) {
                char ch = sName.charAt(j);
                if (badChars.indexOf(ch) == -1) continue;
                bValid = false;
                return bValid;
            }
            bValid = iSize > 0 && iSize <= 15;
        }
        return bValid;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getRefInfo(OipcrIRulesEngine oRulesEngine, String sRefFile, String sTag) throws OipcrExecuteRuleException, OipckUnknownKnowledgeSourceException, OipckNoReferenceSpecifiedException, OipckUnknownBuilderException, OipckKnowledgeSourceException {
        String sValue = null;
        OipchGenericRefHost oGenRefHost = (OipchGenericRefHost)oRulesEngine.getRefKnowledgeSource("genrefhost", sRefFile);
        OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
        Node oNode = oGenRefHost.getNode("USER_INPUTS/" + sTag);
        if (oNode != null) {
            Object oHomeNode = null;
            NamedNodeMap oNodeAttribs = null;
            Node oAttrib = null;
            oNodeAttribs = oNode.getAttributes();
            if (oNodeAttribs != null) {
                oAttrib = oNodeAttribs.getNamedItem("VAR");
                String sVar = null;
                if (oAttrib == null) {
                    Object[] args = new String[]{sRefFile};
                    throw new OipcrExecuteRuleException("S_NO_VAR_FOR_TAG", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_VAR_FOR_TAG", (Object[])args));
                }
                sVar = oAttrib.getNodeValue();
                OiisVariable oVar = oContext.getVariable(sVar);
                if (oVar == null) return sValue;
                return (String)oVar.getValue();
            }
            Object[] args = new String[]{sRefFile, sTag};
            throw new OipcrExecuteRuleException("S_NO_ATTS_FOR_TAG", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_ATTS_FOR_TAG", (Object[])args));
        }
        Object[] args = new String[]{sRefFile, sTag};
        throw new OipcrExecuteRuleException("S_NO_TAG_INFO", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_TAG_INFO", (Object[])args));
    }
}

