/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdk;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import model.common.AbstractBaseTarget;
import model.fafmw.BI;
import oracle.opatch.FMWClientFactory;
import oracle.opatch.fmwclient.FMWClient;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchsdk.OPatchDeployAction;
import oracle.opatch.opatchsdk.OPatchDeployException;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchFAAutomationAction;
import oracle.opatch.opatchsdk.OPatchFAClonedConfigInstance;
import oracle.opatch.opatchsdk.OPatchFAOperation;
import oracle.opatch.opatchsdk.OPatchFAStep;
import oracle.opatch.opatchsdk.OPatchInterviewAction;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchsdk.OPatchStepOperation;
import oracle.opatch.opatchsdk.OPatchUtils;
import oracle.opatch.patchverbs.AutomationElement;

public class OPatchBIPDeployAction
extends OPatchDeployAction
implements Cloneable {
    private BI biObject = null;
    private String originalPatchLocation = "";
    private static int count = 0;
    private Properties dynamicProp = new Properties();
    private String biHome = "";

    private OPatchBIPDeployAction() {
    }

    protected OPatchBIPDeployAction(AutomationElement auto_el) {
        super(auto_el);
    }

    public String toString() {
        return super.toString();
    }

    public void setDynamicProperties(Properties dynamicProp) {
        this.dynamicProp = dynamicProp;
    }

    public Properties getDynamicProperties() {
        return this.dynamicProp;
    }

    public void setBIHome(String biHome) {
        this.biHome = biHome;
    }

    public String getBIHome() {
        return this.biHome;
    }

    public void setOriginalPatchLocation(String originalPatchLocation) {
        this.originalPatchLocation = originalPatchLocation;
    }

    public String getOriginalPatchLocation() {
        return this.originalPatchLocation;
    }

    protected Map constructMap() {
        HashMap<String, String> env = new HashMap<String, String>();
        Map superEnv = super.constructMap();
        env.put("OPatch.COMMON_COMPONENTS_HOME", this.getCommonComponentsHome());
        env.put("OPATCH.PATCH_ARCHIVE_ROOT", this.originalPatchLocation);
        env.putAll(superEnv);
        return env;
    }

    public void deploy(String patchLocation) throws OPatchDeployException {
        try {
            this.inputPatchLoc = patchLocation;
            this.deploy();
            Object var4_2 = null;
            this.inputPatchLoc = "";
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.inputPatchLoc = "";
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void deploy() throws OPatchDeployException {
        block46: {
            String errorMsg;
            FMWClient client = null;
            OPatchStepOperation failedStep = null;
            this.setFailedPrereqStep(null);
            this.setFailedClosingStep(null);
            boolean updatePrereqFailure = false;
            String oracleHomePath = "";
            String logFile = "";
            OPatchDeployException de = null;
            oracleHomePath = this.getOracleHome();
            OPatchPatch patch = this.getWrapperPatch();
            try {
                if (patch == null) {
                    throw new OPatchDeployException("Log file cannot be created because OPatch does not know the source patch for this artifact.");
                }
                String fileName = OPatchUtils.norm(this.getDeployFileName());
                logFile = OPatchUtils.initLogFile(oracleHomePath, patch.getLogTimeStamp(), "Deploy_BIP_" + fileName, true);
                this.setLogFile(logFile);
            }
            catch (Throwable t) {
                String stepMsg = "Check if log file is created properly for the operation.";
                String errorMsg2 = t.getMessage();
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_INIT_LOG_FILE, stepMsg, errorMsg2, new RuntimeException(t));
                this.setFailedPrereqStep(failedStep);
                throw t;
            }
            if (!this.isArtifactBoundtoConfigInstance()) {
                errorMsg = "Please bind the FA config instance object to the artifact using bindToClone() API.";
                String stepMsg = "Check if artifact is bound to required end point instances from Cloned Configuration instance.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_FA_BIND_TO_CLONE_ARTIFACT, stepMsg, errorMsg, null);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw new OPatchDeployException(errorMsg);
            }
            super.doPrereq(OPatchFAOperation.PREREQ_DEPLOY);
            try {
                OPatchUtils.lockHome(oracleHomePath);
            }
            catch (Throwable t) {
                String errorMsg3 = "OPatch failed to lock the Oracle Home \"" + oracleHomePath + "\"";
                String stepMsg = "Check if OPatch can lock the Oracle Home \"" + oracleHomePath + "\"";
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_LOCK_HOME, stepMsg, errorMsg3, re);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw t;
            }
            if (this.originalPatchLocation == null || this.originalPatchLocation.equals("")) {
                errorMsg = "Please set the correct patch location for the BIP artifact using setOriginalPatchLocation() API.";
                String stepMsg = "Check if original patch location is set in the artifact.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_BIP_ORIGINAL_PATCH_LOCATION_SET, stepMsg, errorMsg, null);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw new OPatchDeployException(errorMsg);
            }
            File f = new File(this.originalPatchLocation);
            if (!f.exists() || !f.isDirectory()) {
                String errorMsg4 = "The original patch location set for BIP artifact does not exist (or) is not a directory. Please check the location \"" + this.originalPatchLocation + "\".";
                String stepMsg = "Check if original patch location is accessible.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_BIP_ORIGINAL_PATCH_LOCATION_VALIDITY, stepMsg, errorMsg4, null);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw new OPatchDeployException(errorMsg4);
            }
            if (this.biHome == null || this.biHome.equals("")) {
                String errorMsg5 = "Please set the correct BI home for the BIP artifact using setBIHome() API.";
                String stepMsg = "Check if BI Oracle Home is set.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_BI_HOME, stepMsg, errorMsg5, null);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw new OPatchDeployException(errorMsg5);
            }
            f = new File(this.biHome);
            if (!f.exists() || !f.isDirectory()) {
                String errorMsg6 = "The location set for BI home does not exist (or) is not a directory. Please check the location \"" + this.biHome + "\".";
                String stepMsg = "Check if BI location is valid.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_BI_HOME, stepMsg, errorMsg6, null);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw new OPatchDeployException(errorMsg6);
            }
            OPatchInterviewAction[] interAction = this.getInterviewElements();
            ArrayList<String> mandatoryKeysNotFilled = new ArrayList<String>();
            if (interAction != null) {
                for (int k = 0; k < interAction.length; ++k) {
                    if (interAction[k] == null || !interAction[k].isRequired()) continue;
                    String value = interAction[k].getDefaultValue();
                    if (!(value = OPatchUtils.norm(value)).equals("")) continue;
                    mandatoryKeysNotFilled.add(interAction[k].getKey());
                }
            }
            if (mandatoryKeysNotFilled.size() != 0) {
                String errorMsg7 = "The mandatory keys \"" + mandatoryKeysNotFilled.toString() + "\" in the interview are not filled for this artifact.";
                String stepMsg = "Check if mandatory keys are given for this artifact.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_MANDATORY_INTERVIEW_VALUES_GIVEN, stepMsg, errorMsg7, null);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw new OPatchDeployException(errorMsg7);
            }
            try {
                Properties p = new Properties();
                p.putAll((Map<?, ?>)this.getInterviewProperties());
                p.putAll((Map<?, ?>)this.getDynamicProperties());
                client = FMWClientFactory.getClient((OPatchFAAutomationAction)this, (Map)this.constructMap(), (Properties)p);
            }
            catch (Throwable t) {
                String errorMsg8 = "OPatch failed to get the FMW client for artifact execution (Internal OPatch issue)";
                String stepMsg = "Check if OPatch can get the client for artifact execution";
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_FA_CLIENT, stepMsg, errorMsg8, re);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw t;
            }
            client.deploy();
            OPatchUtils.updatePrereq(client, this);
            OPatchStepOperation prereqStep = this.getFailedPrereqStep();
            updatePrereqFailure = true;
            if (prereqStep != null) {
                throw new OPatchDeployException("OPatch failed in prerequisite checks prior to deploy.");
            }
            Object var16_36 = null;
            try {
                if (!oracleHomePath.equals("")) {
                    OPatchUtils.unlockHome(oracleHomePath);
                }
            }
            catch (Throwable t2) {
                String errorMsg9 = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
                String stepMsg = "Check if OPatch can unlock the Oracle Home.";
                RuntimeException re2 = new RuntimeException(t2.getMessage());
                re2.setStackTrace(t2.getStackTrace());
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg, errorMsg9, re2);
                this.setFailedClosingStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
            }
            OPatchUtils.closeLogFile();
            OPatchStepOperation prereqStep2 = this.getFailedPrereqStep();
            if (prereqStep2 != null) {
                if (client != null) {
                    client.close();
                }
                if (de != null) {
                    throw de;
                }
                return;
            }
            OPatchUtils.updateExecutionContext(client, this, OPatchFAOperation.DEPLOY);
            OPatchUtils.logExecutionContext(oracleHomePath, this.getOperatingFAContext(), "", this);
            if (client != null) {
                client.close();
            }
            if (de != null) {
                throw de;
            }
            break block46;
            {
                catch (Throwable t) {
                    if (!updatePrereqFailure) {
                        OPatchUtils.updatePrereq(client, this);
                        updatePrereqFailure = true;
                    }
                    while (t.getCause() != null) {
                        t = t.getCause();
                    }
                    OPatchDeployException re = new OPatchDeployException(t.getMessage());
                    re.setStackTrace(t.getStackTrace());
                    de = re;
                    Object var16_37 = null;
                    try {
                        if (!oracleHomePath.equals("")) {
                            OPatchUtils.unlockHome(oracleHomePath);
                        }
                    }
                    catch (Throwable t2) {
                        String errorMsg9 = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
                        String stepMsg = "Check if OPatch can unlock the Oracle Home.";
                        RuntimeException re2 = new RuntimeException(t2.getMessage());
                        re2.setStackTrace(t2.getStackTrace());
                        failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg, errorMsg9, re2);
                        this.setFailedClosingStep(failedStep);
                        OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                    }
                    OPatchUtils.closeLogFile();
                    prereqStep2 = this.getFailedPrereqStep();
                    if (prereqStep2 != null) {
                        if (client != null) {
                            client.close();
                        }
                        if (de != null) {
                            throw de;
                        }
                        return;
                    }
                    OPatchUtils.updateExecutionContext(client, this, OPatchFAOperation.DEPLOY);
                    OPatchUtils.logExecutionContext(oracleHomePath, this.getOperatingFAContext(), "", this);
                    if (client != null) {
                        client.close();
                    }
                    if (de != null) {
                        throw de;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var16_38 = null;
                try {
                    if (!oracleHomePath.equals("")) {
                        OPatchUtils.unlockHome(oracleHomePath);
                    }
                }
                catch (Throwable t2) {
                    String errorMsg9 = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
                    String stepMsg = "Check if OPatch can unlock the Oracle Home.";
                    RuntimeException re2 = new RuntimeException(t2.getMessage());
                    re2.setStackTrace(t2.getStackTrace());
                    failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg, errorMsg9, re2);
                    this.setFailedClosingStep(failedStep);
                    OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                }
                OPatchUtils.closeLogFile();
                prereqStep2 = this.getFailedPrereqStep();
                if (prereqStep2 != null) {
                    if (client != null) {
                        client.close();
                    }
                    if (de != null) {
                        throw de;
                    }
                    return;
                }
                OPatchUtils.updateExecutionContext(client, this, OPatchFAOperation.DEPLOY);
                OPatchUtils.logExecutionContext(oracleHomePath, this.getOperatingFAContext(), "", this);
                if (client != null) {
                    client.close();
                }
                if (de != null) {
                    throw de;
                }
                throw throwable;
            }
        }
    }

    protected void invokeSuperPrereq(OPatchFAOperation operation) throws OPatchException {
        super.doPrereq(operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void doPrereq(OPatchFAOperation operation) throws OPatchException {
        block37: {
            String stepMsg;
            String errorMsg;
            OPatchStepOperation failedStep = null;
            this.setFailedPrereqStep(null);
            FMWClient client = null;
            OPatchException oe = null;
            String oracleHomePath = this.getOracleHome();
            OPatchPatch patch = this.getWrapperPatch();
            String logFile = "";
            this.setLogFile("");
            try {
                if (patch == null) {
                    throw new OPatchDeployException("Log file cannot be created because OPatch does not know the source patch for this artifact.");
                }
                String fileName = OPatchUtils.norm(this.getDeployFileName());
                logFile = OPatchUtils.initLogFile(oracleHomePath, patch.getLogTimeStamp(), "Prereq_BIP_" + fileName, true);
                this.setLogFile(logFile);
            }
            catch (Throwable t) {
                String stepMsg2 = "Check if log file is created properly for the operation.";
                String errorMsg2 = t.getMessage();
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_INIT_LOG_FILE, stepMsg2, errorMsg2, new RuntimeException(t));
                this.setFailedPrereqStep(failedStep);
                throw t;
            }
            if (!this.isArtifactBoundtoConfigInstance()) {
                errorMsg = "Please bind the FA config instance object to the artifact using bindToClone() API.";
                String stepMsg3 = "Check if artifact is bound to required end point instances from Cloned Configuration instance.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_FA_BIND_TO_CLONE_ARTIFACT, stepMsg3, errorMsg, null);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw new OPatchException(errorMsg);
            }
            if (this.inputPatchLoc != null && !this.inputPatchLoc.equals("")) {
                this.doPrereqForPatchLoc(operation, this.inputPatchLoc);
            }
            super.doPrereq(operation);
            if (this.originalPatchLocation == null || this.originalPatchLocation.equals("")) {
                errorMsg = "Please set the correct patch location for the BIP artifact using setOriginalPatchLocation() API.";
                String stepMsg4 = "Check if original patch location is set in the artifact.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_BIP_ORIGINAL_PATCH_LOCATION_SET, stepMsg4, errorMsg, null);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw new OPatchException(errorMsg);
            }
            File f = new File(this.originalPatchLocation);
            if (!f.exists() || !f.isDirectory()) {
                String errorMsg3 = "The original patch location set for BIP artifact does not exist (or) is not a directory. Please check the location \"" + this.originalPatchLocation + "\".";
                String stepMsg5 = "Check if original patch location is accessible.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_BIP_ORIGINAL_PATCH_LOCATION_VALIDITY, stepMsg5, errorMsg3, null);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw new OPatchException(errorMsg3);
            }
            if (this.biHome == null || this.biHome.equals("")) {
                String errorMsg4 = "Please set the correct BI home for the BIP artifact using setBIHome() API.";
                String stepMsg6 = "Check if BI Oracle Home is set.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_BI_HOME, stepMsg6, errorMsg4, null);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw new OPatchException(errorMsg4);
            }
            f = new File(this.biHome);
            if (!f.exists() || !f.isDirectory()) {
                String errorMsg5 = "The location set for BI home does not exist (or) is not a directory. Please check the location \"" + this.biHome + "\".";
                String stepMsg7 = "Check if BI location is valid.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_BI_HOME, stepMsg7, errorMsg5, null);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw new OPatchException(errorMsg5);
            }
            OPatchInterviewAction[] interAction = this.getInterviewElements();
            ArrayList<String> mandatoryKeysNotFilled = new ArrayList<String>();
            if (interAction != null) {
                for (int k = 0; k < interAction.length; ++k) {
                    if (interAction[k] == null || !interAction[k].isRequired()) continue;
                    String value = interAction[k].getDefaultValue();
                    if (!(value = OPatchUtils.norm(value)).equals("")) continue;
                    mandatoryKeysNotFilled.add(interAction[k].getKey());
                }
            }
            if (mandatoryKeysNotFilled.size() != 0) {
                String errorMsg6 = "The mandatory keys \"" + mandatoryKeysNotFilled.toString() + "\" in the interview are not filled for this artifact.";
                stepMsg = "Check if mandatory keys are given for this artifact.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_MANDATORY_INTERVIEW_VALUES_GIVEN, stepMsg, errorMsg6, null);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw new OPatchException(errorMsg6);
            }
            try {
                Properties p = new Properties();
                p.putAll((Map<?, ?>)this.getInterviewProperties());
                p.putAll((Map<?, ?>)this.getDynamicProperties());
                client = FMWClientFactory.getClient((OPatchFAAutomationAction)this, (Map)this.constructMap(), (Properties)p);
            }
            catch (Throwable t) {
                String errorMsg7 = "OPatch failed to get the FMW client for artifact execution (Internal OPatch issue)";
                String stepMsg8 = "Check if OPatch can get the client for artifact execution";
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_FA_CLIENT, stepMsg8, errorMsg7, re);
                this.setFailedPrereqStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                throw t;
            }
            try {
                if (operation != OPatchFAOperation.PREREQ_DEPLOY) {
                    String errorMsg8 = "OPatch does not support the operation \"" + operation.toString() + "\" for this artifact.";
                    stepMsg = "Check if operation \"" + operation.toString() + "\" is supported.";
                    failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_OPERATION_SUPPORTED, stepMsg, errorMsg8, null);
                    this.setFailedPrereqStep(failedStep);
                    OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                    OPatchException re = new OPatchException(errorMsg8);
                    throw re;
                }
                client.prereq(true);
            }
            catch (Throwable t) {
                OPatchException re = new OPatchException("OPatch fails in prereq on the artifact. " + t.getMessage());
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
            Object var16_34 = null;
            OPatchUtils.updatePrereq(client, this);
            try {
                if (!oracleHomePath.equals("")) {
                    OPatchUtils.unlockHome(oracleHomePath);
                }
            }
            catch (Throwable t2) {
                String errorMsg9 = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
                String stepMsg9 = "Check if OPatch can unlock the Oracle Home.";
                RuntimeException re2 = new RuntimeException(t2.getMessage());
                re2.setStackTrace(t2.getStackTrace());
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg9, errorMsg9, re2);
                this.setFailedClosingStep(failedStep);
                OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
            }
            OPatchUtils.closeLogFile();
            if (client != null) {
                client.close();
            }
            if (oe != null) {
                throw oe;
            }
            break block37;
            {
                catch (Throwable t) {
                    while (t.getCause() != null) {
                        t = t.getCause();
                    }
                    OPatchException re = new OPatchException(t.getMessage());
                    re.setStackTrace(t.getStackTrace());
                    oe = re;
                    Object var16_35 = null;
                    OPatchUtils.updatePrereq(client, this);
                    try {
                        if (!oracleHomePath.equals("")) {
                            OPatchUtils.unlockHome(oracleHomePath);
                        }
                    }
                    catch (Throwable t2) {
                        String errorMsg9 = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
                        String stepMsg9 = "Check if OPatch can unlock the Oracle Home.";
                        RuntimeException re2 = new RuntimeException(t2.getMessage());
                        re2.setStackTrace(t2.getStackTrace());
                        failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg9, errorMsg9, re2);
                        this.setFailedClosingStep(failedStep);
                        OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                    }
                    OPatchUtils.closeLogFile();
                    if (client != null) {
                        client.close();
                    }
                    if (oe != null) {
                        throw oe;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var16_36 = null;
                OPatchUtils.updatePrereq(client, this);
                try {
                    if (!oracleHomePath.equals("")) {
                        OPatchUtils.unlockHome(oracleHomePath);
                    }
                }
                catch (Throwable t2) {
                    String errorMsg9 = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
                    String stepMsg9 = "Check if OPatch can unlock the Oracle Home.";
                    RuntimeException re2 = new RuntimeException(t2.getMessage());
                    re2.setStackTrace(t2.getStackTrace());
                    failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg9, errorMsg9, re2);
                    this.setFailedClosingStep(failedStep);
                    OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                }
                OPatchUtils.closeLogFile();
                if (client != null) {
                    client.close();
                }
                if (oe != null) {
                    throw oe;
                }
                throw throwable;
            }
        }
    }

    public void bindToClone(OPatchFAClonedConfigInstance faInstance, BI biObject) throws OPatchException {
        if (faInstance == null) {
            throw new OPatchException("Please provide a non-null <OPatchFAClonedConfigInstance> object.");
        }
        if (!OPatchUtils.checkFAObjectSanity(faInstance, (AbstractBaseTarget)biObject)) {
            throw new OPatchException("The system model object could not be binded to cloned config instances.");
        }
        this.setBoundToConfigInstance(true);
        this.biObject = biObject;
    }

    public Object clone() {
        OPatchBIPDeployAction bip = (OPatchBIPDeployAction)super.clone();
        bip.setBIHome(this.getBIHome());
        bip.setOriginalPatchLocation(this.getOriginalPatchLocation());
        Properties prop = this.getDynamicProperties();
        bip.setDynamicProperties((Properties)prop.clone());
        return bip;
    }
}

