/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import oracle.opatch.ApplySession;
import oracle.opatch.ArchiveAction;
import oracle.opatch.CopyAction;
import oracle.opatch.ExitOPatchException;
import oracle.opatch.JarAction;
import oracle.opatch.LsInventorySession;
import oracle.opatch.OPatch;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSession;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OUIReplacer;
import oracle.opatch.OUIVersion;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PartialPatchObject;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchingModel;
import oracle.opatch.Rac;
import oracle.opatch.UtilSession;
import oracle.opatch.ipm.IIPMRWServices;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.ipm.IPM;
import oracle.opatch.opatchext.BitVector;
import oracle.opatch.opatchext.Component;
import oracle.opatch.opatchext.FileInfo;
import oracle.opatch.opatchext.OHComponent;
import oracle.opatch.opatchext.Patch;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.ConflictHandler;
import oracle.opatch.opatchprereq.ConflictMatrixOutput;
import oracle.opatch.opatchprereq.PQSession;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchprereq.PrereqResult;

public class OPatchSDK {
    static LsInventorySession lsSession = OPatchSession.LSINVENTORY;

    private OPatchSDK() {
    }

    public static BitVector[][] conflictCheck(Patch[] set1, Patch[] set2, OHComponent[] ohcomps) throws RuntimeException {
        OneOffEntry oneoff;
        int i2;
        String patchID;
        int i3;
        for (i3 = 0; i3 < set1.length; ++i3) {
            patchID = set1[i3].getPatchID();
            if (patchID != null && !patchID.equals("")) continue;
            throw new RuntimeException("Some of the patch(es) in Set 1 have null or empty Patch IDs.");
        }
        for (i3 = 0; i3 < set2.length; ++i3) {
            patchID = set2[i3].getPatchID();
            if (patchID != null && !patchID.equals("")) continue;
            throw new RuntimeException("Some of the patch(es) in Set 2 have null or empty Patch IDs.");
        }
        OneOffEntry[] OneOffSet1 = new OneOffEntry[set1.length];
        OneOffEntry[] OneOffSet2 = new OneOffEntry[set2.length];
        BitVector[][] resultMatrix = new BitVector[set1.length][set2.length];
        for (i2 = 0; i2 < set1.length; ++i2) {
            OneOffSet1[i2] = oneoff = new OneOffEntry(set1[i2]);
        }
        for (i2 = 0; i2 < set2.length; ++i2) {
            OneOffSet2[i2] = oneoff = new OneOffEntry(set2[i2]);
        }
        for (i2 = 0; i2 < OneOffSet1.length; ++i2) {
            OneOffEntry fromPatch = OneOffSet1[i2];
            String patchModel1 = fromPatch.getPatchModel();
            int modelCode1 = PatchingModel.getModelCodeRep(patchModel1);
            Component[] compsPatch1 = set1[i2].getPatchComps();
            OPatchSDK.filterPatchComponents(ohcomps, compsPatch1);
            Vector<Component> compsList1 = new Vector<Component>();
            for (int k2 = 0; k2 < compsPatch1.length; ++k2) {
                if (!compsPatch1[k2].isValid()) continue;
                compsList1.add(compsPatch1[k2]);
            }
            for (int j2 = 0; j2 < OneOffSet2.length; ++j2) {
                BitVector bs;
                OneOffEntry toPatch = OneOffSet2[j2];
                String patchModel2 = toPatch.getPatchModel();
                int modelCode2 = PatchingModel.getModelCodeRep(patchModel2);
                Component[] compsPatch2 = set2[j2].getPatchComps();
                OPatchSDK.filterPatchComponents(ohcomps, compsPatch2);
                Vector<Component> compsList2 = new Vector<Component>();
                for (int k3 = 0; k3 < compsPatch2.length; ++k3) {
                    if (!compsPatch2[k3].isValid()) continue;
                    compsList2.add(compsPatch2[k3]);
                }
                resultMatrix[i2][j2] = bs = new BitVector();
                ConflictHandler conflictHandler = new ConflictHandler(true, true, true, true);
                String[] bugsThatSuperset = new String[1];
                String[] bugsThatConflict = new String[1];
                String[] bugsThatSubset = new String[1];
                if (PrereqAPI.isOverLayOneOffs(fromPatch, toPatch)) {
                    bs.setBit(0, true);
                }
                if (PrereqAPI.isOverLayOneOffs(toPatch, fromPatch)) {
                    bs.setBit(5, true);
                }
                try {
                    boolean isSuperset = false;
                    boolean isSubset = false;
                    boolean bugConflict = false;
                    String[] bugsToFix = fromPatch.getBugIDsFixed();
                    OneOffEntry[] fromPatchList = new OneOffEntry[1];
                    OneOffEntry[] toPatchList = new OneOffEntry[1];
                    fromPatchList[0] = fromPatch;
                    toPatchList[0] = toPatch;
                    if (conflictHandler.isBugSuperset(toPatchList, bugsToFix, bugsThatSuperset)) {
                        bs.setBit(2, true);
                        isSuperset = true;
                    } else if (conflictHandler.isBugSubset(toPatchList, bugsToFix, bugsThatSubset)) {
                        bs.setBit(3, true);
                        isSubset = true;
                    } else if (!(!conflictHandler.isBugConflict(toPatchList, bugsToFix, bugsThatConflict) || modelCode1 == 2 && modelCode2 == 2 || modelCode1 == 1 && modelCode2 == 2)) {
                        bs.setBit(1, true);
                        bugConflict = true;
                    }
                    bugsToFix = new String[]{};
                    bugsToFix = toPatch.getBugIDsFixed();
                    if (conflictHandler.isBugSuperset(fromPatchList, bugsToFix, bugsThatSuperset)) {
                        bs.setBit(7, true);
                        isSuperset = true;
                    } else if (conflictHandler.isBugSubset(fromPatchList, bugsToFix, bugsThatSubset)) {
                        bs.setBit(8, true);
                        isSubset = true;
                    } else if (!(!conflictHandler.isBugConflict(fromPatchList, bugsToFix, bugsThatConflict) || modelCode2 == 2 && modelCode1 == 2 || modelCode2 == 1 && modelCode1 == 2)) {
                        bs.setBit(6, true);
                        bugConflict = true;
                    }
                    if (OPatchSDK.isApplicable(ohcomps, set1[i2])) {
                        bs.setBit(9, true);
                    }
                    if (OPatchSDK.isApplicable(ohcomps, set2[j2])) {
                        bs.setBit(4, true);
                    }
                    if (isSuperset || isSubset || bugConflict) continue;
                    String[] filesTouched1 = new String[]{};
                    String[] filesTouched2 = new String[]{};
                    if (ohcomps != null && ohcomps.length != 0) {
                        compsList1.retainAll(compsList2);
                        compsList2.retainAll(compsList1);
                    }
                    filesTouched1 = OPatchSDK.getFilesTouched(compsList1);
                    filesTouched2 = OPatchSDK.getFilesTouched(compsList2);
                    block10: for (int k4 = 0; k4 < filesTouched1.length; ++k4) {
                        String[] partFile1 = filesTouched1[k4].split(Pattern.quote(File.separator));
                        for (int q2 = 0; q2 < filesTouched2.length; ++q2) {
                            String[] partFile2 = filesTouched2[q2].split(Pattern.quote(File.separator));
                            if (!ConflictHandler.compareFilesForConflict(partFile1, partFile2)) continue;
                            if (!(modelCode2 == 2 && modelCode1 == 2 || modelCode2 == 1 && modelCode1 == 2)) {
                                bs.setBit(6, true);
                            }
                            if (modelCode1 == 2 && modelCode2 == 2 || modelCode1 == 1 && modelCode2 == 2) continue block10;
                            bs.setBit(1, true);
                            continue block10;
                        }
                    }
                    continue;
                }
                catch (Exception e2) {
                    RuntimeException re = new RuntimeException(e2.getMessage());
                    re.setStackTrace(e2.getStackTrace());
                    throw re;
                }
            }
        }
        return resultMatrix;
    }

    private static String[] getFilesTouched(Vector comps) {
        Vector<String> filesTouched = new Vector<String>();
        for (int k2 = 0; k2 < comps.size(); ++k2) {
            Component c2 = (Component)comps.get(k2);
            FileInfo[] fi = c2.getFilesTouched();
            for (int q2 = 0; q2 < fi.length; ++q2) {
                filesTouched.add(fi[q2].getFilePath());
            }
        }
        String[] fileRep = new String[filesTouched.size()];
        for (int k3 = 0; k3 < filesTouched.size(); ++k3) {
            fileRep[k3] = (String)filesTouched.get(k3);
        }
        return fileRep;
    }

    private static void filterPatchComponents(OHComponent[] ohComps, Component[] patchComps) {
        if (ohComps == null || ohComps.length == 0) {
            return;
        }
        for (int i2 = 0; i2 < patchComps.length; ++i2) {
            String patchCompName = patchComps[i2].getName();
            String patchCompVersion = patchComps[i2].getVersion();
            boolean isFound = false;
            for (int j2 = 0; j2 < ohComps.length; ++j2) {
                String ohname = ohComps[j2].getName();
                String ohversion = ohComps[j2].getVersion();
                if (!ohname.equals(patchCompName) || !ohversion.equals(patchCompVersion)) continue;
                isFound = true;
                break;
            }
            if (isFound) continue;
            patchComps[i2].setValidity(false);
        }
    }

    private static boolean isApplicable(OHComponent[] ohComps, Patch p2) {
        if (ohComps == null || ohComps.length == 0) {
            return true;
        }
        Component[] patchComps = p2.getPatchComps();
        for (int i2 = 0; i2 < ohComps.length; ++i2) {
            String ohCompName = ohComps[i2].getName();
            String ohCompVersion = ohComps[i2].getVersion();
            boolean isFound = false;
            for (int j2 = 0; j2 < patchComps.length; ++j2) {
                String patchCompName = patchComps[j2].getName();
                String patchCompVersion = patchComps[j2].getVersion();
                if (!ohCompName.equals(patchCompName) || !ohCompVersion.equals(patchCompVersion)) continue;
                isFound = true;
                break;
            }
            if (isFound || !ohComps[i2].isRequired()) continue;
            return false;
        }
        return true;
    }

    public static void setOUIProperties(String customOUILocation) {
        System.setProperty("OPatch.OUI_LOCATION", customOUILocation);
        OPatch.setupEnvironment("");
    }

    public static void unLoadStaticReferences(boolean closeLog) {
        System.setProperty("OPatch.ORACLE_HOME", "");
        System.setProperty("OPatch.OUI_LOCATION", "");
        OPatchEnv.setInvPtrLoc(OPatchEnv.getDefault_OraInst());
        OPatchEnv.setOracleHome("");
        OPatchEnv.setPatchloc("");
        OPatchEnv.setUserSuppliedPatchIDs(new String[0]);
        OPatchEnv.setOneOffToRoll(new OneOffEntry[0]);
        IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
        readServices.destroy();
        try {
            if (closeLog) {
                OPatchSDK sdk = new OPatchSDK();
                OPatchACL.invokeOLogger(sdk, "closeLogFile", null);
                OPatchACL.invokeOLogger(sdk, "enableConsoleOutput", null);
                OPatchACL.invokeOLogger(sdk, "resetWarningList", null);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private static String[] tokenizeStringOnWhiteSpaces(String in) {
        String[] elements = null;
        elements = in != null && !in.equals("") ? in.split("\\s+") : new String[]{};
        return elements;
    }

    private static void initOPatchSDKApplyRollback(String oracleHomePath) {
        System.setProperty("OPatch.ORACLE_HOME", oracleHomePath);
        String ouiLoc = System.getProperty("OPatch.OUI_LOCATION");
        if (ouiLoc == null || ouiLoc.equals("")) {
            System.setProperty("OPatch.OUI_LOCATION", oracleHomePath + File.separator + "oui");
        }
        try {
            IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
            if (readServices.isLocked()) {
                readServices.release();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void simulateOPatchClass(String[] args) throws Exception {
        StringBuffer buff = new StringBuffer();
        Properties properties = System.getProperties();
        boolean noOUI = false;
        String OH = "";
        String oracleHomePath = System.getProperty("OPatch.ORACLE_HOME");
        StringBuffer option = new StringBuffer("-");
        option.append("oh");
        String optionOH = option.toString();
        if (args != null) {
            for (int i2 = 0; i2 < args.length; ++i2) {
                String arg = args[i2];
                if (arg == null || !arg.equals(optionOH) || i2 + 1 >= args.length || (OH = args[i2 + 1]) == null) continue;
                System.setProperty("OPatch.ORACLE_HOME", OH);
                oracleHomePath = OH;
            }
        }
        if (oracleHomePath == null || oracleHomePath.equals("")) {
            buff = new StringBuffer("OPatch cannot obtain the ORACLE_HOME value, exiting.");
            buff.append("\n(Please provide ORACLE_HOME by parameter or use -oh option)");
            throw new Exception(buff.toString());
        }
        PrereqResult result = PrereqAPI.isOHPathOK(oracleHomePath);
        if (result.getResult() == PrereqResult.ExecuteStatus.FAILED) {
            Vector resDetails = result.getResultDetails();
            buff = new StringBuffer("");
            for (int i3 = 0; i3 < resDetails.size(); ++i3) {
                buff.append((String)resDetails.get(i3));
                buff.append("\n");
            }
            throw new Exception(buff.toString());
        }
        OPatch.setupEnvironment(oracleHomePath);
        OPatchEnv.setOPatchSDKMode(true);
        OLogger.setOPatchCmdLineMode(false);
        try {
            if (OUIReplacer.isRootAccess(oracleHomePath)) {
                throw new Exception("The user is root. OPatch cannot continue if the user is root.");
            }
        }
        catch (RuntimeException e2) {
            Exception ex = new Exception(e2.getMessage());
            ex.setStackTrace(e2.getStackTrace());
            throw ex;
        }
    }

    /*
     * Loose catch block
     */
    public static void cleanup(String oracleHomePath, String optionStr) throws Exception, Throwable, Error {
        OPatchSDK.initOPatchSDKApplyRollback(oracleHomePath);
        StringBuffer buff = new StringBuffer("cleanup");
        buff.append(" ");
        buff.append(optionStr);
        buff.append(" ");
        String[] args = OPatchSDK.tokenizeStringOnWhiteSpaces(buff.toString());
        String logLoc = "";
        OPatchSDK sdk = new OPatchSDK();
        OPatchSDK.simulateOPatchClass(args);
        Object session = null;
        OPatchACL.invokeOLogger(sdk, "setTimeString", null);
        OPatchSession.main(args);
        Object var8_11 = null;
        logLoc = OPatchEnv.getLogFileNameAndLocation(oracleHomePath);
        IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
        if (readServices.isLocked()) {
            readServices.release();
        }
        OPatchACL.invokeOLogger(sdk, "closeLogFile", null);
        OPatchACL.invokeOLogger(sdk, "enableConsoleOutput", null);
        OPatchACL.invokeOLogger(sdk, "resetWarningList", null);
        {
            catch (Error e2) {
                throw e2;
            }
            catch (Exception e3) {
                throw e3;
            }
            catch (Throwable t) {
                throw t;
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            logLoc = OPatchEnv.getLogFileNameAndLocation(oracleHomePath);
            readServices = IPM.INSTANCE.getReadServices();
            if (readServices.isLocked()) {
                readServices.release();
            }
            OPatchACL.invokeOLogger(sdk, "closeLogFile", null);
            OPatchACL.invokeOLogger(sdk, "enableConsoleOutput", null);
            OPatchACL.invokeOLogger(sdk, "resetWarningList", null);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void apply(String oracleHomePath, String optionStr) throws Exception, Throwable, Error {
        OPatchSDK.initOPatchSDKApplyRollback(oracleHomePath);
        ApplySession.resetCompositeFilteredActions();
        StringBuffer buff = new StringBuffer("apply");
        buff.append(" ");
        buff.append(optionStr);
        buff.append(" ");
        String[] args = OPatchSDK.tokenizeStringOnWhiteSpaces(buff.toString());
        String logLoc = "";
        OPatchSDK sdk = new OPatchSDK();
        OPatchSDK.simulateOPatchClass(args);
        try {
            try {
                OPatchACL.invokeOLogger(sdk, "setTimeString", null);
                OPatchSessionHelper.updateHistoryFile(oracleHomePath, args);
                OPatchSession.main(args);
            }
            catch (ExitOPatchException e2) {
                Object var8_12 = null;
                logLoc = OPatchEnv.getLogFileNameAndLocation(oracleHomePath);
                OPatchSessionHelper.cleanupPatchUnzipArea();
                OPatchSessionHelper.cleanupUnzipActionArea();
                IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
                if (!readServices.isLocked()) return;
                readServices.release();
                return;
            }
            catch (Error e3) {
                throw e3;
            }
            catch (Exception e4) {
                throw e4;
            }
            catch (Throwable t) {
                throw t;
            }
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            logLoc = OPatchEnv.getLogFileNameAndLocation(oracleHomePath);
            OPatchSessionHelper.cleanupPatchUnzipArea();
            OPatchSessionHelper.cleanupUnzipActionArea();
            IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
            if (!readServices.isLocked()) throw throwable;
            readServices.release();
            throw throwable;
        }
        logLoc = OPatchEnv.getLogFileNameAndLocation(oracleHomePath);
        OPatchSessionHelper.cleanupPatchUnzipArea();
        OPatchSessionHelper.cleanupUnzipActionArea();
        IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
        if (!readServices.isLocked()) return;
        readServices.release();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void rollback(String oracleHomePath, String optionStr) throws Exception, Throwable, Error {
        OPatchSDK.initOPatchSDKApplyRollback(oracleHomePath);
        StringBuffer buff = new StringBuffer("rollback");
        buff.append(" ");
        buff.append(optionStr);
        buff.append(" ");
        String[] args = OPatchSDK.tokenizeStringOnWhiteSpaces(buff.toString());
        String logLoc = "";
        OPatchSDK sdk = new OPatchSDK();
        OPatchSDK.simulateOPatchClass(args);
        try {
            try {
                Object session = null;
                OPatchACL.invokeOLogger(sdk, "setTimeString", null);
                OPatchSessionHelper.updateHistoryFile(oracleHomePath, args);
                OPatchSession.main(args);
            }
            catch (Error e2) {
                throw e2;
            }
            catch (Exception e3) {
                throw e3;
            }
            catch (Throwable t) {
                throw t;
            }
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            logLoc = OPatchEnv.getLogFileNameAndLocation(oracleHomePath);
            OPatchSessionHelper.cleanupPatchUnzipArea();
            OPatchSessionHelper.cleanupUnzipActionArea();
            IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
            if (!readServices.isLocked()) throw throwable;
            readServices.release();
            throw throwable;
        }
        logLoc = OPatchEnv.getLogFileNameAndLocation(oracleHomePath);
        OPatchSessionHelper.cleanupPatchUnzipArea();
        OPatchSessionHelper.cleanupUnzipActionArea();
        IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
        if (!readServices.isLocked()) return;
        readServices.release();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void NApply(String oracleHomePath, String optionStr) throws Exception, Throwable, Error {
        OPatchSDK.initOPatchSDKApplyRollback(oracleHomePath);
        StringBuffer buff = new StringBuffer("napply");
        buff.append(" ");
        buff.append(optionStr);
        buff.append(" ");
        String[] args = OPatchSDK.tokenizeStringOnWhiteSpaces(buff.toString());
        String logLoc = "";
        OPatchSDK sdk = new OPatchSDK();
        OPatchSDK.simulateOPatchClass(args);
        try {
            try {
                Object session = null;
                OPatchACL.invokeOLogger(sdk, "setTimeString", null);
                OPatchSessionHelper.updateHistoryFile(oracleHomePath, args);
                OPatchSession.main(args);
            }
            catch (ExitOPatchException session) {
                Object var8_13 = null;
                logLoc = OPatchEnv.getLogFileNameAndLocation(oracleHomePath);
                OPatchSessionHelper.cleanupPatchUnzipArea();
                OPatchSessionHelper.cleanupUnzipActionArea();
                ApplySession.resetCompositeFilteredActions();
                IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
                if (!readServices.isLocked()) return;
                readServices.release();
                return;
            }
            catch (Error e2) {
                throw e2;
            }
            catch (Exception e3) {
                throw e3;
            }
            catch (Throwable t) {
                throw t;
            }
            Object var8_12 = null;
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            logLoc = OPatchEnv.getLogFileNameAndLocation(oracleHomePath);
            OPatchSessionHelper.cleanupPatchUnzipArea();
            OPatchSessionHelper.cleanupUnzipActionArea();
            ApplySession.resetCompositeFilteredActions();
            IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
            if (!readServices.isLocked()) throw throwable;
            readServices.release();
            throw throwable;
        }
        logLoc = OPatchEnv.getLogFileNameAndLocation(oracleHomePath);
        OPatchSessionHelper.cleanupPatchUnzipArea();
        OPatchSessionHelper.cleanupUnzipActionArea();
        ApplySession.resetCompositeFilteredActions();
        IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
        if (!readServices.isLocked()) return;
        readServices.release();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void NRollback(String oracleHomePath, String optionStr) throws Exception, Throwable, Error {
        OPatchSDK.initOPatchSDKApplyRollback(oracleHomePath);
        String command = "";
        command = OPatchEnv.isAll_Subpatches() ? "rollback" : "nrollback";
        StringBuffer buff = new StringBuffer(command);
        buff.append(" ");
        buff.append(optionStr);
        buff.append(" ");
        String[] args = OPatchSDK.tokenizeStringOnWhiteSpaces(buff.toString());
        String logLoc = "";
        OPatchSDK sdk = new OPatchSDK();
        OPatchSDK.simulateOPatchClass(args);
        try {
            try {
                Object session = null;
                OPatchACL.invokeOLogger(sdk, "setTimeString", null);
                OPatchSessionHelper.updateHistoryFile(oracleHomePath, args);
                OPatchSession.main(args);
            }
            catch (Error e2) {
                throw e2;
            }
            catch (Exception e3) {
                throw e3;
            }
            catch (Throwable t) {
                throw t;
            }
            Object var9_12 = null;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            logLoc = OPatchEnv.getLogFileNameAndLocation(oracleHomePath);
            OPatchSessionHelper.cleanupPatchUnzipArea();
            OPatchSessionHelper.cleanupUnzipActionArea();
            IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
            if (!readServices.isLocked()) throw throwable;
            readServices.release();
            throw throwable;
        }
        logLoc = OPatchEnv.getLogFileNameAndLocation(oracleHomePath);
        OPatchSessionHelper.cleanupPatchUnzipArea();
        OPatchSessionHelper.cleanupUnzipActionArea();
        IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
        if (!readServices.isLocked()) return;
        readServices.release();
    }

    public static String getCurrentOPatchSessionLogFile(String oracleHomePath) {
        return OPatchEnv.getLogFileNameAndLocation(oracleHomePath);
    }

    public static void unzip(String workDir, String zipFile) throws IOException {
        File f2 = new File(workDir);
        if (!f2.exists() || !f2.isDirectory()) {
            StringBuffer buff = new StringBuffer("Can't unzip file \"");
            buff.append(zipFile);
            buff.append("\" to directory \"");
            buff.append(workDir).append("\". Directory not exist or not writeable.");
            throw new IOException(buff.toString());
        }
        File fz = new File(zipFile);
        if (!f2.exists()) {
            StringBuffer buff = new StringBuffer("Can't unzip file \"");
            buff.append(zipFile);
            buff.append("\" to directory \"");
            buff.append(workDir).append("\". Zip file given doesn't exist.");
            throw new IOException(buff.toString());
        }
        FileOutputStream fout = null;
        byte[] b2 = new byte[1024];
        FileInputStream fin = new FileInputStream(fz);
        ZipInputStream zin = new ZipInputStream(fin);
        ZipEntry e2 = zin.getNextEntry();
        while (e2 != null) {
            String name = e2.getName();
            f2 = new File(workDir + File.separator + name);
            f2.delete();
            long size = e2.getSize();
            if (size == 0L) {
                f2.mkdirs();
            } else {
                int n2;
                fout = new FileOutputStream(f2);
                while ((n2 = zin.read(b2)) > -1) {
                    fout.write(b2, 0, n2);
                }
            }
            e2 = zin.getNextEntry();
        }
        try {
            fin.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            fout.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ConflictResult[] checkConflict(String oracleHomePath, String pathToOneoffZip, String pathToMapFile, String workDir) throws Exception {
        ConflictMatrixOutput resObj = null;
        File f2 = new File(oracleHomePath);
        if (!f2.exists()) {
            StringBuffer buff = new StringBuffer("Oracle Home \"").append(oracleHomePath);
            buff.append("\" doesn't exist.");
            throw new Exception(buff.toString());
        }
        f2 = new File(pathToOneoffZip);
        if (!f2.exists()) {
            StringBuffer buff = new StringBuffer("File \"").append(pathToOneoffZip);
            buff.append("\" doesn't exist.");
            throw new Exception(buff.toString());
        }
        f2 = new File(pathToMapFile);
        if (!f2.exists()) {
            StringBuffer buff = new StringBuffer("File \"").append(pathToMapFile);
            buff.append("\" doesn't exist.");
            throw new Exception(buff.toString());
        }
        f2 = new File(workDir);
        if (!f2.exists() || !f2.isDirectory()) {
            StringBuffer buff = new StringBuffer("Directory \"").append(workDir);
            buff.append("\" doesn't exist or is not a directory.");
            throw new Exception(buff.toString());
        }
        OPatchSDK.unzip(workDir, pathToOneoffZip);
        StringBuffer baseDir = new StringBuffer(workDir);
        baseDir.append(File.separator);
        baseDir.append("oneoffs");
        f2 = new File(baseDir.toString());
        if (!f2.exists()) {
            StringBuffer buff = new StringBuffer("Directory \"").append(baseDir.toString());
            buff.append("\" doesn't exist.");
            throw new IOException(buff.toString());
        }
        PartialPatchObject ppo = new PartialPatchObject();
        ppo.loadBaptaFile(pathToMapFile);
        ppo.createPatchMetadata(baseDir.toString());
        PQSession.phbasedir(baseDir.toString());
        resObj = PQSession.checkConflictAmongPatchesWithDetail(oracleHomePath);
        int row = 0;
        ConflictResult[] resultList = new ConflictResult[resObj.getColumnLength() - 1];
        for (int i2 = 0; i2 < resObj.getRowLength(); ++i2) {
            String patchID = resObj.getRowPatchID(i2, 0);
            if (!patchID.equals(ppo.getPatchID())) continue;
            row = i2;
            break;
        }
        int j2 = 0;
        int cntr = 0;
        while (j2 < resObj.getColumnLength()) {
            if (ppo.getPatchID().equals(resObj.getColumnPatchID(row, j2))) {
                --cntr;
            } else {
                ConflictResult cr;
                resultList[cntr] = cr = new ConflictResult(resObj.getColumnPatchID(row, j2), resObj.getConflictType(row, j2), resObj.getDetails(row, j2));
            }
            ++j2;
            ++cntr;
        }
        return resultList;
    }

    public static String getOUIVersionRequired() {
        return "10.2";
    }

    public OracleHome[] getAllOracleHomes(String oracleHomePath) {
        OracleHome[] homes = null;
        IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
        if (!readServices.isInventoryLoaded()) {
            boolean isLocked = readServices.isLocked();
            try {
                try {
                    if (!isLocked) {
                        readServices.lock(oracleHomePath);
                    }
                    readServices.loadInventory(oracleHomePath);
                }
                catch (Throwable e2) {
                    RuntimeException re = new RuntimeException("Unable to read the inventory.", e2);
                    throw re;
                }
                Object var8_5 = null;
                if (!isLocked) {
                    readServices.release();
                }
            }
            catch (Throwable throwable) {
                Object var8_6 = null;
                if (!isLocked) {
                    readServices.release();
                }
                throw throwable;
            }
        }
        homes = readServices.getOracleHomes();
        return homes;
    }

    public static String getOUIVersion() {
        return OUIVersion.getOUIVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shouldPropagate(String oracleHomePath) {
        boolean isRAC = false;
        Rac.RacType type = null;
        IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
        boolean isLocked = readServices.isLocked();
        try {
            try {
                OPatchEnv.setOUILocation(oracleHomePath, null);
                if (!isLocked) {
                    readServices.lock(oracleHomePath);
                }
                readServices.loadInventory(oracleHomePath);
                type = Rac.getInstance(readServices);
            }
            catch (Throwable t) {
                boolean bl = false;
                Object var8_6 = null;
                if (!isLocked) {
                    readServices.release();
                }
                return bl;
            }
            Object var8_5 = null;
            if (!isLocked) {
                readServices.release();
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (!isLocked) {
                readServices.release();
            }
            throw throwable;
        }
        return Rac.shouldPropagate(type);
    }

    public static boolean hasOneOffPatch(String oracleHomePath, String patchID) {
        if (oracleHomePath == null || patchID == null) {
            return false;
        }
        Object oneOff = null;
        try {
            OPatchSDK.getOneOffEntry(oracleHomePath, patchID);
        }
        catch (RuntimeException re) {
            return false;
        }
        return oneOff != null;
    }

    public static String[][] getFilesTouched(String oracleHomePath, String patchID) throws Exception {
        String[][] files = new String[0][0];
        Vector<String[]> filesVect = new Vector<String[]>();
        PatchObject patchObj = null;
        PatchAction[] patchActions = null;
        StringBuffer buff = new StringBuffer();
        patchObj = PatchObject.getInstance(oracleHomePath, patchID);
        patchActions = patchObj.getPatchActions();
        int len = patchActions.length;
        if (len > 0) {
            for (int j2 = 0; j2 < len; ++j2) {
                String[] a2;
                PatchAction p2 = patchActions[j2];
                if (p2 instanceof CopyAction) {
                    CopyAction cp = (CopyAction)p2;
                    a2 = new String[]{cp.getSourceFile(), cp.getParentFilePath(oracleHomePath)};
                    filesVect.addElement(a2);
                    continue;
                }
                if (p2 instanceof ArchiveAction) {
                    ArchiveAction ar = (ArchiveAction)p2;
                    a2 = new String[2];
                    buff = new StringBuffer(ar.getParentFilePath(oracleHomePath));
                    a2[0] = ar.getChildPath();
                    a2[1] = buff.toString();
                    filesVect.addElement(a2);
                    continue;
                }
                if (!(p2 instanceof JarAction)) continue;
                JarAction jr = (JarAction)p2;
                a2 = new String[2];
                buff = new StringBuffer(jr.getChildPath());
                a2[0] = buff.toString();
                buff = new StringBuffer(jr.getCompleteFileListPath(oracleHomePath));
                a2[1] = buff.toString();
                filesVect.addElement(a2);
            }
        }
        String[] executables = patchObj.getExecutables(oracleHomePath);
        for (int i2 = 0; i2 < executables.length; ++i2) {
            String[] a3 = new String[]{"", executables[i2]};
            filesVect.addElement(a3);
        }
        int filesLen = filesVect.size();
        files = new String[filesLen][0];
        for (int i3 = 0; i3 < filesLen; ++i3) {
            files[i3] = (String[])filesVect.elementAt(i3);
        }
        return files;
    }

    public static String[][] getFilesTouched(String patchLocation) throws Exception {
        String[][] files = new String[0][0];
        Vector<String[]> filesVect = new Vector<String[]>();
        PatchObject patchObj = null;
        PatchAction[] patchActions = null;
        patchObj = PatchObject.getInstance(patchLocation);
        patchActions = patchObj.getPatchActions();
        int len = patchActions.length;
        if (len > 0) {
            for (int j2 = 0; j2 < len; ++j2) {
                String[] a2;
                StringBuffer tmpSb;
                PatchAction p2 = patchActions[j2];
                if (p2 instanceof CopyAction) {
                    CopyAction cp = (CopyAction)p2;
                    tmpSb = new StringBuffer("%ORACLE_HOME%");
                    tmpSb.append(File.separator);
                    tmpSb.append(cp.getFilename());
                    a2 = new String[]{cp.getSourceFile(), tmpSb.toString()};
                    filesVect.addElement(a2);
                    continue;
                }
                if (p2 instanceof ArchiveAction) {
                    ArchiveAction ar = (ArchiveAction)p2;
                    tmpSb = new StringBuffer("%ORACLE_HOME%");
                    tmpSb.append(File.separator);
                    tmpSb.append(ar.getArchivePath());
                    tmpSb.append(File.separator);
                    tmpSb.append(ar.getArchiveFilename());
                    a2 = new String[]{ar.getChildPath(), tmpSb.toString()};
                    filesVect.addElement(a2);
                    continue;
                }
                if (!(p2 instanceof JarAction)) continue;
                JarAction jr = (JarAction)p2;
                tmpSb = new StringBuffer(jr.getCompleteFileListPath("%ORACLE_HOME%"));
                a2 = new String[]{jr.getChildPath(), tmpSb.toString()};
                filesVect.addElement(a2);
            }
        }
        String[] executables = patchObj.getExecutables();
        for (int i2 = 0; i2 < executables.length; ++i2) {
            String[] a3 = new String[]{"", executables[i2]};
            filesVect.addElement(a3);
        }
        int filesLen = filesVect.size();
        files = new String[filesLen][0];
        for (int i3 = 0; i3 < filesLen; ++i3) {
            files[i3] = (String[])filesVect.elementAt(i3);
        }
        return files;
    }

    public static boolean isNewFile(String oracleHomePath, String cookedPatchID, String fileName) throws RuntimeException {
        StringBuffer buff = new StringBuffer(oracleHomePath);
        buff.append(File.separator);
        buff.append(fileName);
        File fileInOH = new File(buff.toString());
        if (fileInOH.exists()) {
            buff = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
            buff.append(File.separator);
            buff.append(fileName);
            File fileInPS = new File(buff.toString());
            if (fileInPS.exists()) {
                return false;
            }
            buff = new StringBuffer(OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID));
            buff.append(File.separator);
            buff.append(fileName);
            buff.append("_opatch_");
            buff.append(cookedPatchID);
            File tmpltFile = new File(buff.toString());
            if (tmpltFile.exists()) {
                return true;
            }
            RuntimeException re = new RuntimeException("File is present in OH, but not in <OH>/.patch_storage");
            throw re;
        }
        RuntimeException re = new RuntimeException("File not present in OH.");
        throw re;
    }

    public static boolean isNewFile(String oracleHomePath, String fileName) {
        StringBuffer buff = new StringBuffer(oracleHomePath);
        buff.append(File.separator);
        buff.append(fileName);
        File fileInOH = new File(buff.toString());
        return !fileInOH.exists();
    }

    public static void printOneOffs(OneOffEntry[] oneoffs) {
        if (oneoffs != null && oneoffs.length != 0) {
            for (int i2 = 0; i2 < oneoffs.length; ++i2) {
                OneOffEntry oneoff = oneoffs[i2];
                String ID = oneoff.getID();
                String[] bugsFixed = oneoff.getBugIDsFixed();
                System.out.println("Patch " + ID);
                System.out.println("  Bugs fixed:");
                for (int j2 = 0; j2 < bugsFixed.length; ++j2) {
                    String bug = bugsFixed[i2];
                    System.out.println("    " + bug);
                }
            }
        } else {
            System.out.println("No Interim Patch found");
        }
    }

    public static void setDebug() {
        try {
            OPatchACL.invokeOLogger(new OPatchSDK(), "setDebug", new Object[]{true});
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public static void setOraInstLoc(String customInvPtr) {
        if (customInvPtr == null || customInvPtr == "") {
            throw new RuntimeException("oraInst.loc specifed is not valid");
        }
        OPatchEnv.setInvPtrLocSpecified();
        OPatchEnv.setInvPtrLoc(customInvPtr);
    }

    public static OneOffEntry getOneOffEntry(String patchLocation) throws RuntimeException {
        try {
            PatchObject pObj = PatchObject.getInstance(patchLocation);
            return pObj.toOneOffEntry("ORACLE_HOME");
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(e2);
            throw re;
        }
    }

    public static OneOffEntry getOneOffEntry(InputStream inventoryStream, InputStream actionsStream, InputStream oextJarStream) throws RuntimeException {
        try {
            PatchObject pObj = new PatchObject(inventoryStream, actionsStream, oextJarStream);
            return pObj.toOneOffEntry("ORACLE_HOME");
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(e2);
            throw re;
        }
    }

    public static OneOffEntry getOneOffEntryWithoutInventoryLoad(String oracleHomePath, String patchID) throws RuntimeException {
        try {
            PatchObject pObj = PatchObject.getInstance(oracleHomePath, patchID);
            return pObj.toOneOffEntry("ORACLE_HOME");
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(e2);
            throw re;
        }
    }

    public static OneOffEntry getOneOffEntry(String oracleHomePath, String patchID, boolean inactive) throws RuntimeException {
        int i2;
        IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
        OPatchEnv.setOUILocation(oracleHomePath, null);
        if (!readServices.isInventoryLoaded()) {
            boolean isLocked = readServices.isLocked();
            try {
                try {
                    if (!isLocked) {
                        readServices.lock(oracleHomePath);
                    }
                    readServices.loadInventory(oracleHomePath);
                }
                catch (Throwable e2) {
                    RuntimeException re = new RuntimeException("Unable to read the inventory.", e2);
                    throw re;
                }
                Object var8_6 = null;
                if (!isLocked) {
                    readServices.release();
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                if (!isLocked) {
                    readServices.release();
                }
                throw throwable;
            }
        }
        OneOffEntry[] oneOffs = readServices.getInstalledPatches();
        for (i2 = 0; i2 < oneOffs.length; ++i2) {
            if (!patchID.equals(oneOffs[i2].getID())) continue;
            return oneOffs[i2];
        }
        if (inactive) {
            oneOffs = readServices.getInactivePatches();
            for (i2 = 0; i2 < oneOffs.length; ++i2) {
                if (!patchID.equals(oneOffs[i2].getID())) continue;
                return oneOffs[i2];
            }
        }
        return null;
    }

    public static OneOffEntry getOneOffEntry(String oracleHomePath, String patchID) throws RuntimeException {
        IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
        OPatchEnv.setOUILocation(oracleHomePath, null);
        if (!readServices.isInventoryLoaded()) {
            boolean isLocked = readServices.isLocked();
            try {
                try {
                    if (!isLocked) {
                        readServices.lock(oracleHomePath);
                    }
                    readServices.loadInventory(oracleHomePath);
                }
                catch (Throwable e2) {
                    RuntimeException re = new RuntimeException("Unable to read the inventory.", e2);
                    throw re;
                }
                Object var7_5 = null;
                if (!isLocked) {
                    readServices.release();
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (!isLocked) {
                    readServices.release();
                }
                throw throwable;
            }
        }
        OneOffEntry[] oneOffs = readServices.getInstalledPatches();
        for (int i2 = 0; i2 < oneOffs.length; ++i2) {
            if (!patchID.equals(oneOffs[i2].getID())) continue;
            return oneOffs[i2];
        }
        return null;
    }

    public static OneOffEntry[] getAllOneOffEntry(String oracleHomePath) {
        OneOffEntry[] oneOffs = null;
        IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
        OPatchEnv.setOUILocation(oracleHomePath, null);
        if (!readServices.isInventoryLoaded()) {
            boolean isLocked = readServices.isLocked();
            try {
                try {
                    if (!isLocked) {
                        readServices.lock(oracleHomePath);
                    }
                    readServices.loadInventory(oracleHomePath);
                }
                catch (Throwable e2) {
                    RuntimeException re = new RuntimeException("Unable to read the inventory.", e2);
                    throw re;
                }
                Object var7_4 = null;
                if (!isLocked) {
                    readServices.release();
                }
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                if (!isLocked) {
                    readServices.release();
                }
                throw throwable;
            }
        }
        oneOffs = readServices.getInstalledPatches();
        return oneOffs;
    }

    public static String init(String oh) {
        try {
            OPatchSDK sdk = new OPatchSDK();
            OPatchACL.invokeOLogger(sdk, "setTimeString", null);
            OPatchACL.invokeOLogger(sdk, "initJavaLogger", new Object[]{oh, "OFF", "INFO"});
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        try {
            IIPMRWServices rwServices = UtilSession.getRWServices(oh);
            StringBuffer buff = new StringBuffer("Inventory object is loaded properly for home ");
            buff.append(rwServices.getOracleHomePath());
            OLogger.debug(buff);
        }
        catch (Throwable t) {
            OLogger.error("OUI-67064", new Object[]{oh});
            throw new RuntimeException(t);
        }
        return OPatchEnv.getLogFileNameAndLocation(oh);
    }

    public static String init(String oh, String cookedPatchID, String keyword) {
        try {
            OPatchSDK sdk = new OPatchSDK();
            OPatchACL.invokeOLogger(sdk, "setTimeString", null);
            OPatchACL.invokeOLogger(sdk, "initJavaLogger", new Object[]{oh, cookedPatchID, keyword, "OFF", "INFO", false, false});
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        try {
            IIPMRWServices rwServices = UtilSession.getRWServices(oh);
            StringBuffer buff = new StringBuffer("Inventory object is loaded properly for home ");
            buff.append(rwServices.getOracleHomePath());
            OLogger.debug(buff);
        }
        catch (Throwable t) {
            OLogger.error("OUI-67064", new Object[]{oh});
            throw new RuntimeException(t);
        }
        return OLogger.getLogFileLocation();
    }

    public static String initLogFile(String oh) {
        try {
            OPatchEnv.setOPatchSDKMode(true);
            OLogger.setOPatchCmdLineMode(false);
            OPatchSDK sdk = new OPatchSDK();
            OPatchACL.invokeOLogger(sdk, "setTimeString", null);
            OPatchACL.invokeOLogger(sdk, "initJavaLogger", new Object[]{oh, "OFF", "INFO"});
            OPatchACL.invokeOLogger(sdk, "disableConsoleOutput", null);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        return OPatchEnv.getLogFileNameAndLocation(oh);
    }

    public static String initLogFileIfUninitialized(String oh) {
        try {
            OPatchEnv.setOPatchSDKMode(true);
            OLogger.setOPatchCmdLineMode(false);
            OPatchSDK sdk = new OPatchSDK();
            OPatchACL.invokeOLogger(sdk, "initJavaLoggerIfUninitialized", new Object[]{oh, "OFF", "INFO"});
            OPatchACL.invokeOLogger(sdk, "enableConsoleOutput", null);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        return OPatchEnv.getLogFileNameAndLocation(oh);
    }

    public static void enableConsoleOutput() {
        try {
            OPatchSDK sdk = new OPatchSDK();
            OPatchACL.invokeOLogger(sdk, "enableConsoleOutput", null);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static void disableConsoleOutput() {
        try {
            OPatchSDK sdk = new OPatchSDK();
            OPatchACL.invokeOLogger(sdk, "disableConsoleOutput", null);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static String initLogFile(String oh, String cookedPatchID, String keyword, boolean printLogFile, boolean plainFileFormat) {
        try {
            OPatchSDK sdk = new OPatchSDK();
            OPatchACL.invokeOLogger(sdk, "setTimeString", null);
            OPatchACL.invokeOLogger(sdk, "initJavaLogger", new Object[]{oh, cookedPatchID, keyword, "OFF", "INFO", printLogFile, plainFileFormat});
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        return OLogger.getLogFileLocation();
    }

    public static String initLogFile(String oh, String cookedPatchID, String keyword, boolean printLogFile) {
        try {
            OPatchSDK sdk = new OPatchSDK();
            OPatchACL.invokeOLogger(sdk, "setTimeString", null);
            OPatchACL.invokeOLogger(sdk, "initJavaLogger", new Object[]{oh, cookedPatchID, keyword, "OFF", "INFO", printLogFile, false});
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        return OLogger.getLogFileLocation();
    }

    public static void lockHome(String oh) {
    }

    public static void setEnableConsoleLater(boolean b2) {
        try {
            OPatchACL.invokeOLogger(new OPatchSDK(), "setEnableConsoleLater", new Object[]{true});
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public static void close() {
        OPatchSDK sdk = new OPatchSDK();
        try {
            OPatchACL.invokeOLogger(sdk, "closeLogFile", null);
            OPatchACL.invokeOLogger(sdk, "enableConsoleOutput", null);
            OPatchACL.invokeOLogger(sdk, "resetWarningList", null);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        OLogger.flushBufferToStdOutput();
        OPatchEnv.setSpecifiedOLoggerPatchID("");
        OPatchEnv.setSpecifiedOLoggerPatchLoc("");
        OPatchEnv.setLogFileLocationSpecified(false);
        OPatchEnv.setSessionName("");
    }

    public static void closeLogFile() {
        OPatchSDK sdk = new OPatchSDK();
        try {
            OPatchACL.invokeOLogger(sdk, "closeLogFile", null);
            OPatchACL.invokeOLogger(sdk, "enableConsoleOutput", null);
            OPatchACL.invokeOLogger(sdk, "resetWarningList", null);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        OLogger.flushBufferToStdOutput();
        OPatchEnv.setSpecifiedOLoggerPatchID("");
        OPatchEnv.setSpecifiedOLoggerPatchLoc("");
        OPatchEnv.setLogFileLocationSpecified(false);
        OPatchEnv.setSessionName("");
    }

    public static class ConflictResult {
        String patchID;
        ConflictType ct = ConflictType.NO_CONFLICT;
        String[] details = null;

        protected ConflictResult(String patchID, ConflictMatrixOutput.ConflictType ct, String[] details) {
            this.patchID = patchID;
            this.details = details;
            if (ct == ConflictMatrixOutput.ConflictType.NO_CONFLICT) {
                this.ct = ConflictType.NO_CONFLICT;
            } else if (ct == ConflictMatrixOutput.ConflictType.BUG_SUPERSET) {
                this.ct = ConflictType.BUG_SUPERSET;
            } else if (ct == ConflictMatrixOutput.ConflictType.BUG_SUBSET) {
                this.ct = ConflictType.BUG_SUBSET;
            } else if (ct == ConflictMatrixOutput.ConflictType.BUG_CONFLICT) {
                this.ct = ConflictType.BUG_CONFLICT;
            } else if (ct == ConflictMatrixOutput.ConflictType.GENERIC_CONFLICT) {
                this.ct = ConflictType.FILE_CONFLICT;
            } else if (ct == ConflictMatrixOutput.ConflictType.IDENTICAL_PATCH) {
                this.ct = ConflictType.IDENTICAL_PATCH;
            }
        }

        public ConflictType getConflictType() {
            return this.ct;
        }

        public String[] getDetails() {
            return this.details;
        }

        public String getPatchID() {
            return this.patchID;
        }

        public static class ConflictType {
            int state;
            public static ConflictType NO_CONFLICT = new ConflictType(0);
            public static ConflictType BUG_SUPERSET = new ConflictType(1);
            public static ConflictType BUG_SUBSET = new ConflictType(2);
            public static ConflictType BUG_CONFLICT = new ConflictType(3);
            public static ConflictType FILE_CONFLICT = new ConflictType(4);
            public static ConflictType IDENTICAL_PATCH = new ConflictType(5);

            private ConflictType() {
            }

            public ConflictType(int state) {
                this.state = state;
            }
        }
    }

    public static class OracleHome {
        String oracleHomeName;
        String oracleHomeLocation;
        int index;

        public OracleHome(String name, String loc, int index) {
            this.oracleHomeName = name;
            this.oracleHomeLocation = loc;
            this.index = index;
        }

        String getName() {
            return this.oracleHomeName;
        }

        public String getLocation() {
            return this.oracleHomeLocation;
        }

        int getIndex() {
            return this.index;
        }
    }
}

