/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.opatch.OPatchEnv;
import oracle.opatch.StringResource;
import oracle.opatch.SystemCall;
import oracle.opatch.opatchlogger.OLogger;
import oracle.sysman.ccr.collector.install.ConfigResponse;
import oracle.sysman.oii.oiix.OiixEnvironmentOps;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPlatform;

public class OUIReplacer {
    protected static void runEnvScript(String filePath) {
        File f2 = null;
        FileWriter fWriter = null;
        PrintWriter pWriter = null;
        StringBuffer buff = new StringBuffer("OUIReplacer::runEnvScript() called");
        OLogger.debug(buff);
        try {
            f2 = new File(filePath);
            f2.createNewFile();
        }
        catch (IOException e2) {
            buff = new StringBuffer("cannot create file : " + filePath);
            OLogger.printlnOnLog(OLogger.INFO, buff.toString());
            OLogger.printStackTrace(e2);
            return;
        }
        try {
            fWriter = new FileWriter(f2);
            pWriter = new PrintWriter(fWriter);
        }
        catch (IOException e3) {
            buff = new StringBuffer("cannot write script to file : " + filePath);
            OLogger.printlnOnLog(OLogger.INFO, buff.toString());
            OLogger.printStackTrace(e3);
            return;
        }
        pWriter.println(StringResource.getEnvScriptString());
        pWriter.flush();
        try {
            fWriter.close();
        }
        catch (IOException e4) {
            buff = new StringBuffer("cannot close the file : " + filePath);
            OLogger.printlnOnLog(OLogger.INFO, buff.toString());
            OLogger.printStackTrace(e4);
        }
        SystemCall.ExecReturn ret = null;
        ret = !OPatchEnv.isWindows() ? SystemCall.runtimeExec("sh " + filePath) : SystemCall.runtimeExec("cmd /C \"" + filePath + "\"");
        if (!ret.isOK()) {
            buff = new StringBuffer("Failure in script execution,  Message reported :");
            buff.append("\n");
            buff.append(ret.getErrorMessage());
            OLogger.printlnOnLog(OLogger.INFO, buff.toString());
            return;
        }
        String checkStr = ret.getNormalMessage();
        if (checkStr != null) {
            String envStr = OUIReplacer.makeStringCompatible(checkStr);
            Properties p2 = OUIReplacer.setKeyValue(envStr);
            OPatchEnv.setEnvInfo(p2);
        }
    }

    private static String makeStringCompatible(String input) {
        char[] strArray = new char[input.length()];
        LinkedList<Character> charList = new LinkedList<Character>();
        Character c2 = null;
        input.getChars(0, input.length(), strArray, 0);
        for (int count = 0; count < input.length(); ++count) {
            if (strArray[count] == ':' || strArray[count] == '\\' || strArray[count] == ' ' || strArray[count] == '\t') {
                c2 = new Character('\\');
                charList.add(c2);
            }
            c2 = new Character(strArray[count]);
            charList.add(c2);
        }
        StringBuffer newString = new StringBuffer();
        for (int i2 = 0; i2 < charList.size(); ++i2) {
            c2 = (Character)charList.get(i2);
            newString.append(c2.toString());
        }
        return newString.toString();
    }

    private static Properties setKeyValue(String input) {
        StringBuffer buff = null;
        Properties p2 = new Properties();
        ByteArrayInputStream inStream = null;
        buff = new StringBuffer("OUIReplacer::setKeyValue() called");
        OLogger.debug(buff);
        try {
            inStream = new ByteArrayInputStream(input.getBytes());
            p2.load(inStream);
        }
        catch (IOException e2) {
            buff = new StringBuffer("cannot load key-value pairs from the given input string");
            OLogger.debug(buff);
            buff.append("\n");
            buff.append("STRING is : ");
            buff.append(input);
            OLogger.printlnOnLog(OLogger.INFO, buff.toString());
            return null;
        }
        return p2;
    }

    public static String getEnv(String varName) {
        return OiixEnvironmentOps.getEnv((String)varName);
    }

    public static void setEnv(String varName, String varValue) {
        OiixEnvironmentOps.setEnv((String)varName, (String)varValue);
    }

    public static void setEnv(String varName, String varValue, boolean append) {
        if (append) {
            String separator = System.getProperty("path.separator");
            String existingValue = OUIReplacer.getEnv(varName);
            StringBuffer newValue = new StringBuffer();
            if (existingValue != null && !existingValue.trim().equals("")) {
                newValue.append(existingValue);
            }
            newValue.append(separator);
            newValue.append(varValue);
            varValue = newValue.toString();
        }
        OUIReplacer.setEnv(varName, varValue);
    }

    private static boolean checkStrForPermission(String input) {
        char[] strArray = new char[input.length()];
        Object c2 = null;
        input.getChars(0, input.length(), strArray, 0);
        for (int count = 0; count < input.length(); ++count) {
            if (strArray[count] == 'r' || strArray[count] == 'w' || strArray[count] == 'x' || strArray[count] == '-' || strArray[count] == 's' || strArray[count] == 't' || strArray[count] == 'S' || strArray[count] == 'T' || strArray[count] == 'd') continue;
            return false;
        }
        return true;
    }

    private static int getPermValue(String input) {
        int perm = 0;
        int sPerm = 0;
        StringBuffer strPerm = new StringBuffer("");
        StringBuffer startPerm = new StringBuffer("");
        int localCount = 0;
        int groupCount = 0;
        char[] strArray = new char[input.length()];
        Object c2 = null;
        input.getChars(0, input.length(), strArray, 0);
        for (int count = 0; count < input.length(); ++count) {
            if (count == 0) continue;
            if (localCount == 0) {
                ++groupCount;
            }
            ++localCount;
            if (strArray[count] == 'r') {
                perm += 4;
            }
            if (strArray[count] == 'w') {
                perm += 2;
            }
            if (strArray[count] == 'x') {
                ++perm;
            }
            if (strArray[count] == 's' || strArray[count] == 't' || strArray[count] == 'S' || strArray[count] == 'T') {
                switch (groupCount) {
                    case 1: {
                        sPerm += 4;
                        break;
                    }
                    case 2: {
                        sPerm += 2;
                        break;
                    }
                    case 3: {
                        ++sPerm;
                    }
                }
            }
            if (localCount != 3) continue;
            strPerm.append(new Integer(perm).toString());
            localCount = 0;
            perm = 0;
        }
        startPerm.append(new Integer(sPerm).toString());
        startPerm.append(strPerm);
        try {
            perm = Integer.parseInt(startPerm.toString(), 8);
        }
        catch (NumberFormatException e2) {
            OLogger.printlnOnLog(OLogger.INFO, "Permission derived from OUIReplacer::getPermValue() is : " + startPerm);
            OLogger.printStackTrace(e2);
            OLogger.printlnOnLog(OLogger.INFO, "Returning file permission as 755");
            return 493;
        }
        return perm;
    }

    public static int getPermission(String fileName) {
        return OiixFileOps.getPermission((String)fileName);
    }

    public static String getFileOwnerInfo(String fileName) {
        String retFileUserInfo = "";
        SystemCall.ExecReturn ret = null;
        String listCmd = "";
        if (fileName == null) {
            OLogger.printlnOnLog("getFileOwnerInfo() gets fileName=null. Returning empty string to caller");
            return retFileUserInfo;
        }
        File file = new File(fileName);
        if (!file.exists()) {
            OLogger.printlnOnLog(MessageFormat.format("getFileOwnerInfo() fileName={0} is not existed. Returning empty string to caller", fileName));
            return retFileUserInfo;
        }
        listCmd = file.isDirectory() ? "ls -dl" : "ls -l";
        ret = SystemCall.runtimeExec(listCmd + " " + fileName);
        if (!ret.isOK()) {
            StringBuffer buff = new StringBuffer("Failure in script execution,  Message reported :");
            buff.append("\n");
            buff.append(ret.getErrorMessage());
            boolean calledFromOUI = Boolean.getBoolean("oracle.opatch.opatchprereq.calledFromOUI");
            if (!calledFromOUI) {
                OLogger.printlnOnLog(OLogger.INFO, buff.toString());
                OLogger.printlnOnLog(OLogger.INFO, new StringBuffer("FileName is : " + fileName).toString());
            } else {
                OLogger.justlog(OLogger.INFO, buff.toString());
                OLogger.justlog(OLogger.INFO, new StringBuffer("FileName is : " + fileName).toString());
            }
            return retFileUserInfo;
        }
        StringTokenizer strTok = new StringTokenizer(ret.getNormalMessage(), " ");
        int i2 = 0;
        while (strTok.hasMoreTokens()) {
            String curStr = strTok.nextToken();
            if (i2 == 2 && curStr != null) {
                retFileUserInfo = curStr;
            }
            ++i2;
        }
        return retFileUserInfo;
    }

    public static boolean canWriteForHpPlatform(String fileName) {
        int remaining;
        int temp;
        int temp2;
        int filePerm = 493;
        String fileGroupName = "";
        String curGroupName = "";
        String curUserName = "";
        Object ret = null;
        filePerm = OUIReplacer.getPermission(fileName);
        String fileUserName = OUIReplacer.getFileOwnerInfo(fileName);
        try {
            if (!fileUserName.equals("")) {
                fileGroupName = OiixEnvironmentOps.ssgetCurrentActiveUserGroupux((String)fileUserName);
            }
            if (!(curUserName = OiixEnvironmentOps.ssgetUidNameux()).equals("")) {
                curGroupName = OiixEnvironmentOps.ssgetCurrentActiveUserGroupux((String)curUserName);
            }
        }
        catch (Exception e2) {
            throw new RuntimeException("Error in get the current active user info.", e2);
        }
        return !fileUserName.equals("") && !curUserName.equals("") && fileUserName.equals(curUserName) ? (temp2 = filePerm / 8 * 8) == 2 || temp2 == 3 || temp2 >= 6 : (!fileGroupName.equals("") && !curGroupName.equals("") && fileGroupName.equals(curGroupName) ? (temp = (remaining = filePerm % 8 * 8) / 8) == 2 || temp == 3 || temp >= 6 : (temp = (remaining = filePerm % 8 * 8) % 8) == 2 || temp == 3 || temp >= 6);
    }

    public static void changePermission(String fileName, int perm) {
        OiixFileOps.changePermission((String)fileName, (int)perm);
    }

    public static void createResponseFile(String responseFileLocation, String topLevelDir) throws Exception {
        StringBuffer buff = new StringBuffer("OUIReplacer::createResponseFile()");
        OLogger.debug(buff);
        try {
            ConfigResponse.createResponseFile((String)responseFileLocation, (String)topLevelDir);
            OLogger.println("\n");
        }
        catch (Exception e2) {
            throw e2;
        }
        catch (Throwable t) {
            OLogger.printStackTrace(t);
            throw new Exception(t.getMessage());
        }
    }

    public static boolean isRootAccess(String oracleHomePath) throws Exception {
        if (OPatchEnv.isWindows()) {
            return false;
        }
        try {
            int rootCheck = OiixEnvironmentOps.ssgetUidux();
            return rootCheck == 0;
        }
        catch (Exception e2) {
            RuntimeException rte = new RuntimeException(e2.getMessage());
            rte.setStackTrace(e2.getStackTrace());
            throw rte;
        }
    }

    public static void createSimlink(String location, String simlink) throws RuntimeException {
        StringBuffer buff = new StringBuffer();
        buff.append("OUIReplacer::createSimlink()");
        buff.append(": create simlink ");
        buff.append(simlink);
        buff.append(" to ");
        buff.append(location);
        OLogger.debug(buff);
        try {
            OiixFileOps.createLink((String)location, (String)simlink);
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(e2);
            buff = new StringBuffer();
            buff.append("OUIReplacer::createSimlink() failed, ");
            buff.append(e2.getMessage());
            OLogger.debug(buff);
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
    }

    public static class Platform {
        public static final int LINUX = 46;
        public static final int AIX = 610;
        public static final int SEQUENT = 198;
        public static final int LINUX_PPC = 227;
        public static final int UNKNOWN = 0;

        public static String getCurrentPlatformDirectoryName() {
            return OiixPlatform.getCurrentPlatformDirectoryName();
        }

        public static int getCurrentPlatform() {
            int id = 0;
            if (!Boolean.getBoolean("OPatch.SA_HOME")) {
                id = OiixPlatform.getCurrentPlatform();
            }
            return id;
        }

        public static Vector getCurrentPlatformVector() {
            return OiixPlatform.getCurrentPlatformVector();
        }

        public static String getCurrentPlatformOSName() {
            return OiixPlatform.getCurrentPlatformOSName();
        }
    }
}

