/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.opatch.CopyAction;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.PatchAction;
import oracle.opatch.opatchlogger.OLogger;

public class PatchmdXml {
    private String sqlPath = "";
    private String applySqlFileName = "";
    private String rollbackSqlFileName = "";

    public String getSqlPath() {
        return this.sqlPath;
    }

    private PatchmdXml() {
    }

    public PatchmdXml(String oracleHomePath, String patchLocation, boolean isApply, ListIterator copy, String patchID) throws RuntimeException {
        String sqlPath;
        if (!OPatchEnv.isRunSql()) {
            return;
        }
        StringBuffer patchmdxmlFilePath = new StringBuffer(patchLocation);
        patchmdxmlFilePath.append(File.separator);
        patchmdxmlFilePath.append("patchmd.xml");
        this.parsePatchmdXmlFile(patchmdxmlFilePath.toString(), isApply, patchID);
        if (this.applySqlFileName.equals("") && isApply || this.rollbackSqlFileName.equals("") && !isApply) {
            return;
        }
        this.sqlPath = sqlPath = this.getSqlPath(copy, patchLocation, isApply, oracleHomePath, patchID);
    }

    private void parsePatchmdXmlFile(String filePath, boolean isApply, String patchID) {
        StringBuffer buff = new StringBuffer("PatchmdXml::parsePatchmdXmlFile()");
        OLogger.debug(buff);
        File f2 = new File(filePath);
        if (!f2.exists() || !f2.canRead()) {
            buff = new StringBuffer("The 'patchmd.xml' file does not exist (or) could not be read");
            buff.append("\nLocation of 'patchmd.xml' file given to search is :" + filePath);
            OLogger.printlnOnLog(OLogger.INFO, buff.toString());
            return;
        }
        String fileContents = "";
        try {
            fileContents = OPatchSessionHelper.readTextFile(filePath);
        }
        catch (RuntimeException e2) {
            OLogger.printStackTrace(e2);
            buff = new StringBuffer("Exception while trying to read \"" + filePath + "\"");
            buff.append("\n");
            OLogger.printlnOnLog(OLogger.INFO, buff.toString());
            OLogger.warn(OLogger.getString("OUI-67283", new Object[]{patchID}));
            return;
        }
        fileContents = fileContents.replaceAll("/>", ">");
        StringTokenizer strTok = new StringTokenizer(fileContents, "<>");
        String sqlScriptTag = "";
        String defaultValue = "defaultValue";
        sqlScriptTag = isApply ? "sql_script" : "sql_rollback_script";
        Pattern p1 = Pattern.compile(".*=\\s*[\"|']" + sqlScriptTag + "[\"|'].*" + defaultValue + "\\s*=\\s*[\"|'].+\\.sql[\"|'].*");
        Pattern p2 = Pattern.compile(".*" + defaultValue + "\\s*=\\s*[\"|'].+\\.sql[\"|'].*=\\s*[\"|']" + sqlScriptTag + "[\"|'].*");
        Matcher m1 = null;
        Matcher m2 = null;
        String matchedStr = "";
        while (strTok.hasMoreElements()) {
            matchedStr = (String)strTok.nextElement();
            m1 = p1.matcher(matchedStr);
            m2 = p2.matcher(matchedStr);
            if (m1.matches() || m2.matches()) break;
            matchedStr = "";
        }
        if (matchedStr == null || matchedStr.equals("")) {
            buff = new StringBuffer("There is no matched xml attribute in the 'patchmd.xml' file ");
            buff.append("to get the sql to run for apply/rollback");
            OLogger.printlnOnLog(OLogger.INFO, buff.toString());
            OLogger.warn("OUI-67284", new Object[]{patchID});
            return;
        }
        String[] partStr = matchedStr.split("[=|\\s+]+");
        String sqlName = "";
        for (int i2 = 0; i2 < partStr.length; ++i2) {
            String indivPart = partStr[i2];
            if (!(indivPart = indivPart.trim()).equals(defaultValue)) continue;
            sqlName = partStr[i2 + 1];
        }
        Pattern p3 = Pattern.compile("[\"|']+");
        String[] correctFinalSql = p3.split(sqlName);
        StringBuffer myBuff = new StringBuffer();
        for (int i3 = 0; i3 < correctFinalSql.length; ++i3) {
            myBuff.append(correctFinalSql[i3]);
        }
        sqlName = myBuff.toString();
        if (sqlName != null && !sqlName.equals("")) {
            if (isApply) {
                this.applySqlFileName = sqlName;
            } else {
                this.rollbackSqlFileName = sqlName;
            }
        }
        buff = new StringBuffer("Sql name extracted from 'patchmd.xml' file is " + sqlName);
        OLogger.printlnOnLog(OLogger.INFO, buff.toString());
    }

    private String getSqlPath(ListIterator copy, String patchLocation, boolean apply, String oracleHomePath, String patchID) {
        StringBuffer buff = new StringBuffer("PatchmdXml::getSqlPath()");
        OLogger.debug(buff);
        StringBuffer filePath = new StringBuffer();
        String absolutePath = "";
        String copyName = "";
        String storedFileName = "";
        String mode = "";
        if (apply) {
            storedFileName = this.applySqlFileName;
            mode = "apply";
        } else {
            storedFileName = this.rollbackSqlFileName;
            mode = "rollback";
        }
        boolean foundCopyAction = false;
        while (copy != null && copy.hasNext()) {
            CopyAction ca;
            PatchAction pa = (PatchAction)copy.next();
            if (!(pa instanceof CopyAction) || !storedFileName.equals(copyName = (ca = (CopyAction)pa).getCopyName())) continue;
            absolutePath = apply ? ca.getParentFilePath(oracleHomePath) : ca.getSourceFile(patchLocation);
            foundCopyAction = true;
            break;
        }
        if (!foundCopyAction) {
            OLogger.warn("OUI-67282", new Object[]{patchID, mode});
        }
        buff = new StringBuffer("The complete sql file path with reference to 'patchmd.xml' file is ");
        buff.append(absolutePath);
        OLogger.printlnOnLog(OLogger.INFO, buff.toString());
        return absolutePath;
    }
}

