/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchactions;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.opatch.ConflictDetectable;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.ConflictHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class oarAction
extends PatchAction
implements ConflictDetectable {
    String pathOfOAR;
    String application;
    String version;
    String patchFilesLocation;
    boolean compatible;
    static final String EXCLUDE_FILES_XML = "exclude_files.xml";
    static final String XML_CONST_FILE = "file";
    static final String XML_CONST_NAME = "name";

    public oarAction(PatchComponent pc, ArrayList argNames, ArrayList argValues, Integer lineNumber) throws NullPointerException, Exception, RuntimeException {
        super(pc, lineNumber);
        String filePath = null;
        String appName = null;
        String appVersion = null;
        String compatibleStr = null;
        if (argNames.size() != argValues.size()) {
            throw new RuntimeException("Unknown arguments passed for oarAction");
        }
        for (int i2 = 0; i2 < argNames.size(); ++i2) {
            String arg = (String)argNames.get(i2);
            String val = (String)argValues.get(i2);
            if (arg.equals(XML_CONST_FILE)) {
                filePath = val;
                continue;
            }
            if (arg.equals("application")) {
                appName = val;
                continue;
            }
            if (arg.equals("version")) {
                appVersion = val;
                continue;
            }
            if (arg.equals("compatible")) {
                compatibleStr = val;
                continue;
            }
            if (!arg.equals("PATCH_FILES_LOCATION_TAG")) continue;
            this.patchFilesLocation = val;
        }
        if (filePath == null || appName == null || appVersion == null || compatibleStr == null) {
            String errMsg = "The OAR file name value is null";
            if (appName == null) {
                errMsg = errMsg + "The OAR application name is null";
            }
            if (appVersion == null) {
                errMsg = errMsg + "The OAR application version is null";
            }
            if (compatibleStr == null) {
                errMsg = errMsg + "The OAR Compatibility flag is null";
            }
            NullPointerException ne = new NullPointerException(errMsg);
            throw ne;
        }
        this.pathOfOAR = PatchObjectUtil.getPlatformDependentPath(filePath);
        this.application = appName;
        this.version = appVersion;
        this.compatible = compatibleStr.equals("true");
    }

    public String getChildPath() {
        return "";
    }

    public String getParentFilePath(String oracleHomePath) {
        return "";
    }

    public String getActionName() {
        return "oarAction";
    }

    public String getActionDesc() {
        return "Deploy an OAR or sparse OAR to MAS.";
    }

    public boolean isNewFile(String oracleHomePath, String cookedPatchID, boolean beforeApply) {
        return true;
    }

    public String getPathOfOAR() {
        return this.pathOfOAR;
    }

    public String getApplication() {
        return this.application;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isCompatible() {
        return this.compatible;
    }

    public boolean conflictDetectable(String oracleHomePath) {
        StringBuffer buff = new StringBuffer("oarAction::conflictDetectable()  ");
        boolean tmpB = false;
        if (!(this.pathOfOAR == null || this.pathOfOAR.equals("") || this.application == null || this.application.equals("") || this.version == null || this.version.equals(""))) {
            tmpB = true;
        }
        buff.append(tmpB);
        OLogger.debug(buff);
        return tmpB;
    }

    public String[] filesTouched(String oracleHomePath) throws RuntimeException {
        try {
            String[] excludedFiles = this.getExcludedFiles();
            ArrayList<String> filesTouched = new ArrayList<String>();
            String fullPathOfOAR = this.patchFilesLocation + File.separator + this.pathOfOAR;
            ZipFile zf = new ZipFile(fullPathOfOAR);
            Enumeration<? extends ZipEntry> zipEntries = zf.entries();
            while (zipEntries.hasMoreElements()) {
                ZipEntry ze = zipEntries.nextElement();
                if (ze.isDirectory()) continue;
                String fileName = ze.getName();
                boolean filter = false;
                for (int i2 = 0; i2 < excludedFiles.length; ++i2) {
                    if (fileName.indexOf(excludedFiles[i2]) == -1) continue;
                    filter = true;
                    break;
                }
                if (filter) continue;
                filesTouched.add(fileName);
            }
            zf.close();
            String[] filesTouchedArray = new String[filesTouched.size()];
            filesTouched.toArray(filesTouchedArray);
            return filesTouchedArray;
        }
        catch (Exception e2) {
            OLogger.debug(new StringBuffer("oarAction::getFilesTouched() returns exception"));
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
    }

    public String checkConflict(String oracleHomePath, OneOffEntry[] oneoffs) throws RuntimeException {
        String[] filesPath = this.filesTouched(oracleHomePath);
        if (ConflictHandler.isFileConflict(oracleHomePath, oneoffs, filesPath)) {
            StringBuffer buff = new StringBuffer();
            for (int fileIter = 0; fileIter < filesPath.length; ++fileIter) {
                buff.append(filesPath[fileIter]);
                if (fileIter + 1 == filesPath.length) continue;
                buff.append(",");
            }
            return buff.toString();
        }
        return "";
    }

    private String[] getExcludedFiles() throws RuntimeException {
        ArrayList<String> excludedList = new ArrayList<String>();
        try {
            InputStream is = this.getClass().getResourceAsStream(EXCLUDE_FILES_XML);
            StringBuffer buff = new StringBuffer();
            if (is == null) {
                buff = new StringBuffer("Cannot load file \"");
                buff.append(EXCLUDE_FILES_XML);
                buff.append("\".");
                throw new Exception(buff.toString());
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(is);
            Element root = doc.getDocumentElement();
            NodeList fileElements = root.getElementsByTagName(XML_CONST_FILE);
            for (int i2 = 0; i2 < fileElements.getLength(); ++i2) {
                Element fileElement = (Element)fileElements.item(i2);
                String fileName = fileElement.getAttribute(XML_CONST_NAME);
                excludedList.add(fileName);
            }
            String[] fileNames = new String[excludedList.size()];
            excludedList.toArray(fileNames);
            return fileNames;
        }
        catch (Exception e2) {
            OLogger.debug(new StringBuffer("oarAction::getExcludedFiles() returns exception"));
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
    }
}

