/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import java.io.File;
import java.util.Properties;
import oracle.as.biapps.patch.framework.opatch.OpatchEntryPoint;
import oracle.opatch.opatchfafmw.BIP;
import oracle.opatch.opatchfafmw.FMWContext;
import oracle.opatch.opatchfafmw.Logger;
import oracle.opatch.opatchfafmw.Operation;

final class UndeployBIP
implements Operation {
    UndeployBIP() {
    }

    public void run(FMWContext c2) {
        Properties p2;
        boolean isError = false;
        String oh = c2.getOracleHome();
        String patchLoc = c2.getPatchLocation();
        String patchID = c2.getPatchID();
        String[] copyListRelativeToOracleHome = new String[c2.getBIP().size()];
        String biHome = "";
        Logger.logi("[BIP] BIP UnDeploy List: ");
        int count = 0;
        for (BIP bi : c2.getBIP()) {
            copyListRelativeToOracleHome[count] = bi.getRelativePath();
            biHome = bi.getBIHome();
            Logger.logi(bi.toString());
            ++count;
        }
        for (int i2 = 0; i2 < count; ++i2) {
            Logger.logi("Copy path relative to OH: " + copyListRelativeToOracleHome[i2]);
        }
        if (Logger.debug) {
            Logger.debug("[BIP] Oracle home : " + oh);
            Logger.debug("[BIP] Patch archive root : " + patchLoc);
            Logger.debug("[BIP] Patch ID : " + patchID);
        }
        if ((p2 = c2.getInterviewProperties()) == null) {
            Logger.logi("[BIP] Since property object is null, there are no interview elements defined in automation.xml");
        }
        File oracleHome = new File(oh);
        File explodedPatchArchiveRoot = new File(patchLoc);
        try {
            OpatchEntryPoint.undeploy((File)oracleHome, (File)explodedPatchArchiveRoot, (String[])copyListRelativeToOracleHome, (String)patchID, (Properties)p2);
        }
        catch (Exception e2) {
            Logger.logi("[BIP UNDEPLOY ERROR] " + e2.getMessage());
            Logger.loge(e2);
            isError = true;
        }
    }
}

