/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchutil;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import oracle.glcm.opatch.common.api.Patch;
import oracle.glcm.opatch.common.api.PatchSubType;
import oracle.opatch.CompositePatchObject;
import oracle.opatch.InitReadMeAction;
import oracle.opatch.InitScriptAction;
import oracle.opatch.MergedPatchObject;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.PatchValidationException;
import oracle.opatch.PatchingModel;
import oracle.opatch.PostReadMeAction;
import oracle.opatch.PostScriptAction;
import oracle.opatch.PreReadMeAction;
import oracle.opatch.PreScriptAction;
import oracle.opatch.PrereqSession;
import oracle.opatch.Rac;
import oracle.opatch.RacProcessor;
import oracle.opatch.Rules;
import oracle.opatch.SymbolFailureException;
import oracle.opatch.conflicttextualinterpreter.selectbetterpatch.IndexPair;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.ipm.IPMUtil;
import oracle.opatch.ipm.InstalledComponent;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.PQSession;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchutil.CommonAPIUtil;
import oracle.opatch.opatchutil.OUSession;
import oracle.opatch.opatchutil.RacFileMerger;

public class OPatchUtilHelper {
    private static OneOffEntry[] autoRollbackOneOffs = new OneOffEntry[0];
    private static OneOffEntry[] autoRollbackOneOffsToCleanUp = new OneOffEntry[0];
    private static OneOffEntry[] nrollbackOneOffs = new OneOffEntry[0];
    private static OneOffEntry[] cachedApplyOneOffs = new OneOffEntry[0];
    private static boolean readAutoRollbackList = false;

    public static void destroyObject() {
        autoRollbackOneOffs = new OneOffEntry[0];
        autoRollbackOneOffsToCleanUp = new OneOffEntry[0];
        nrollbackOneOffs = new OneOffEntry[0];
        cachedApplyOneOffs = new OneOffEntry[0];
        readAutoRollbackList = false;
    }

    private OPatchUtilHelper() {
    }

    public static void validateRunSqlOption(String oracleHomePath, PatchObject[] patchObjects, String sessionType) throws RuntimeException {
        StringBuffer buff = new StringBuffer("OPatchUtilHelper::validateRunSqlOption()");
        OLogger.debug(buff);
        boolean isRunSqlError = false;
        boolean isWarnError = false;
        StringBuffer patchNo = new StringBuffer("");
        if (!OPatchEnv.isRunSql()) {
            for (int i2 = 0; i2 < patchObjects.length; ++i2) {
                boolean propSqlValue;
                PatchObject rbPo = patchObjects[i2];
                if (rbPo == null) {
                    throw new RuntimeException("PatchObject is null");
                }
                Properties p2 = OPatchSessionHelper.getSqlPropertyFromFile(oracleHomePath, rbPo.getCookedPatchID());
                if (p2 == null || !(propSqlValue = Boolean.valueOf(p2.getProperty("RUNSQL")).booleanValue())) continue;
                boolean shouldErrorOut = Rules.shouldTryToErrorOutOnRunSql();
                if (shouldErrorOut) {
                    patchNo.append(rbPo.getPatchID());
                    patchNo.append(" ");
                    isRunSqlError = true;
                    continue;
                }
                isWarnError = true;
            }
        }
        if (isRunSqlError) {
            String errorMsg = OLogger.getString("OUI-67267", new Object[]{patchNo.toString(), sessionType});
            throw new RuntimeException(errorMsg);
        }
        if (isWarnError) {
            OLogger.warn("OUI-67268", new Object[]{patchNo.toString(), sessionType});
        }
    }

    public static void createAndUpdatePatchList(String oracleHomePath, String cookedPatchID, PatchObject po, String sessionName) throws IOException {
        String loc = OPatchUtilHelper.getUtilSessionPatchStorageLocation(oracleHomePath, cookedPatchID);
        StringBuffer fileName = new StringBuffer(loc);
        fileName.append(File.separator);
        fileName.append("patchlist.txt");
        StringBuffer buff = new StringBuffer("createAndUpdatePatchList() on \"");
        buff.append(fileName.toString());
        buff.append("\"");
        OLogger.debug(buff);
        FileWriter fw = null;
        BufferedWriter bw = null;
        File file = new File(fileName.toString());
        if (!file.exists()) {
            boolean ok = file.createNewFile();
            if (!ok || !file.exists()) {
                buff = new StringBuffer("Can't create file to hold list of patches: \"");
                buff.append(fileName.toString());
                buff.append("\"");
                OLogger.debug(buff);
                IOException e2 = new IOException(buff.toString());
                throw e2;
            }
            fw = new FileWriter(file);
            bw = new BufferedWriter(fw);
            StringBuffer line = new StringBuffer("User invokes OPatch via \"");
            line.append(sessionName);
            line.append("\" to process the following patches:\n");
            bw.write(line.toString());
        }
        if (bw == null) {
            fw = new FileWriter(file, true);
            bw = new BufferedWriter(fw);
        }
        try {
            StringBuffer line = new StringBuffer("\nPatch ID: ");
            line.append(po.getPatchID());
            line.append("\n");
            bw.write(line.toString());
            line = new StringBuffer("Patch Location: \"");
            line.append(po.getPatchLocation());
            line.append("\"\n");
            bw.write(line.toString());
            String logLoc = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, po.getCookedPatchID());
            line = new StringBuffer("Patch storage area: \"");
            line.append(logLoc);
            line.append("\"\n");
            bw.write(line.toString());
            Object var13_16 = null;
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            bw.close();
            fw.close();
            throw throwable;
        }
        bw.close();
        fw.close();
    }

    public static String getRestoreLoc(String oracleHomePath, String cookedPatchID) {
        String loc = OPatchUtilHelper.getUtilSessionPatchStorageLocation(oracleHomePath, cookedPatchID);
        StringBuffer restore = new StringBuffer(loc);
        restore.append(File.separator);
        if (OPatchEnv.isWindows()) {
            restore.append("restore.bat");
        } else {
            restore.append("restore.sh");
        }
        return restore.toString();
    }

    private static String getMakeTxtLoc(String oracleHomePath, String cookedPatchID) {
        String loc = OPatchUtilHelper.getUtilSessionPatchStorageLocation(oracleHomePath, cookedPatchID);
        StringBuffer makeLoc = new StringBuffer(loc);
        makeLoc.append(File.separator);
        makeLoc.append("make.txt");
        return makeLoc.toString();
    }

    public static String getBackupLoc(String oracleHomePath, String cookedPatchID) {
        String loc = OPatchUtilHelper.getUtilSessionPatchStorageLocation(oracleHomePath, cookedPatchID);
        StringBuffer backupLoc = new StringBuffer(loc);
        backupLoc.append(File.separator);
        backupLoc.append("backup");
        return backupLoc.toString();
    }

    public static void createUtilSessionPatchStorageLocation(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        String restore;
        String loc = OPatchUtilHelper.getUtilSessionPatchStorageLocation(oracleHomePath, cookedPatchID);
        StringBuffer buff = new StringBuffer("Try to mkdir on \"");
        buff.append(loc);
        buff.append("\"");
        OLogger.debug(buff);
        File f2 = new File(loc);
        if (!f2.exists()) {
            boolean ok = false;
            buff = new StringBuffer("File not exit.  Create new file.");
            OLogger.debug(buff);
            ok = f2.mkdirs();
            if (!ok || !f2.exists()) {
                buff = new StringBuffer("File didn't get created or error code returned.");
                OLogger.debug(buff);
                buff = new StringBuffer("Can't create patch_storage loc. for ");
                buff.append(cookedPatchID);
                buff.append(" using \"");
                buff.append(loc);
                buff.append("\".");
                throw new RuntimeException(buff.toString());
            }
        }
        if (!OPatchEnv.isWindows()) {
            String makeLoc = OPatchUtilHelper.getMakeTxtLoc(oracleHomePath, cookedPatchID);
            f2 = new File(makeLoc);
            if (f2.exists()) {
                f2.delete();
            }
            try {
                f2.createNewFile();
            }
            catch (IOException e2) {
                buff = new StringBuffer("Can't create make file \"");
                buff.append(makeLoc);
                buff.append("\". : ");
                buff.append(e2.getMessage());
                RuntimeException re = new RuntimeException(buff.toString());
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
        }
        if ((f2 = new File(restore = OPatchUtilHelper.getRestoreLoc(oracleHomePath, cookedPatchID))).exists()) {
            f2.delete();
        }
        try {
            f2.createNewFile();
        }
        catch (IOException e3) {
            buff = new StringBuffer("Can't create restore file \"");
            buff.append(restore);
            buff.append("\". : ");
            buff.append(e3.getMessage());
            RuntimeException re = new RuntimeException(buff.toString());
            re.setStackTrace(e3.getStackTrace());
            throw re;
        }
        String backup = OPatchUtilHelper.getBackupLoc(oracleHomePath, cookedPatchID);
        f2 = new File(backup);
        if (f2.exists()) {
            f2.delete();
        }
        try {
            f2.mkdirs();
        }
        catch (Exception e4) {
            buff = new StringBuffer("Can't create backup direcotry \"");
            buff.append(backup);
            buff.append("\". : ");
            buff.append(e4.getMessage());
            RuntimeException re = new RuntimeException(buff.toString());
            re.setStackTrace(e4.getStackTrace());
            throw re;
        }
    }

    public static String getUtilSessionPatchStorageLocation(String oracleHomePath, String cookedPatchID) {
        String patchStorage = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath);
        StringBuffer buff = new StringBuffer(patchStorage);
        buff.append(File.separator);
        buff.append(cookedPatchID);
        return buff.toString();
    }

    public static void setupRLibBackupDir(String oracleHomePath, String cookedPatchID) {
        String patchBackupDir = OPatchUtilHelper.getUtilSessionPatchStorageLocation(oracleHomePath, cookedPatchID);
        StringBuilder sb = new StringBuilder(patchBackupDir);
        sb.append(File.separator);
        sb.append("library_backup");
        OPatchEnv.setRLibBackupDir(sb.toString());
    }

    public static void makeFailureAdvise(String sessionName, String psLoc) {
        StringBuffer buff = new StringBuffer("\n");
        buff.append("Oraclel binary re-links failed.  You can ");
        buff.append("either manually restore the ORACLE_HOME ");
        buff.append("or resolve issues and invoke re-links again using the file make.txt (Unix only)\n");
        buff.append("OPatch has not and won't restore your ORACLE_HOME.\n");
        buff.append("The make.txt is located under \n\"");
        buff.append(psLoc);
        buff.append("\"\n");
        OLogger.warn("OUI-67124", new Object[]{buff.toString()});
    }

    public static void restoreInstruction(String sessionName, String psLoc) {
        StringBuffer buff = new StringBuffer("\n");
        buff.append("To restore the ORACLE_HOME, do the following: \n");
        buff.append(" - run restore.[sh,bat]\n");
        buff.append(" - run make.txt (Unix only)\n");
        buff.append("These files are located under \n\"");
        buff.append(psLoc);
        buff.append("\"\n");
        OLogger.warn("OUI-67124", new Object[]{buff.toString()});
    }

    public static void warnRestoreMessage(String sessionName, String psLoc, boolean ok) {
        StringBuffer buff = new StringBuffer("\n" + sessionName);
        if (ok) {
            buff.append(" restored the home. Please check your ORACLE_HOME to make sure: \n");
            buff.append("  - files are restored properly.\n");
            buff.append("  - binaries are re-linked correctly.\n");
            buff.append("(use restore.[sh,bat] and make.txt (Unix only) as a reference. ");
            buff.append("They are located under \n\"");
            buff.append(psLoc);
            buff.append("\"\n");
        } else {
            buff.append(" was not able to restore the home.  Please invoke the following scripts:\n");
            buff.append("  - restore.[sh,bat]\n");
            buff.append("  - make.txt (Unix only)\n");
            buff.append("to restore the ORACLE_HOME.  They are located under \n\"");
            buff.append(psLoc);
            buff.append("\"\n");
        }
        OLogger.warn("OUI-67124", new Object[]{buff.toString()});
    }

    private static PatchObject loadPatchObject(String sessionName, String oracleHomePath, String patchID) throws RuntimeException {
        StringBuffer buff = new StringBuffer("OPatchUtilHelper::loadPatchObject()");
        OLogger.debug(buff);
        PatchObject patchObject = null;
        String patchLoc = "";
        try {
            buff = new StringBuffer(" loading patch from ");
            patchLoc = OPatchEnv.getPatchFilemapInfoLoc(oracleHomePath, patchID);
            buff.append(patchLoc);
            OLogger.debug(buff);
            patchObject = PatchObjectUtil.loadPatch(oracleHomePath, patchID);
            buff = new StringBuffer(" PatchObject::disableMakeAction()");
            OLogger.debug(buff);
            patchObject.disableMakeAction();
            buff = new StringBuffer(" PatchObject::disablePromptForShutdown()");
            OLogger.debug(buff);
            patchObject.disablePromptForShutdown();
            buff = new StringBuffer(" PatchObject::disablePromptForStartup()");
            OLogger.debug(buff);
            patchObject.disablePromptForStartup();
            buff = new StringBuffer(" PatchObject::disableRestoreFileCreation()");
            OLogger.debug(buff);
            patchObject.disableRestoreFileCreation();
            return patchObject;
        }
        catch (Throwable t) {
            OLogger.error("OUI-67100", new Object[]{sessionName, patchLoc});
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
    }

    private static PatchObject loadPatchObject(String sessionName, String patchLoc) throws RuntimeException {
        StringBuffer buff = new StringBuffer("OPatchUtilHelper::loadPatchObject()");
        OLogger.debug(buff);
        PatchObject patchObject = null;
        try {
            buff = new StringBuffer(" loading patch from ");
            buff.append(patchLoc);
            OLogger.debug(buff);
            patchObject = PatchObjectUtil.loadPatch(patchLoc);
            buff = new StringBuffer(" PatchObject::disablePromptForShutdown()");
            OLogger.debug(buff);
            patchObject.disablePromptForShutdown();
            buff = new StringBuffer(" PatchObject::disablePromptForStartup()");
            OLogger.debug(buff);
            patchObject.disablePromptForStartup();
            buff = new StringBuffer(" PatchObject::disableRestoreFileCreation()");
            OLogger.debug(buff);
            patchObject.disableRestoreFileCreation();
            return patchObject;
        }
        catch (Throwable t) {
            if (t instanceof SymbolFailureException) {
                throw (SymbolFailureException)t;
            }
            if (t instanceof PatchValidationException) {
                throw (PatchValidationException)t;
            }
            OLogger.error("OUI-67100", new Object[]{sessionName, patchLoc});
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
    }

    protected static void processPrereqNotExecuted(Vector detail) throws RuntimeException {
        int i2;
        StringBuffer buff = new StringBuffer("OPatchUtilHelper::processPrereqNotExecuted()");
        OLogger.debug(buff);
        if (detail == null && detail.size() == 0) {
            buff = new StringBuffer("Pre-req. API not executed but no detail is available.");
            OLogger.log(OLogger.SEVERE, buff.toString());
            throw new RuntimeException(buff.toString());
        }
        ArrayList<String> list = new ArrayList<String>();
        for (i2 = 0; i2 < detail.size(); ++i2) {
            Object obj = detail.get(i2);
            if (obj instanceof Exception) {
                Exception e2 = (Exception)obj;
                buff = new StringBuffer("An exception occured when calling Pre-req. API. Detail: ");
                buff.append(e2.getMessage());
                OLogger.log(OLogger.SEVERE, buff.toString());
                RuntimeException re = new RuntimeException(e2.getMessage());
                re.setStackTrace(e2.getStackTrace());
                throw re;
            }
            if (!(obj instanceof String)) continue;
            String s = (String)obj;
            list.add(s);
        }
        buff = new StringBuffer("Pre-req. API didn't execute.  Detail: ");
        for (i2 = 0; i2 < list.size(); ++i2) {
            String s = (String)list.get(i2);
            buff.append(s);
            buff.append(", ");
        }
        OLogger.log(OLogger.SEVERE, buff.toString());
        throw new RuntimeException(buff.toString());
    }

    public static String[] getPatchesToRollback() throws RuntimeException {
        String[] list = new String[]{};
        list = OPatchEnv.getUserSuppliedPatchIDs();
        if (list == null || list.length == 0) {
            String patchID = OPatchEnv.getRollbackPatchid();
            if (patchID == null || patchID.equals("")) {
                throw new RuntimeException("Can't get the patch ID.");
            }
            list = new String[]{patchID};
        }
        return list;
    }

    protected static PatchObject[] getPatchesToRollbackSql(String oracleHomePath) throws Exception, FileNotFoundException, IOException {
        try {
            return OPatchUtilHelper.getPatchesToApply(oracleHomePath, null, "");
        }
        catch (FileNotFoundException e2) {
            throw e2;
        }
        catch (IOException e3) {
            throw e3;
        }
        catch (Exception e4) {
            throw e4;
        }
    }

    protected static void checkHasSystemPatch(String[] patchLocs) {
        if (patchLocs != null && patchLocs.length != 0) {
            boolean isEsysPatch = false;
            for (String patchLoc : patchLocs) {
                if (!OPatchSessionHelper.checkIsEsysPatch(patchLoc)) continue;
                isEsysPatch = true;
                break;
            }
            if (isEsysPatch) {
                OPatchEnv.setOpatchExitCode(21);
                throw new RuntimeException(OLogger.getString("OUI-68011") + "  Please use opatchauto.");
            }
        }
    }

    public static PatchObject[] getPatchesToApply(String oracleHomePath, OneOffEntry[] oneOffs, String sessionName) throws Exception, FileNotFoundException, IOException {
        String patchLoc;
        String[] patchLocs;
        PatchObject[] pObjs = new PatchObject[]{};
        if (oneOffs == null) {
            if (OUSession.isPatchBaseDirProvided() || OUSession.isPatchBaseFileProvided()) {
                patchLocs = null;
                patchLocs = OUSession.parseBaseDirListFile();
                OPatchUtilHelper.checkHasSystemPatch(patchLocs);
                OPatchUtilHelper.validatePatchSubType(patchLocs);
                ArrayList<PatchObject> pObjsList = new ArrayList<PatchObject>();
                ArrayList<IndexPair> filteredSet = new ArrayList<IndexPair>();
                ArrayList<String> compositeList = new ArrayList<String>();
                for (int i2 = 0; i2 < patchLocs.length; ++i2) {
                    if (PQSession.isComposite(patchLocs[i2])) {
                        int k2;
                        compositeList.add(patchLocs[i2]);
                        String compositeXMLLoc = CompositePatchObject.getCompositeFilePath(patchLocs[i2]);
                        String[] subPatchIDs = CompositePatchObject.getConstituentList(compositeXMLLoc);
                        String[] subPatches = new File(patchLocs[i2]).list();
                        HashMap<String, PatchObject> allSubPatches = new HashMap<String, PatchObject>();
                        for (k2 = 0; k2 < subPatchIDs.length; ++k2) {
                            String subPatchLoc = patchLocs[i2] + File.separator + subPatchIDs[k2];
                            PatchObject pObject = OPatchUtilHelper.loadAndInitPatchObject(sessionName, subPatchLoc);
                            allSubPatches.put(pObject.getPatchID(), pObject);
                        }
                        for (k2 = 0; k2 < subPatchIDs.length; ++k2) {
                            PatchObject correctSubPatch = (PatchObject)allSubPatches.get(subPatchIDs[k2]);
                            if (correctSubPatch == null) {
                                String errorMsg = OLogger.getString("S_OPATCH_GET_COMPOSITE_ERROR", new Object[]{patchLocs[i2]});
                                RuntimeException e2 = new RuntimeException(errorMsg);
                                throw e2;
                            }
                            pObjsList.add(correctSubPatch);
                        }
                        continue;
                    }
                    PatchObject pObject = OPatchUtilHelper.loadAndInitPatchObject(sessionName, patchLocs[i2]);
                    IndexPair id_UPI = new IndexPair(pObject.getPatchID(), pObject.getPatchUniqID());
                    if (filteredSet.contains(id_UPI)) continue;
                    pObjsList.add(pObject);
                    filteredSet.add(id_UPI);
                }
                if (compositeList.size() > 1) {
                    String compositeString = "";
                    for (int j2 = 0; j2 < compositeList.size(); ++j2) {
                        compositeString = compositeString + "\n" + compositeList.get(j2);
                    }
                    String errorMsg = OLogger.getString("OUI-67951", new Object[]{compositeString});
                    throw new RuntimeException(errorMsg);
                }
                pObjs = new PatchObject[pObjsList.size()];
                pObjsList.toArray(pObjs);
            }
            patchLoc = OPatchEnv.getPatchloc();
            if (patchLoc != null && !patchLoc.equals("")) {
                if (OPatchSessionHelper.checkIsEsysPatch(patchLoc)) {
                    OLogger.println(OLogger.getString("OUI-68011") + "  Please use opatchauto.");
                    OPatchEnv.setOpatchExitCode(21);
                    throw new RuntimeException(OLogger.getString("OUI-68011") + "  Please use opatchauto.");
                }
                pObjs = new PatchObject[]{OPatchUtilHelper.loadAndInitPatchObject(sessionName, patchLoc)};
            }
        } else {
            if (OUSession.isPatchBaseDirProvided() || OUSession.isPatchBaseFileProvided()) {
                PatchObject pObj;
                int i3;
                patchLocs = null;
                patchLocs = OUSession.parseBaseDirListFile();
                OPatchUtilHelper.checkHasSystemPatch(patchLocs);
                ArrayList<PatchObject> pList = new ArrayList<PatchObject>();
                ArrayList<PatchObject> pObjsList = new ArrayList<PatchObject>();
                ArrayList<IndexPair> filteredSet = new ArrayList<IndexPair>();
                ArrayList<String> compositeList = new ArrayList<String>();
                for (i3 = 0; i3 < patchLocs.length; ++i3) {
                    if (PQSession.isComposite(patchLocs[i3])) {
                        int k3;
                        compositeList.add(patchLocs[i3]);
                        String compositeXMLLoc = CompositePatchObject.getCompositeFilePath(patchLocs[i3]);
                        String[] subPatchIDs = CompositePatchObject.getConstituentList(compositeXMLLoc);
                        String[] subPatches = new File(patchLocs[i3]).list();
                        HashMap<String, PatchObject> allSubPatches = new HashMap<String, PatchObject>();
                        for (k3 = 0; k3 < subPatchIDs.length; ++k3) {
                            String subPatchLoc = patchLocs[i3] + File.separator + subPatchIDs[k3];
                            PatchObject pObject = OPatchUtilHelper.loadAndInitPatchObject(sessionName, subPatchLoc);
                            allSubPatches.put(pObject.getPatchID(), pObject);
                        }
                        for (k3 = 0; k3 < subPatchIDs.length; ++k3) {
                            PatchObject correctSubPatch = (PatchObject)allSubPatches.get(subPatchIDs[k3]);
                            if (correctSubPatch == null) {
                                String errorMsg = OLogger.getString("S_OPATCH_GET_COMPOSITE_ERROR", new Object[]{patchLocs[i3]});
                                RuntimeException e3 = new RuntimeException(errorMsg);
                                throw e3;
                            }
                            pObjsList.add(correctSubPatch);
                        }
                        continue;
                    }
                    pObj = OPatchUtilHelper.loadAndInitPatchObject(sessionName, patchLocs[i3]);
                    IndexPair id_UPI = new IndexPair(pObj.getPatchID(), pObj.getPatchUniqID());
                    if (filteredSet.contains(id_UPI)) continue;
                    pObjsList.add(pObj);
                    filteredSet.add(id_UPI);
                }
                if (compositeList.size() > 1) {
                    String compositeString = "";
                    for (int j3 = 0; j3 < compositeList.size(); ++j3) {
                        compositeString = compositeString + "\n" + compositeList.get(j3);
                    }
                    String errorMsg = OLogger.getString("OUI-67951", new Object[]{compositeString});
                    throw new RuntimeException(errorMsg);
                }
                for (i3 = 0; i3 < pObjsList.size(); ++i3) {
                    PatchObject errorMsg = (PatchObject)pObjsList.get(i3);
                }
                block17: for (i3 = 0; i3 < pObjsList.size(); ++i3) {
                    pObj = (PatchObject)pObjsList.get(i3);
                    for (int j4 = 0; j4 < oneOffs.length; ++j4) {
                        if (!pObj.getPatchUniqID().equals(oneOffs[j4].getPSENumber()) || !pObj.getPatchID().equals(oneOffs[j4].getID())) continue;
                        pList.add(pObj);
                        continue block17;
                    }
                }
                if (pList.size() != oneOffs.length) {
                    RuntimeException re = new RuntimeException("Unable to get the PatchObjects to the given oneOffs.");
                    throw re;
                }
                pObjs = new PatchObject[oneOffs.length];
                pList.toArray(pObjs);
            }
            patchLoc = OPatchEnv.getPatchloc();
            if (patchLoc != null && !patchLoc.equals("")) {
                if (OPatchSessionHelper.checkIsEsysPatch(patchLoc)) {
                    OLogger.println(OLogger.getString("OUI-68011") + "  Please use opatchauto.");
                    OPatchEnv.setOpatchExitCode(21);
                    throw new RuntimeException(OLogger.getString("OUI-68011") + "  Please use opatchauto.");
                }
                pObjs = new PatchObject[]{OPatchUtilHelper.loadAndInitPatchObject(sessionName, patchLoc)};
            }
        }
        int modelCode = PatchingModel.returnModelCode(oracleHomePath);
        if (modelCode == 2 && !OPatchEnv.isUserSuppliedPatchIDs()) {
            pObjs = OPatchSessionHelper.sortForApplySnowballs(pObjs);
        }
        return pObjs;
    }

    public static PatchObject loadAndInitPatchObject(String sessionName, String oracleHomePath, String patchID) {
        StringBuffer buff = new StringBuffer("OPatchUtilHelper::loadAndInitPatchObject()");
        OLogger.debug(buff);
        PatchObject patchObject = null;
        try {
            patchObject = OPatchUtilHelper.loadPatchObject(sessionName, oracleHomePath, patchID);
            String patchLoc = patchObject.getPatchLocation();
            String preReadMeLoc = PatchObject.getPreReadMeFilePath(patchLoc);
            String initReadMeLoc = PatchObject.getInitReadMeFilePath(patchLoc);
            String postReadMeLoc = PatchObject.getPostReadMeFilePath(patchLoc);
            String preScriptLoc = PatchObject.getPreScriptFilePath(patchLoc);
            String initScriptLoc = PatchObject.getInitScriptFilePath(patchLoc);
            String postScriptLoc = PatchObject.getPostScriptFilePath(patchLoc);
            PreReadMeAction preRead = new PreReadMeAction(preReadMeLoc);
            PreScriptAction preScript = new PreScriptAction(preScriptLoc);
            PostReadMeAction postRead = new PostReadMeAction(postReadMeLoc);
            PostScriptAction postScript = new PostScriptAction(postScriptLoc);
            InitReadMeAction initRead = new InitReadMeAction(initReadMeLoc);
            InitScriptAction initScript = new InitScriptAction(initScriptLoc);
            OPatchACL.setPreReadMeAction(new OPatchUtilHelper(), preRead, patchObject);
            OPatchACL.setPreScriptAction(new OPatchUtilHelper(), preScript, patchObject);
            OPatchACL.setPostReadMeAction(new OPatchUtilHelper(), postRead, patchObject);
            OPatchACL.setPostScriptAction(new OPatchUtilHelper(), postScript, patchObject);
            OPatchACL.setInitReadMeAction(new OPatchUtilHelper(), initRead, patchObject);
            OPatchACL.setInitScriptAction(new OPatchUtilHelper(), initScript, patchObject);
        }
        catch (RuntimeException e2) {
            buff = new StringBuffer("OPatchUtilHelper::loadAndInitPatchObject cannot load PatchObject: ");
            buff.append(e2.getMessage());
            OLogger.debug(buff);
            throw e2;
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return patchObject;
    }

    public static PatchObject loadAndInitPatchObject(String sessionName, String patchLocation) {
        StringBuffer buff = new StringBuffer("OPatchUtilHelper::loadAndInitPatchObject()");
        OLogger.debug(buff);
        PatchObject patchObject = null;
        try {
            patchObject = OPatchUtilHelper.loadPatchObject(sessionName, patchLocation);
            String patchLoc = patchObject.getPatchLocation();
            String preReadMeLoc = PatchObject.getPreReadMeFilePath(patchLoc);
            String initReadMeLoc = PatchObject.getInitReadMeFilePath(patchLoc);
            String postReadMeLoc = PatchObject.getPostReadMeFilePath(patchLoc);
            String preScriptLoc = PatchObject.getPreScriptFilePath(patchLoc);
            String initScriptLoc = PatchObject.getInitScriptFilePath(patchLoc);
            String postScriptLoc = PatchObject.getPostScriptFilePath(patchLoc);
            PreReadMeAction preRead = new PreReadMeAction(preReadMeLoc);
            PreScriptAction preScript = new PreScriptAction(preScriptLoc);
            PostReadMeAction postRead = new PostReadMeAction(postReadMeLoc);
            PostScriptAction postScript = new PostScriptAction(postScriptLoc);
            InitReadMeAction initRead = new InitReadMeAction(initReadMeLoc);
            InitScriptAction initScript = new InitScriptAction(initScriptLoc);
            OPatchACL.setPreReadMeAction(new OPatchUtilHelper(), preRead, patchObject);
            OPatchACL.setPreScriptAction(new OPatchUtilHelper(), preScript, patchObject);
            OPatchACL.setPostReadMeAction(new OPatchUtilHelper(), postRead, patchObject);
            OPatchACL.setPostScriptAction(new OPatchUtilHelper(), postScript, patchObject);
            OPatchACL.setInitReadMeAction(new OPatchUtilHelper(), initRead, patchObject);
            OPatchACL.setInitScriptAction(new OPatchUtilHelper(), initScript, patchObject);
        }
        catch (RuntimeException e2) {
            buff = new StringBuffer("OPatchUtilHelper::loadAndInitPatchObject cannot load PatchObject: ");
            buff.append(e2.getMessage());
            OLogger.debug(buff);
            throw e2;
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return patchObject;
    }

    public static OneOffEntry[] getPatchesToApply(String oracleHomePath, String sessionName) throws Exception, FileNotFoundException, IOException {
        PatchObject[] pObjs = OPatchUtilHelper.getPatchesToApply(oracleHomePath, null, sessionName);
        return OPatchUtilHelper.getOneOffObjects(oracleHomePath, pObjs);
    }

    public static OneOffEntry[] getOneOffObjects(String oracleHomePath, PatchObject[] pObjs) {
        OneOffEntry[] oneOffs = new OneOffEntry[pObjs.length];
        try {
            for (int i2 = 0; i2 < pObjs.length; ++i2) {
                oneOffs[i2] = pObjs[i2].toOneOffEntry(oracleHomePath);
                OneOffEntry installedOneOff = PrereqAPI.getInstalledOneOff(oracleHomePath, oneOffs[i2].getID());
                if (installedOneOff == null) continue;
                oneOffs[i2].setAppliedDate(installedOneOff.getAppliedDate());
            }
        }
        catch (Throwable t) {
            OLogger.printlnOnLogAndVerbose(t.getMessage());
            return null;
        }
        cachedApplyOneOffs = oneOffs;
        return oneOffs;
    }

    public static PatchObject[] getPatchesToRollback(String oracleHomePath, String[] patchIDs, String sessionName) throws RuntimeException, FileNotFoundException, IOException, Exception {
        StringBuffer buff = new StringBuffer("OPatchUtilHelper::getPatchObjects(String[] ids)");
        OLogger.debug(buff);
        if (patchIDs == null || patchIDs.length == 0) {
            buff = new StringBuffer("Can't construct list of PatchObject. ");
            buff.append("Given list of patch IDs is either Null or empty.");
            OLogger.debug(buff);
            RuntimeException e2 = new RuntimeException(buff.toString());
            throw e2;
        }
        PatchObject[] patchObjects = new PatchObject[patchIDs.length];
        for (int i2 = 0; i2 < patchIDs.length; ++i2) {
            String patchID = patchIDs[i2];
            if (patchID == null) {
                buff = new StringBuffer("Can't construct list of PatchObject. ");
                buff.append("One of the patch ID at position ");
                buff.append(i2);
                buff.append(" in the given list is Null.");
                OLogger.debug(buff);
                RuntimeException e3 = new RuntimeException(buff.toString());
                throw e3;
            }
            buff = new StringBuffer("Loading patch ID " + patchID);
            String patchLoc = OPatchEnv.getPatchFilemapInfoLoc(oracleHomePath, patchID);
            PatchObject po = OPatchUtilHelper.loadAndInitPatchObject(sessionName, oracleHomePath, patchID);
            buff.append("Loading the patch object from ");
            buff.append(patchLoc);
            OLogger.debug(buff);
            patchObjects[i2] = po;
        }
        return patchObjects;
    }

    public static RacProcessor.MinDowntimeNodeSelection promptForShutdown(String oracleHomePath, IIPMReadServices readServices, String sessionName, boolean rolling, boolean shutdown, String shutdownMsg) {
        Rac.RacType racType = Rac.getInstance(readServices);
        boolean local = OPatchEnv.isLocal();
        boolean minDowntime = OPatchEnv.isMinDowntime();
        boolean allNode = OPatchEnv.isAllNode();
        boolean silent = OPatchEnv.isSilent();
        String localNode = racType.getLocalNode();
        String[] remoteNodes = racType.getRemoteNodes();
        Rules.RacPatchOrder order = Rules.getRacPatchOrder(racType, local, rolling, minDowntime, allNode, silent);
        return RacProcessor.shutDownLogicsForProcessLocal(sessionName, oracleHomePath, racType, order, localNode, remoteNodes, shutdown, shutdownMsg);
    }

    public static void promptForStartup(String oracleHomePath, IIPMReadServices readServices) {
        Object selects = null;
        Rac.RacType racType = Rac.getInstance(readServices);
        boolean local = OPatchEnv.isLocal();
        boolean minDowntime = OPatchEnv.isMinDowntime();
        boolean allNode = OPatchEnv.isAllNode();
        boolean silent = OPatchEnv.isSilent();
        boolean rolling = false;
        boolean shutdown = true;
        String localNode = racType.getLocalNode();
        String[] remoteNodes = racType.getRemoteNodes();
        Rules.RacPatchOrder order = Rules.getRacPatchOrder(racType, local, rolling, minDowntime, allNode, silent);
        RacProcessor.startupLogicsForProcessLocal(racType, order, localNode, remoteNodes, shutdown);
    }

    public static MergedPatchObject componentPrereqCheck(IIPMReadServices readServices, MergedPatchObject mergedPatchObject) throws RuntimeException, IOException, UnsupportedOperationException {
        StringBuffer buff = new StringBuffer("OPatchUtilHelper::componentPrereqCheck()");
        OLogger.debug(buff);
        Object presentReqComponents = null;
        Object presentOptComponents = null;
        boolean compMissing = false;
        String oracleHomePath = readServices.getOracleHomePath();
        String msg = "";
        try {
            boolean patchCompatible = PatchObjectUtil.patchApplicableOnPlatform(oracleHomePath, readServices, mergedPatchObject);
            if (!patchCompatible) {
                if (Rules.shouldIgnoreErrorToContinue()) {
                    OLogger.warn("OUI-67020", new Object[]{mergedPatchObject.getPatchID(), oracleHomePath});
                } else {
                    msg = OLogger.error("OUI-67020", new Object[]{mergedPatchObject.getPatchID(), oracleHomePath});
                    throw new UnsupportedOperationException(msg);
                }
            }
            InstalledComponent[] installedComponents = readServices.getInstalledComponents();
            PatchComponent[] requiredComponents = mergedPatchObject.getRequiredPatchComponents();
            PatchComponent[] optionalComponents = mergedPatchObject.getOptionalPatchComponents();
            buff = new StringBuffer("ApplySession searches for required compoments.");
            OLogger.debug(buff);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mergedPatchObject;
    }

    public static String[] getPatchLocs(PatchObject[] pObjs) {
        if (pObjs != null) {
            String[] patchLocs = new String[pObjs.length];
            for (int i2 = 0; i2 < pObjs.length; ++i2) {
                patchLocs[i2] = pObjs[i2].getPatchLocation();
            }
            return patchLocs;
        }
        return null;
    }

    public static void setAutoRollbackOneOffs(OneOffEntry[] oneOffs) {
        autoRollbackOneOffs = oneOffs;
    }

    public static void setAutoRollbackOneOffs(PatchObject[] patches, String oracleHome) {
        int size = patches.length;
        if (size > 0) {
            autoRollbackOneOffs = new OneOffEntry[size];
            for (int i2 = 0; i2 < size; ++i2) {
                OPatchUtilHelper.autoRollbackOneOffs[i2] = patches[i2].toOneOffEntry(oracleHome);
            }
        }
    }

    public static void setNRollbackOneOffs(PatchObject[] patches, String oracleHome) {
        int size = patches.length;
        if (size > 0) {
            nrollbackOneOffs = new OneOffEntry[size];
            for (int i2 = 0; i2 < size; ++i2) {
                OPatchUtilHelper.nrollbackOneOffs[i2] = patches[i2].toOneOffEntry(oracleHome);
            }
        }
    }

    public static void setCachedApplyOneOffs(PatchObject[] patches, String oracleHome) {
        int size = patches.length;
        if (size > 0) {
            cachedApplyOneOffs = new OneOffEntry[size];
            for (int i2 = 0; i2 < size; ++i2) {
                OPatchUtilHelper.cachedApplyOneOffs[i2] = patches[i2].toOneOffEntry(oracleHome);
            }
        }
    }

    public static OneOffEntry[] getAutoRollbackOneOffs() {
        return autoRollbackOneOffs;
    }

    public static OneOffEntry[] getAutoRollbackOneOffsIfNotRead() {
        if (readAutoRollbackList) {
            autoRollbackOneOffs = new OneOffEntry[0];
            return null;
        }
        readAutoRollbackList = true;
        autoRollbackOneOffsToCleanUp = autoRollbackOneOffs;
        return autoRollbackOneOffs;
    }

    public static void resetSession() {
        readAutoRollbackList = false;
    }

    public static PatchObject[] getAutoRollbackPatchObjects(String oracleHomePath) {
        PatchObject[] patchObjects = new PatchObject[autoRollbackOneOffs.length];
        for (int i2 = 0; i2 < autoRollbackOneOffs.length; ++i2) {
            PatchObject po;
            String patchID = autoRollbackOneOffs[i2].getTripletID();
            patchObjects[i2] = po = OPatchUtilHelper.loadPatchObject("NApply", oracleHomePath, patchID);
        }
        return patchObjects;
    }

    public static boolean isAutoRollbackNeeded() {
        return autoRollbackOneOffs == null ? false : autoRollbackOneOffs.length != 0;
    }

    protected static void generateRacFiles(String oracleHomePath, PatchObject[] apPatchObjects, String cookedPatchID, String sessionName) throws IOException {
        StringBuffer buff = new StringBuffer("OPatchUtilHelper::generateRacFiles()");
        OLogger.debug(buff);
        RacFileMerger.createCopyDir(oracleHomePath, cookedPatchID, apPatchObjects);
        RacFileMerger.createCopyFile(oracleHomePath, cookedPatchID, apPatchObjects);
        RacFileMerger.createRemoveDir(oracleHomePath, cookedPatchID, apPatchObjects);
        RacFileMerger.createRemoveFile(oracleHomePath, cookedPatchID, apPatchObjects);
        RacFileMerger.createRemoteCommandFile(oracleHomePath, cookedPatchID, apPatchObjects);
        RacFileMerger.createMakeFile(oracleHomePath, cookedPatchID, apPatchObjects);
        RacFileMerger.createModeFile(oracleHomePath, cookedPatchID, sessionName);
    }

    protected static void cleanupBackupArea(String oracleHomePath, String dirToBeDeleted) {
        File dFile = new File(dirToBeDeleted);
        if (dFile.exists() && dFile.isDirectory()) {
            String backupDirPath = dFile.getAbsolutePath() + File.separator + "backup";
            File backupDirFile = new File(backupDirPath);
            String restoreFile = "";
            restoreFile = OPatchEnv.isWindows() ? "restore.bat" : "restore.sh";
            String restoreFilePath = dFile.getAbsolutePath() + File.separator + restoreFile;
            File restoreFileObj = new File(restoreFilePath);
            String makeFilePath = dFile.getAbsolutePath() + File.separator + "make.txt";
            File makeFileObj = new File(makeFilePath);
            String racDirPath = dFile.getAbsolutePath() + File.separator + "rac";
            File racDirObj = new File(racDirPath);
            String scratchDirPath = dFile.getAbsolutePath() + File.separator + "scratch";
            File scratchDirObj = new File(scratchDirPath);
            String rLibBackupPath = OPatchEnv.getRLibBackupDir();
            File rLibBackupObj = new File(rLibBackupPath);
            if (backupDirFile.exists()) {
                OPatchSessionHelper.deleteRecurse(backupDirPath);
            }
            if (racDirObj.exists()) {
                OPatchSessionHelper.deleteRecurse(racDirPath);
            }
            if (scratchDirObj.exists()) {
                OPatchSessionHelper.deleteRecurse(scratchDirPath);
            }
            if (restoreFileObj.exists()) {
                OPatchSessionHelper.deleteRecurse(restoreFilePath);
            }
            if (rLibBackupObj.exists()) {
                OPatchSessionHelper.deleteRecurse(rLibBackupPath);
            }
            if (OPatchEnv.isNolink()) {
                OLogger.println("Option -no_relink is specified, so OPatch will not clean up the make file.");
            }
            if (!OPatchEnv.isNolink() && makeFileObj.exists()) {
                OPatchSessionHelper.deleteRecurse(makeFilePath);
            }
        }
    }

    public static void cleanupPatchStorage(String oracleHomePath) {
        block11: {
            File patchStorageFile;
            int len;
            StringBuilder buff;
            HashMap<String, String> existedPatches;
            String utilOption;
            String sessionType;
            String patchStoragePath;
            block13: {
                int size;
                String cookedPatchId;
                block12: {
                    block10: {
                        String id;
                        IIPMReadServices readServices = null;
                        patchStoragePath = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath);
                        sessionType = OPatchEnv.getSessionType();
                        utilOption = OPatchEnv.getUtilOption();
                        try {
                            readServices = PrereqSession.getReadServices(oracleHomePath);
                        }
                        catch (Throwable t) {
                            return;
                        }
                        if (!readServices.isInventoryLoaded()) {
                            return;
                        }
                        if (PatchingModel.returnModelCode(OPatchEnv.getOracleHome()) == 2) {
                            OLogger.println("OPatchUtilHelper::Clean .patch_store of snowball...");
                            ArrayList<String> filter = new ArrayList<String>();
                            filter.add("unzip_action");
                            filter.add("patch_unzip");
                            OPatchSessionHelper.emptyDirectory(patchStoragePath, true, filter);
                            return;
                        }
                        existedPatches = new HashMap<String, String>();
                        OneOffEntry[] activePatches = readServices.getInstalledPatches();
                        OneOffEntry[] inactivePatches = readServices.getInactivePatches();
                        for (OneOffEntry oneOff : activePatches) {
                            if (oneOff == null) continue;
                            cookedPatchId = oneOff.getCookedPatchID();
                            id = oneOff.getPatchID();
                            existedPatches.put(cookedPatchId, id);
                        }
                        for (OneOffEntry oneOff : inactivePatches) {
                            if (oneOff == null) continue;
                            cookedPatchId = oneOff.getCookedPatchID();
                            id = oneOff.getPatchID();
                            existedPatches.put(cookedPatchId, id);
                        }
                        buff = new StringBuilder(patchStoragePath);
                        buff.append(File.separator);
                        len = buff.length();
                        if (!sessionType.equals("rollback")) break block10;
                        String cookedPatchId2 = OPatchEnv.getCookedPatchID();
                        if (existedPatches.containsKey(cookedPatchId2)) break block11;
                        buff.setLength(len);
                        buff.append(cookedPatchId2);
                        OPatchSessionHelper.deleteRecurse(buff.toString());
                        break block11;
                    }
                    if (!sessionType.equals("util") || !utilOption.equals("nrollback")) break block12;
                    size = nrollbackOneOffs.length;
                    if (size <= 0) break block11;
                    for (int i2 = 0; i2 < size; ++i2) {
                        cookedPatchId = nrollbackOneOffs[i2].getCookedPatchID();
                        if (existedPatches.containsKey(cookedPatchId)) continue;
                        buff.setLength(len);
                        buff.append(cookedPatchId);
                        OPatchSessionHelper.deleteRecurse(buff.toString());
                    }
                    break block11;
                }
                if ((!sessionType.equals("util") || !utilOption.equals("napply")) && !sessionType.equals("apply")) break block13;
                size = autoRollbackOneOffsToCleanUp.length;
                if (size <= 0) break block11;
                for (int i3 = 0; i3 < size; ++i3) {
                    cookedPatchId = autoRollbackOneOffsToCleanUp[i3].getCookedPatchID();
                    String patchId = autoRollbackOneOffsToCleanUp[i3].getPatchID();
                    if (existedPatches.containsKey(cookedPatchId)) continue;
                    buff.setLength(len);
                    buff.append(cookedPatchId);
                    OPatchSessionHelper.deleteRecurse(buff.toString());
                }
                break block11;
            }
            if (sessionType.equals("util") && utilOption.equals("cleanup") && (patchStorageFile = new File(patchStoragePath)).exists()) {
                String[] subDirs;
                for (String subDir : subDirs = patchStorageFile.list()) {
                    buff.setLength(len);
                    buff.append(subDir);
                    if (subDir.equals("NApply") || subDir.equals("NRollback") || !new File(buff.toString()).isDirectory() || existedPatches.containsKey(subDir)) continue;
                    OPatchSessionHelper.deleteRecurse(buff.toString());
                }
            }
        }
    }

    protected static void cleanupBackupArea(String oracleHomePath) {
        String patchStorage = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath);
        File psFile = new File(patchStorage);
        if (!psFile.exists()) {
            OLogger.println("No patch storage area for given Oracle Home.");
            return;
        }
        File[] dirList = psFile.listFiles();
        for (int i2 = 0; i2 < dirList.length; ++i2) {
            File currentFile = dirList[i2];
            OPatchUtilHelper.cleanupBackupArea(oracleHomePath, currentFile.getAbsolutePath());
            String dirName = currentFile.getName();
            if (!dirName.equals("NApply") && !dirName.equals("NRollback")) continue;
            File[] dList = currentFile.listFiles();
            for (int j2 = 0; j2 < dList.length; ++j2) {
                File cFile = dList[j2];
                OPatchUtilHelper.cleanupBackupArea(oracleHomePath, cFile.getAbsolutePath());
            }
        }
        OPatchUtilHelper.cleanupPatchStorage(oracleHomePath);
    }

    static boolean validatePatchSubType(String[] patchLocs) throws Exception {
        if (!IPMUtil.isNextGenUpgradePatchingSupported()) {
            return true;
        }
        int upgradePatchCount = 0;
        int updatePatchCount = 0;
        CommonAPIUtil util = CommonAPIUtil.getInstance();
        ArrayList<String> upgradePatchIds = new ArrayList<String>();
        ArrayList<String> updatePatchIds = new ArrayList<String>();
        for (String patchLoc : patchLocs) {
            Patch p2 = util.getCommonAPIPatch(patchLoc);
            if (p2.getPatchSubType() == PatchSubType.UPGRADE) {
                ++upgradePatchCount;
                upgradePatchIds.add(p2.getPatchId());
            } else {
                ++updatePatchCount;
                updatePatchIds.add(p2.getPatchId());
            }
            if (upgradePatchCount > 1) {
                throw new UnsupportedOperationException("Multiple upgrade type patches" + upgradePatchIds + " cannot be combined.");
            }
            if (upgradePatchCount != 1 || updatePatchCount <= 0) continue;
            throw new UnsupportedOperationException("Upgrade type patch " + upgradePatchIds + " cannot be combined with other patches " + updatePatchIds + ".");
        }
        return true;
    }

    public static void main(String[] args) {
        OPatchUtilHelper oPatchUtilHelper = new OPatchUtilHelper();
    }

    public static class InitScriptBuff {
        InitScriptAction a;
        String patchID;

        InitScriptBuff(InitScriptAction a2, String patchID) {
            this.a = a2;
            this.patchID = patchID;
        }
    }

    public static class PostScriptBuff {
        PostScriptAction a;
        String patchID;

        PostScriptBuff(PostScriptAction a2, String patchID) {
            this.a = a2;
            this.patchID = patchID;
        }
    }

    public static class PreScriptBuff {
        PreScriptAction a;
        String patchID;

        PreScriptBuff(PreScriptAction a2, String patchID) {
            this.a = a2;
            this.patchID = patchID;
        }
    }
}

