/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchutil;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import oracle.opatch.MergedPatchObject;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.RacFileCreator;
import oracle.opatch.opatchlogger.OLogger;

public class RacFileMerger {
    protected static void createMPFinal(String oracleHomePath, String cookedPatchID, PatchObject[] patchObjects) throws RuntimeException {
        StringBuffer tmp = new StringBuffer("RacFileMerger::createMPFinal for all patches");
        OLogger.debug(tmp);
        try {
            OPatchSessionHelper.checkArrayForNull("PatchObject", patchObjects);
        }
        catch (NullPointerException e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        tmp = new StringBuffer("  generate MP file for ");
        tmp.append(patchObjects.length);
        tmp.append(" patches.");
        try {
            OPatchSessionHelper.createMPFinal(oracleHomePath, cookedPatchID, patchObjects);
        }
        catch (IOException e3) {
            RuntimeException re = new RuntimeException(e3.getMessage());
            re.setStackTrace(e3.getStackTrace());
            throw re;
        }
    }

    private static void checkDirectoryForReadWrite(String caller, String whereToCreate) throws IOException {
        File dest = new File(whereToCreate);
        if (dest.exists() && dest.isFile()) {
            throw new IOException(caller + ": \"" + whereToCreate + "\" is a file");
        }
        if (!dest.exists()) {
            dest.mkdirs();
        }
        if (!dest.exists()) {
            throw new IOException(caller + ": Cannot mkdir \"" + whereToCreate + "\"");
        }
    }

    private static void checkFileForRead(String caller, String whereToRead) throws IOException {
        File dest = new File(whereToRead);
        if (dest.exists() && !dest.isFile() && !dest.canRead()) {
            throw new IOException(caller + ": \"" + whereToRead + "\" is not a file");
        }
    }

    private static void createFile(String oracleHomePath, String cookedPatchID, PatchObject[] patchObjects, int code) throws IOException {
        if (oracleHomePath == null || cookedPatchID == null) {
            throw new IOException("RacFileMerger::createFile() was called with Null argument");
        }
        try {
            OPatchSessionHelper.checkArrayForNull("PatchObject", patchObjects);
        }
        catch (NullPointerException e2) {
            StringBuffer msg = new StringBuffer("RacFileMerger::createFile(): the PatchObect[] contains null entry: ");
            msg.append(e2.getMessage());
            IOException io = new IOException(msg.toString());
            io.setStackTrace(e2.getStackTrace());
            throw io;
        }
        if (code != 20 && code != 22 && code != 21 && code != 23 && code != 24) {
            throw new IOException("RacFileMerger::createFile() was called with wrong code.");
        }
        StringBuffer rac = new StringBuffer(oracleHomePath);
        rac.append(File.separator);
        rac.append(OPatchEnv.getPatchStorageName());
        rac.append(File.separator);
        rac.append(cookedPatchID);
        rac.append(File.separator);
        rac.append(OPatchEnv.getRacSubdirName());
        RacFileMerger.checkDirectoryForReadWrite("RacFileMerger::createFile()", rac.toString());
        String name = "";
        switch (code) {
            case 20: {
                name = RacFileCreator.getFPFinalName();
                break;
            }
            case 22: {
                name = RacFileCreator.getDPFinalName();
                break;
            }
            case 21: {
                name = RacFileCreator.getFRFinalName();
                break;
            }
            case 23: {
                name = RacFileCreator.getDRFinalName();
                break;
            }
            case 24: {
                name = RacFileCreator.getRCFinalName();
                break;
            }
            default: {
                name = "";
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i2 = 0; i2 < patchObjects.length; ++i2) {
            PatchObject po = patchObjects[i2];
            String racArea = po.getRacFileArea(oracleHomePath);
            File racDir = new File(racArea);
            if (!racDir.exists() || !racDir.isDirectory()) continue;
            StringBuffer targetFile = new StringBuffer(racArea);
            if (!racArea.endsWith(File.separator)) {
                targetFile.append(File.separator);
            }
            targetFile.append(name);
            File f2 = new File(targetFile.toString());
            if (!f2.exists() || !f2.canRead()) continue;
            list.add(targetFile.toString());
        }
        int len = list.size();
        String[] sourceFiles = new String[len];
        for (int i3 = 0; i3 < len; ++i3) {
            String file;
            Object obj = list.get(i3);
            if (!(obj instanceof String)) continue;
            sourceFiles[i3] = file = (String)obj;
        }
        if (sourceFiles.length != 0) {
            RacFileCreator.mergeFiles(oracleHomePath, cookedPatchID, sourceFiles, code);
        }
    }

    public static void createModeFile(String oracleHomePath, String cookedPatchID, String mode) throws IOException {
        if (oracleHomePath == null || cookedPatchID == null || mode == null) {
            throw new IOException("RacFileMerger::createModeFile: Null value in argument.");
        }
        StringBuffer whereToCreate = new StringBuffer(oracleHomePath);
        whereToCreate.append(File.separator);
        whereToCreate.append(OPatchEnv.getPatchStorageName());
        whereToCreate.append(File.separator);
        whereToCreate.append(cookedPatchID);
        whereToCreate.append(File.separator);
        whereToCreate.append(OPatchEnv.getRacSubdirName());
        RacFileMerger.checkDirectoryForReadWrite("RacFileMerger::createModeFile()", whereToCreate.toString());
        StringBuffer fileName = new StringBuffer(whereToCreate.toString());
        if (!fileName.toString().endsWith(File.separator)) {
            fileName.append(File.separator);
        }
        String modetxt = OPatchEnv.getModeFileName();
        fileName.append(modetxt);
        FileWriter fw = new FileWriter(fileName.toString());
        BufferedWriter bw = new BufferedWriter(fw);
        fw.write(mode);
        bw.close();
    }

    public static void createCopyFile(String oracleHomePath, String cookedPatchID, PatchObject[] patchObjects) throws IOException {
        RacFileMerger.createFile(oracleHomePath, cookedPatchID, patchObjects, 20);
    }

    public static void createCopyDir(String oracleHomePath, String cookedPatchID, PatchObject[] patchObjects) throws IOException {
        RacFileMerger.createFile(oracleHomePath, cookedPatchID, patchObjects, 22);
    }

    public static void createRemoveFile(String oracleHomePath, String cookedPatchID, PatchObject[] patchObjects) throws IOException {
        RacFileMerger.createFile(oracleHomePath, cookedPatchID, patchObjects, 21);
    }

    public static void createRemoveDir(String oracleHomePath, String cookedPatchID, PatchObject[] patchObjects) throws IOException {
        RacFileMerger.createFile(oracleHomePath, cookedPatchID, patchObjects, 23);
    }

    public static void createRemoteCommandFile(String oracleHomePath, String cookedPatchID, PatchObject[] patchObjects) throws IOException {
        RacFileMerger.createFile(oracleHomePath, cookedPatchID, patchObjects, 24);
    }

    public static void createMakeFile(String oracleHomePath, String cookedPatchID, PatchObject[] patchObjects) throws IOException {
        StringBuffer whereToCreate = new StringBuffer(oracleHomePath);
        whereToCreate.append(File.separator);
        whereToCreate.append(OPatchEnv.getPatchStorageName());
        whereToCreate.append(File.separator);
        whereToCreate.append(cookedPatchID);
        whereToCreate.append(File.separator);
        whereToCreate.append(OPatchEnv.getRacSubdirName());
        RacFileMerger.checkDirectoryForReadWrite("RacFileMerger::createModeFile()", whereToCreate.toString());
        OPatchSessionHelper.createMPFinal(oracleHomePath, cookedPatchID, patchObjects);
    }

    public static void main(String[] args) throws IOException, InstantiationException {
        PatchObject p614;
        PatchObject p100;
        PatchObject p20;
        PatchObject p1;
        Properties prop = new Properties();
        prop.setProperty("OPatch.DEBUG", "TRUE");
        StringBuffer tmp = new StringBuffer("PatchList::main()");
        OLogger.debug(tmp);
        String patchLocPtr = "/scratch/phnguyen/OracleHome/10.2/home1/inventory/oneoffs";
        String oracleHomePath = "/scratch/phnguyen/OracleHome/10.2/home1";
        String cookedPatchID = "nApply";
        String[] patchIDs = new String[]{"1", "100", "20", "614"};
        tmp = new StringBuffer(" instantiating a PatchList object");
        OLogger.debug(tmp);
        String sessionName = OPatchEnv.getNApplySessionName();
        try {
            MergedPatchObject mpo = new MergedPatchObject(sessionName);
            p1 = PatchObjectUtil.loadPatch(patchLocPtr + File.separator + "1");
            p20 = PatchObjectUtil.loadPatch(patchLocPtr + File.separator + "20");
            p100 = PatchObjectUtil.loadPatch(patchLocPtr + File.separator + "100");
            p614 = PatchObjectUtil.loadPatch(patchLocPtr + File.separator + "614");
        }
        catch (RuntimeException e2) {
            IOException io = new IOException(e2.getMessage());
            io.setStackTrace(e2.getStackTrace());
            throw io;
        }
        PatchObject[] patchObjects = new PatchObject[]{p1, p20, p100, p614};
        String mode = "apply";
        RacFileMerger.createModeFile(oracleHomePath, cookedPatchID, mode);
        RacFileMerger.createCopyFile(oracleHomePath, cookedPatchID, patchObjects);
        RacFileMerger.createCopyDir(oracleHomePath, cookedPatchID, patchObjects);
        RacFileMerger.createRemoveFile(oracleHomePath, cookedPatchID, patchObjects);
        RacFileMerger.createRemoveDir(oracleHomePath, cookedPatchID, patchObjects);
        RacFileMerger.createMakeFile(oracleHomePath, cookedPatchID, patchObjects);
    }
}

