/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.base.interview.common.action;

import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.interview.common.resource.StringResourceBundle;
import oracle.install.commons.base.summary.Summary;
import oracle.install.commons.flow.DefaultAction;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.FlowDataRecorder;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.RoutePlan;
import oracle.install.commons.flow.State;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Graph;
import oracle.install.commons.util.XmlSupport;

public abstract class AbstractSummaryAction
extends DefaultAction {
    private static final Logger logger = Logger.getLogger(AbstractSummaryAction.class.getName());

    protected abstract void buildSummary(FlowContext var1);

    @Override
    public final void execute(FlowContext flowContext) {
        Summary summary = Summary.getInstance();
        summary.beginUpdate();
        this.buildSummary(flowContext);
        if (!summary.isReady()) {
            summary.endUpdate();
        }
        try {
            String text = XmlSupport.formatAsText(summary.toXML(), "/oracle/install/commons/base/summary/resource/summary_text.xsl");
            logger.info(text);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    @Override
    public Route transition(FlowContext flowContext) {
        return Route.SUCCESS;
    }

    public final boolean isTraversableStateId(FlowContext flowContext, String stateId) {
        if (stateId != null && stateId.length() > 0 && Application.getInstance().getBoolean("wizard.visitedLinkEnabled", true)) {
            RoutePlan routePlan = flowContext.getRoutePlan();
            List<Graph<Route, State>> tracedPath = routePlan.getTracedPath();
            Object vertex = null;
            for (Graph<Route, State> node : tracedPath) {
                if (!node.getValue().getId().equals(stateId)) continue;
                return true;
            }
        }
        return false;
    }

    protected void saveResponseFile(FlowContext flowContext, String responseFilePath) {
        if (responseFilePath != null) {
            logger.log(Level.INFO, "Response file name: " + responseFilePath);
            File responseFile = new File(responseFilePath);
            File rspFileParentPathFile = responseFile.getParentFile();
            String rspFileParentPath = rspFileParentPathFile.getPath();
            if (!rspFileParentPathFile.exists()) {
                logger.log(Level.INFO, "Path does not exist:" + rspFileParentPath);
                try {
                    if (!rspFileParentPathFile.mkdirs()) {
                        logger.log(Level.SEVERE, "Could not create path: " + rspFileParentPath);
                        return;
                    }
                    logger.log(Level.INFO, "Successfully created path: " + rspFileParentPath);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Could not create path: " + rspFileParentPath, e);
                    return;
                }
            } else {
                logger.log(Level.INFO, "Path already exists:" + rspFileParentPath);
            }
            if (rspFileParentPathFile.canWrite()) {
                if (responseFile != null) {
                    FlowDataRecorder recorder = FlowDataRecorder.getInstance();
                    recorder.setRecordFile(responseFile);
                    recorder.record(flowContext);
                    logger.log(Level.INFO, "Response file created successfully: " + responseFilePath);
                    String message = Application.getInstance().getResource(StringResourceBundle.class.getName()).getString("AbstractSummaryAction.responseFileLocation", "The response file for this session can be found at:\n {0}", responseFilePath);
                    System.out.println(message);
                    System.out.println();
                }
            } else {
                logger.log(Level.SEVERE, "Path is not writable:" + rspFileParentPath);
            }
        } else {
            logger.log(Level.INFO, "Response file path is null");
        }
    }
}

