/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow.jewt;

import java.util.List;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.util.StringUtils;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.FlowControl;
import oracle.install.commons.flow.FlowDirection;
import oracle.install.commons.flow.FlowNavigator;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.RoutePlan;
import oracle.install.commons.flow.State;
import oracle.install.commons.flow.Transition;
import oracle.install.commons.flow.jewt.FlowWizard;
import oracle.install.commons.util.Graph;

public class JewtFlowControl
implements FlowControl {
    private FlowWizard flowDisplay;
    private Runnable forward;
    private Runnable backward;
    private FlowContext flowContext;

    public JewtFlowControl(final FlowWizard flowDisplay, FlowContext flowContext) {
        this.flowContext = flowContext;
        this.flowDisplay = flowDisplay;
        this.forward = new Runnable(){

            @Override
            public void run() {
                flowDisplay.doNext(JewtFlowControl.this);
            }
        };
        this.backward = new Runnable(){

            @Override
            public void run() {
                flowDisplay.doPrevious(JewtFlowControl.this);
            }
        };
    }

    @Override
    public void lock(FlowDirection direction, boolean enabled) {
        WizardPage currentPage = this.flowDisplay.getCurrentPage();
        switch (direction) {
            case FORWARD: {
                currentPage.setCanAdvance(!enabled);
                break;
            }
            case BACKWARD: {
                currentPage.setCanGoBack(!enabled);
                break;
            }
            case NONE: {
                this.lock(enabled);
            }
        }
    }

    @Override
    public void backward() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.flowDisplay.doPrevious();
        } else {
            SwingUtilities.invokeLater(this.backward);
        }
    }

    @Override
    public void forward() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.flowDisplay.doNext();
        } else {
            SwingUtilities.invokeLater(this.forward);
        }
    }

    @Override
    public void stop() {
        Transition transition = this.flowContext.getTransition();
        if (transition != null) {
            transition.abort();
        }
    }

    @Override
    public void lock(boolean enabled) {
        WizardPage currentPage = this.flowDisplay.getCurrentPage();
        RoutePlan routePlan = this.flowDisplay.getFlowNavigator().getRoutePlan();
        if (!routePlan.getCurrentVertex().isTerminal()) {
            currentPage.setCanAdvance(!enabled);
        }
        currentPage.setCanGoBack(!enabled);
    }

    @Override
    public void lookAhead(Route route) {
        this.flowDisplay.getFlowNavigator().getRoutePlan().lookAhead(route);
    }

    @Override
    public void markCurrentStateAsDirty(boolean dirty) {
        State state;
        Graph<Route, State> vertex;
        RoutePlan routePlan;
        FlowNavigator flowNavigator = this.flowDisplay.getFlowNavigator();
        if (flowNavigator != null && (routePlan = flowNavigator.getRoutePlan()) != null && (vertex = routePlan.getCurrentVertex()) != null && (state = vertex.getValue()) != null) {
            state.setDirty(dirty);
        }
    }

    @Override
    public void moveTo(String stateId) {
        if (stateId != null && stateId.length() > 0 && this.flowDisplay.isVisitedLinkEnabled()) {
            RoutePlan routePlan = this.flowDisplay.getFlowNavigator().getRoutePlan();
            List<Graph<Route, State>> followedPath = routePlan.getFollowedPath();
            Graph<Route, State> vertex = null;
            for (Graph<Route, State> node : followedPath) {
                if (!node.getValue().getId().equals(stateId)) continue;
                vertex = node;
                break;
            }
            if (vertex != null) {
                final Graph<Route, State> tracableVertex = routePlan.getLastTracedVertex(vertex);
                if (SwingUtilities.isEventDispatchThread()) {
                    this.flowDisplay.moveTo(tracableVertex);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JewtFlowControl.this.flowDisplay.moveTo(tracableVertex);
                        }
                    });
                }
            }
        }
    }

    public void setFinishButtonText(String str) {
        if (str != null && !str.isEmpty() && this.flowDisplay != null) {
            this.flowDisplay.setFinishText(StringUtils.stripMnemonic((String)str));
            if (StringUtils.getMnemonicIndex((String)str) != -1) {
                this.flowDisplay.setFinishMnemonic(StringUtils.getMnemonicKeyCode((String)str));
            }
        }
    }
}

