/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.swing.treetable;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class TreeTableColumn {
    private String name;
    private Class type;
    private boolean visible;
    protected PropertyChangeSupport propertyChangeSupport;

    public TreeTableColumn() {
        this("Default Column", String.class);
    }

    public TreeTableColumn(String name, Class type) {
        this(name, type, true);
    }

    public TreeTableColumn(String name, Class type, boolean visible) {
        this.name = name;
        this.type = type;
        this.visible = visible;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        boolean oldValue = this.visible;
        this.visible = visible;
        this.propertyChangeSupport.firePropertyChange("TreeTableColumn.visibility", oldValue, visible);
    }

    public String toString() {
        return this.name;
    }
}

