/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.util.progress;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import oracle.install.commons.swing.HtmlPane;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.progress.resource.StringResourceBundle;

public class ProgressDetailsDialog
extends JDialog {
    private static final int DEFAULT_NUMBER_OF_TAIL_LINES = 30;
    private static final long DEFAULT_REFRESH_RATE_MS = 1000L;
    private HtmlPane contentPane;
    private String targetProgressFile;
    private int numberOfLastLines;
    private long refreshRate;
    private TailLogParser tailLogParser;
    private Resource dialogBundle = Application.getInstance().getResource(StringResourceBundle.class.getName());

    public ProgressDetailsDialog(Frame parent, String targetFile, String dialogTitle) {
        super(parent);
        this.targetProgressFile = targetFile;
        this.init(parent, dialogTitle);
    }

    public ProgressDetailsDialog(Dialog parent, String targetFile, String dialogTitle) {
        super(parent);
        this.targetProgressFile = targetFile;
        this.init(parent, dialogTitle);
    }

    private void init(Window parent, String dialogTitle) {
        this.numberOfLastLines = 30;
        this.refreshRate = 1000L;
        int parentWidth = parent.getWidth();
        int parentHeight = parent.getHeight();
        this.setSize(new Dimension(parentWidth / 2, parentHeight / 2));
        this.setTitle(dialogTitle);
        Point location = parent.getLocation();
        Dimension size = this.getSize();
        location.x += parentWidth / 2 - size.width / 2;
        location.y += parentHeight / 2 - size.height / 2;
        this.setLocation(location);
        this.setAlwaysOnTop(true);
        this.buildDialogUI();
        this.tailLogParser = new TailLogParser(this.targetProgressFile, this.contentPane, this.numberOfLastLines, this.refreshRate);
    }

    public void setRefreshRate(long refreshRateInMS) {
        this.refreshRate = refreshRateInMS;
    }

    public void setNumberOfDisplayedLines(int numberOfLines) {
        this.numberOfLastLines = numberOfLines;
    }

    private void buildDialogUI() {
        this.contentPane = new HtmlPane();
        this.contentPane.setEditable(false);
        this.contentPane.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add(new JScrollPane(this.contentPane));
        JButton btnClose = new JButton();
        btnClose.setName("ProgressDetailsDialog.btnClose");
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressDetailsDialog.this.doClose();
            }
        });
        SwingUtils.setText(btnClose, this.dialogBundle.getString("ProgressPane.DetailsDialog.btnClose.text", "&Close", new Object[0]));
        JButton btnRefresh = new JButton();
        btnRefresh.setName("ProgressDetailsDialog.btnRefresh");
        btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgressDetailsDialog.this.displayContent();
            }
        });
        SwingUtils.setText(btnRefresh, this.dialogBundle.getString("ProgressDetailsDialog.btnRefresh.text", "&Refresh", new Object[0]));
        JLabel lblContentNotice = new JLabel();
        lblContentNotice.setName("ProgressDetailsDialog.lblContentNotice");
        String lblText = MessageFormat.format(this.dialogBundle.getString("ProgressDetailsDialog.lblContentNotice.text", "Last {0} lines are displayed", new Object[0]), String.valueOf(this.numberOfLastLines));
        SwingUtils.setText(lblContentNotice, lblText);
        JPanel space = new JPanel();
        space.setLayout(new GridBagLayout());
        LayoutUtils.addComponent(lblContentNotice, space, 0, 0, 1, 1, 2, 18, 1.0, 0.0);
        LayoutUtils.addComponent(btnRefresh, space, 1, 0, 1, 1, 0, 18, 0.0, 0.0);
        LayoutUtils.addComponent(btnClose, space, 2, 0, 1, 1, 0, 18, 0.0, 0.0);
        this.add((Component)space, "Last");
    }

    private void doClose() {
        this.setVisible(false);
    }

    public void displayContent() {
        this.tailLogParser.performTailLog();
        this.setVisible(true);
    }

    class TailLogParser {
        private HtmlPane targetContentPane;
        private String targetLogFile;
        private RandomAccessFile logPointer;
        private int numberOfTailLines;
        private long refreshRate;
        private String currentTailContent;

        public TailLogParser(String targetLogFile, HtmlPane targetContentPane, int numberOfTailLines, long refreshRateInMS) {
            this.targetContentPane = targetContentPane;
            this.targetLogFile = targetLogFile;
            this.numberOfTailLines = numberOfTailLines;
            this.refreshRate = refreshRateInMS;
        }

        public void performTailLog() {
            try {
                this.logPointer = new RandomAccessFile(this.targetLogFile, "r");
                long fileLength = this.logPointer.length() - 1L;
                StringBuffer logContent = new StringBuffer();
                int currentLine = 0;
                for (long tailPointer = fileLength; tailPointer != -1L; --tailPointer) {
                    this.logPointer.seek(tailPointer);
                    byte currentByte = this.logPointer.readByte();
                    if (currentByte == 10 || currentByte == 13) {
                        if (tailPointer < fileLength) {
                            ++currentLine;
                        }
                        logContent.append(">rb<");
                    } else {
                        logContent.append((char)currentByte);
                    }
                    if (currentLine >= this.numberOfTailLines) break;
                }
                this.currentTailContent = logContent.reverse().toString();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TailLogParser.this.targetContentPane.setText(TailLogParser.this.currentTailContent);
                    }
                });
            }
            catch (IOException e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TailLogParser.this.targetContentPane.setText("<br><br><br><br><br><br><br><center>" + ProgressDetailsDialog.this.dialogBundle.getString("ProgressDetailsDialog.noContent.text", "No content to display for the moment", new Object[0]) + "</center>");
                    }
                });
            }
        }
    }
}

