/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipcz;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixUtil;
import oracle.sysman.oip.oipc.oipch.OipchHost;
import oracle.sysman.oip.oipc.oipch.OipchLinuxOS;
import oracle.sysman.oip.oipc.oipch.OipchLinuxOSVersion;
import oracle.sysman.oip.oipc.oipch.OipchOS;
import oracle.sysman.oip.oipc.oipch.OipchRefHost;
import oracle.sysman.oip.oipc.oipch.OipchVersion;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipck.OipckNoReferenceSpecifiedException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownBuilderException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipcr.OipcrExecuteRuleException;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrResult;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;

public class OipczOSChecks {
    public static final String SEPARATOR = ",";
    private static OipchVersion comPatibleOSFromRefhost = null;

    private OipczOSChecks() {
    }

    public static OipcrIResult checkCertifiedOSVersions(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        if (oRulesEngine != null) {
            try {
                String sActualValue;
                StringTokenizer st;
                OipchRefHost oRefhost = (OipchRefHost)oRulesEngine.getRefKnowledgeSource("refhost", sRefFile);
                OipchHost oHost = (OipchHost)oRulesEngine.getKnowledgeSource("host");
                OipchOS oOS = oHost.getOS();
                OipchVersion oVer = oOS.getOSVersion();
                OiiolTextLogger.appendText((String)("### OipczOSChecks: Actual Host-OS Version is: " + oVer.getVersion()));
                OipchVersion oVerTemp = OipczOSChecks.getCompatibleOSFromRefhost(oOS, oRefhost);
                if (null != oVerTemp) {
                    oVer = oVerTemp;
                }
                OiiolTextLogger.appendText((String)("### OipczOSChecks: Modified Host-OS Version is: " + oVer.getVersion()));
                Iterator oVers = oRefhost.getOSVersions();
                ArrayList<String> oList = new ArrayList<String>();
                String sUpExpectedValue = null;
                String sUpActualValue = null;
                String sSPExpectedValue = null;
                String sSPActualValue = null;
                boolean isServicePackPassed = true;
                while (oVers.hasNext()) {
                    OipchVersion v = (OipchVersion)oVers.next();
                    oList.add(v.getDisplayName());
                    if (oResult == OipcrResult.PASSED_RESULT) continue;
                    OipchOS oRefOS = oRefhost.getOSForVersion(v);
                    if (oOS.getPlatformID() == oRefOS.getPlatformID() && oVer != null && oVer.compare((Object)v) == 1) {
                        oResult = OipcrResult.PASSED_RESULT;
                        if (oOS.getPlatformID() == 46 || oOS.getPlatformID() == 227 || oOS.getPlatformID() == 211 || oOS.getPlatformID() == 525) {
                            OipchLinuxOS oLnxOS = (OipchLinuxOS)oOS;
                            OipchLinuxOSVersion lnxVer = new OipchLinuxOSVersion(v.getVersion());
                            oLnxOS.setOSVersion(lnxVer);
                            oVer = lnxVer;
                            if (oLnxOS.getOSVendor().toString().equals("SuSE")) {
                                Object[] expSPArr = oRefhost.getServicePacks(oVer);
                                String actSP = OiixUtil.isEmpty((Object[])oOS.getOSServicePacks()) ? "" : oOS.getOSServicePacks()[0];
                                isServicePackPassed = OipczOSChecks.checkServicePack(actSP, (String[])expSPArr);
                                if (!isServicePackPassed) {
                                    oResult = OipcrResult.FAILED_RESULT;
                                }
                                if (expSPArr != null && expSPArr.length != 0) {
                                    Object[] actSPArr = new String[]{actSP};
                                    sSPExpectedValue = OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcp.resources.OipcpRuntimeRes", (String)"OIPCP0013", (Object[])expSPArr);
                                    sSPActualValue = OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcp.resources.OipcpRuntimeRes", (String)"OIPCP0014", (Object[])actSPArr);
                                }
                            }
                        }
                        if (oOS.getPlatformID() != 453 && oOS.getPlatformID() != 173 && (oOS.getPlatformID() != 23 || oResult != OipcrResult.PASSED_RESULT)) continue;
                        Iterator oUpVers = oRefhost.getOSUpdateVersions(oVer);
                        ArrayList<String> upList = new ArrayList<String>();
                        boolean flag = false;
                        String uv = null;
                        while (oUpVers.hasNext()) {
                            uv = (String)oUpVers.next();
                            upList.add(uv);
                            if (uv.compareTo(oOS.getOSUpdateVersion()) > 0) continue;
                            oResult = OipcrResult.PASSED_RESULT;
                            flag = true;
                        }
                        if (uv == null) continue;
                        if (!flag) {
                            oResult = OipcrResult.FAILED_RESULT;
                        }
                        String[] upVers = new String[upList.size()];
                        upVers = upList.toArray(upVers);
                        Object[] upArgs = new String[]{OiixFunctionOps.implodeList((String[])upVers, (String)SEPARATOR)};
                        sUpExpectedValue = OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OIPCZ0001", (Object[])upArgs);
                        sUpActualValue = oOS.getOSUpdateVersion();
                        continue;
                    }
                    oResult = OipcrResult.FAILED_RESULT;
                }
                String[] asVers = new String[oList.size()];
                asVers = oList.toArray(asVers);
                Object[] args = new String[]{OiixFunctionOps.implodeList((String[])asVers, (String)SEPARATOR)};
                String sExpectedValue = OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OIPCZ0001", (Object[])args);
                if (sUpExpectedValue != null) {
                    sExpectedValue = sExpectedValue + " " + sUpExpectedValue;
                }
                if (sSPExpectedValue != null) {
                    sExpectedValue = sExpectedValue + sSPExpectedValue;
                }
                if ((st = new StringTokenizer(sActualValue = oVer == null ? OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OIPCZ005") : oVer.getDisplayName(), " ")).hasMoreTokens()) {
                    sActualValue = st.nextToken();
                }
                if (sUpExpectedValue != null) {
                    sActualValue = sActualValue + " " + sUpActualValue;
                }
                if (sSPExpectedValue != null) {
                    sActualValue = sActualValue + sSPActualValue;
                }
                OipcrResultDetails oResData = new OipcrResultDetails((Object)sActualValue, (Object)sExpectedValue, oResult);
                ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
                oResDetails.add(oResData);
                oResult = new OipcrResult(oResDetails);
            }
            catch (OipckUnknownKnowledgeSourceException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckKnowledgeSourceException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckNoReferenceSpecifiedException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckUnknownBuilderException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    private static boolean checkServicePack(String actSP, String[] expSPArr) {
        if (expSPArr == null || expSPArr.length == 0) {
            return true;
        }
        for (int i = 0; i < expSPArr.length; ++i) {
            String expSP = expSPArr[i];
            if (OiixUtil.isNullOrBlank((String)actSP, (boolean)true)) {
                actSP = "0";
            }
            if (expSP.compareTo(actSP) > 0) continue;
            return true;
        }
        return false;
    }

    static OipchVersion getCompatibleOSFromRefhost(OipchOS oOS, OipchRefHost oRefhost) {
        if (null != comPatibleOSFromRefhost) {
            return comPatibleOSFromRefhost;
        }
        OipchVersion currentOSVersion = oOS.getOSVersion();
        OipchVersion tempOSVersion = null;
        Iterator oVers = oRefhost.getOSVersions();
        while (oVers.hasNext()) {
            OipchVersion oVer = (OipchVersion)oVers.next();
            OiiolTextLogger.appendText((String)(" oVer = " + oVer.getVersion()));
            if (tempOSVersion == null && currentOSVersion.isCompatible(oVer)) {
                tempOSVersion = oVer;
            } else if (!currentOSVersion.isCompatible(oVer)) continue;
            OipchOS oRefOS = oRefhost.getOSForVersion(oVer);
            if (oOS.getPlatformID() != oRefOS.getPlatformID() || oVer == null) continue;
            if (oVer.getVersion().equals(currentOSVersion.getVersion())) {
                tempOSVersion = oVer;
                break;
            }
            OiiolTextLogger.appendText((String)(" oVer = " + oRefOS.getOSVersion().getVersion() + " tempVersion = " + tempOSVersion.getVersion() + " Status1 = " + oVer.isCompatible(tempOSVersion) + " Status2 = " + currentOSVersion.isCompatible(oVer)));
            if (!oVer.isCompatible(tempOSVersion) || !currentOSVersion.isCompatible(oVer)) continue;
            tempOSVersion = oVer;
        }
        if (null != tempOSVersion) {
            OiiolTextLogger.appendText((String)("Host OS: " + currentOSVersion.getVersion() + " Highest Compatible OS Version from refhost.xml file: " + tempOSVersion.getVersion()));
            comPatibleOSFromRefhost = currentOSVersion.isCompatible(tempOSVersion) ? tempOSVersion : currentOSVersion;
        } else {
            OiiolTextLogger.appendText((String)("Prereq Reference file doesn't contain any compatible entry for ths OS :" + currentOSVersion.getVersion()));
        }
        return comPatibleOSFromRefhost;
    }
}

