/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipcz;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipch.OipchCPU;
import oracle.sysman.oip.oipc.oipch.OipchGenericRefHost;
import oracle.sysman.oip.oipc.oipch.OipchHost;
import oracle.sysman.oip.oipc.oipch.OipchMemory;
import oracle.sysman.oip.oipc.oipch.OipchRefHost;
import oracle.sysman.oip.oipc.oipch.OipchSystem;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipck.OipckNoReferenceSpecifiedException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownBuilderException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipcr.OipcrExecuteRuleException;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrResult;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;
import oracle.sysman.oip.oipc.oipcz.OipczStep;
import oracle.sysman.oip.oipc.oipcz.OipczStepChecker;
import oracle.sysman.oix.oixd.OixdInvalidDocumentException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class OipczSystemChecks {
    private OipczSystemChecks() {
    }

    public static OipcrIResult checkMinCPUSpeed(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult;
        block12: {
            oResult = OipcrResult.NOT_EXECUTED_RESULT;
            if (oRulesEngine != null) {
                try {
                    OipchRefHost oRefHost = (OipchRefHost)oRulesEngine.getRefKnowledgeSource("refhost", sRefFile);
                    OipchHost oHost = (OipchHost)oRulesEngine.getKnowledgeSource("host");
                    OipchSystem oSystem = oHost.getSystem();
                    OipchSystem oRefSystem = oRefHost.getSystem();
                    if (oRefSystem != null) {
                        Iterator oRefCPUs = oRefSystem.getCPUs();
                        OipchCPU oMinRefSpeedCPU = OipczSystemChecks.getMinSpeedCPU(oRefCPUs);
                        Iterator oCPUs = oSystem.getCPUs();
                        OipchCPU oMinSpeedCPU = OipczSystemChecks.getMinSpeedCPU(oCPUs);
                        ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>(1);
                        if (oMinRefSpeedCPU == null || oMinSpeedCPU == null) {
                            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-18004", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OUI-18004")));
                        } else if (oMinSpeedCPU.getSpeed() == 0L) {
                            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-18004", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OUI-18004")));
                        } else {
                            OipcrIResult oRes = OipczSystemChecks.isCPUSlower(oMinRefSpeedCPU, oMinSpeedCPU) ? OipcrResult.PASSED_RESULT : OipcrResult.FAILED_RESULT;
                            oResDetails.add(new OipcrResultDetails((Object)oMinSpeedCPU.getSpeedAsString(), (Object)oMinRefSpeedCPU.getSpeedAsString(), oRes));
                            oResult = new OipcrResult(oResDetails);
                        }
                        break block12;
                    }
                    oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-18003", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OUI-18003")));
                }
                catch (OipckUnknownKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckNoReferenceSpecifiedException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownBuilderException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        return oResult;
    }

    private static OipchCPU getMinSpeedCPU(Iterator iter) {
        long lMinSpeed = 0L;
        OipchCPU oMinSpeedCPU = null;
        while (iter.hasNext()) {
            OipchCPU oCPU = (OipchCPU)iter.next();
            if (oMinSpeedCPU == null) {
                oMinSpeedCPU = oCPU;
                continue;
            }
            if (!OipczSystemChecks.isCPUSlower(oCPU, oMinSpeedCPU)) continue;
            oMinSpeedCPU = oCPU;
        }
        return oMinSpeedCPU;
    }

    private static boolean isCPUSlower(OipchCPU c1, OipchCPU c2) {
        long lSpeed1 = c1.getSpeed();
        String sSpeedUnit1 = c1.getSpeedUnit();
        long lSpeed2 = c2.getSpeed();
        String sSpeedUnit2 = c2.getSpeedUnit();
        long lMhzToGhzScale = 1024L;
        if (!sSpeedUnit1.equals(sSpeedUnit2)) {
            if (sSpeedUnit1.equals("Ghz")) {
                lSpeed1 *= 1024L;
                sSpeedUnit1 = "Mhz";
            }
            if (sSpeedUnit2.equals("Ghz")) {
                lSpeed2 *= 1024L;
                sSpeedUnit2 = "Mhz";
            }
        }
        return lSpeed1 <= lSpeed2;
    }

    public static OipcrIResult checkPhysicalMemory(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult;
        block8: {
            oResult = OipcrResult.NOT_EXECUTED_RESULT;
            if (oRulesEngine != null) {
                try {
                    OipchRefHost oRefHost = (OipchRefHost)oRulesEngine.getRefKnowledgeSource("refhost", sRefFile);
                    OipchHost oHost = (OipchHost)oRulesEngine.getKnowledgeSource("host");
                    OipchSystem oSystem = oHost.getSystem();
                    OipchSystem oRefSystem = oRefHost.getSystem();
                    if (oRefSystem == null) break block8;
                    OipchMemory oRefMem = oRefSystem.getPhysicalMemory();
                    if (oRefMem != null) {
                        ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>(1);
                        OipchMemory oMem = oSystem.getPhysicalMemory();
                        OipcrIResult oRes = OipczSystemChecks.compareMemory(oMem, oRefMem);
                        oResDetails.add(new OipcrResultDetails((Object)oMem.getDisplayName(), (Object)oRefMem.getDisplayName(), oRes));
                        oResult = new OipcrResult(oResDetails);
                        break block8;
                    }
                    oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-18005", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OUI-18005")));
                }
                catch (OipckUnknownKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckNoReferenceSpecifiedException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownBuilderException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        return oResult;
    }

    public static OipcrIResult checkAvailableMemory(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult;
        block8: {
            oResult = OipcrResult.NOT_EXECUTED_RESULT;
            if (oRulesEngine != null) {
                try {
                    OipchRefHost oRefHost = (OipchRefHost)oRulesEngine.getRefKnowledgeSource("refhost", sRefFile);
                    OipchHost oHost = (OipchHost)oRulesEngine.getKnowledgeSource("host");
                    OipchSystem oSystem = oHost.getSystem();
                    OipchSystem oRefSystem = oRefHost.getSystem();
                    if (oRefSystem == null) break block8;
                    OipchMemory oRefMem = oRefSystem.getAvailableMemory();
                    if (oRefMem != null) {
                        ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>(1);
                        OipchMemory oMem = oSystem.getAvailableMemory();
                        OipcrIResult oRes = OipczSystemChecks.compareMemory(oMem, oRefMem);
                        oResDetails.add(new OipcrResultDetails((Object)oMem.getDisplayName(), (Object)oRefMem.getDisplayName(), oRes));
                        oResult = new OipcrResult(oResDetails);
                        break block8;
                    }
                    oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-18005", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OUI-18005")));
                }
                catch (OipckUnknownKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckNoReferenceSpecifiedException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownBuilderException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        return oResult;
    }

    public static OipcrIResult checkSwapSpace(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult;
        block9: {
            oResult = OipcrResult.NOT_EXECUTED_RESULT;
            if (oRulesEngine != null) {
                try {
                    OipchGenericRefHost oGenRefHost = (OipchGenericRefHost)oRulesEngine.getRefKnowledgeSource("genrefhost", sRefFile);
                    OipchHost oHost = (OipchHost)oRulesEngine.getKnowledgeSource("host");
                    Node oSwapSizeNode = oGenRefHost.getSwapSizeNode();
                    Node oSwapSizeNodes = oGenRefHost.getSwapSizeNodes();
                    boolean ifStepNodes = oGenRefHost.hasStepNodes(oSwapSizeNode);
                    boolean ifStepsNodes = oGenRefHost.hasStepsNodes(oSwapSizeNode);
                    if (oSwapSizeNode != null) {
                        oResult = ifStepsNodes ? OipczSystemChecks.doSwapStepCheck(oSwapSizeNodes, oHost) : (ifStepNodes ? OipczSystemChecks.doSwapStepCheck(oSwapSizeNode, oHost) : OipczSystemChecks.doSwapCheck(oSwapSizeNode, oHost));
                        break block9;
                    }
                    oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-18006", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OUI-18006")));
                }
                catch (OixdInvalidDocumentException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckNoReferenceSpecifiedException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownBuilderException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        return oResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static OipcrIResult doSwapStepCheck(Node oSwapNode, OipchHost oHost) throws OixdInvalidDocumentException {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        OipczStep oStep = OipczStepChecker.doStepCheck(oSwapNode, oHost);
        String sMultiple = null;
        double dMultiple = -1.0;
        if (oStep == null) return OipcrResult.FAILED_RESULT;
        if (!oStep.getName().equalsIgnoreCase("PHYSICAL_MEMORY")) return oResult;
        if (oStep.getRetType() == 1) {
            sMultiple = oStep.getReturnValue();
            if (sMultiple != null) {
                dMultiple = Double.parseDouble(sMultiple);
                OipchSystem oSystem = oHost.getSystem();
                return OipczSystemChecks.checkSwapSpaceMultPhysical(dMultiple, oSystem);
            }
            Object[] args = new String[]{"SWAP_SIZE", "MULTIPLE"};
            throw new OixdInvalidDocumentException("OUI-11201", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11201", (Object[])args));
        }
        if (oStep.getRetType() != 0) return OipcrResult.NOT_EXECUTED_RESULT;
        return OipczSystemChecks.doSwapCheck(oStep.getStepNodeAttribs(), oHost);
    }

    private static OipcrIResult checkSwapSpaceMultPhysical(double dMultiple, OipchSystem oSystem) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        if (oSystem != null) {
            ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>(1);
            OipchMemory oSwap = oSystem.getSwapSpace();
            OipchMemory oPhyMem = oSystem.getPhysicalMemory();
            if (oSwap != null && oPhyMem != null) {
                long lSwap = oSwap.getSize();
                OipchMemory oMultPhyMem = new OipchMemory();
                oMultPhyMem.setSize((long)(dMultiple * (double)oPhyMem.getSize()), oPhyMem.getUnit());
                OipcrIResult oRes = OipczSystemChecks.compareMemory(oSwap, oMultPhyMem);
                oResDetails.add(new OipcrResultDetails((Object)oSwap.getDisplayName(), (Object)oMultPhyMem.getDisplayName(), oRes));
                oResult = new OipcrResult(oResDetails);
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-18006", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OUI-18006")));
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    private static OipcrIResult doSwapCheck(Node oSwapSizeNode, OipchHost oHost) throws OixdInvalidDocumentException {
        NamedNodeMap oNodeAttribs = oSwapSizeNode.getAttributes();
        return OipczSystemChecks.doSwapCheck(oNodeAttribs, oHost);
    }

    private static OipcrIResult doSwapCheck(NamedNodeMap oNodeAttribs, OipchHost oHost) throws OixdInvalidDocumentException {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        OipchSystem oSystem = oHost.getSystem();
        OipchMemory oRefMem = new OipchMemory();
        long lSize = 0L;
        int iUnit = 0;
        Node oAttrib = null;
        if (oNodeAttribs != null) {
            oAttrib = oNodeAttribs.getNamedItem("VALUE");
            if (oAttrib == null) {
                Object[] args = new String[]{"SWAP_SIZE", "VALUE"};
                throw new OixdInvalidDocumentException("OUI-11201", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11201", (Object[])args));
            }
            lSize = Long.parseLong(oAttrib.getNodeValue());
            oAttrib = oNodeAttribs.getNamedItem("UNIT");
            if (oAttrib != null) {
                String sUnit = oAttrib.getNodeValue();
                if (sUnit.equalsIgnoreCase("GB")) {
                    iUnit = 1;
                } else if (sUnit.equalsIgnoreCase("MB")) {
                    iUnit = 0;
                } else {
                    Object[] args = new String[]{"UNIT", "UNIT"};
                    throw new OixdInvalidDocumentException("OUI-11106", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipch.resources.OipchRuntimeRes", (String)"OUI-11106", (Object[])args));
                }
            }
        }
        oRefMem.setSize(lSize, iUnit);
        if (oRefMem != null) {
            ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>(1);
            OipchMemory oMem = oSystem.getSwapSpace();
            OipcrIResult oRes = OipczSystemChecks.compareMemory(oMem, oRefMem);
            oResDetails.add(new OipcrResultDetails((Object)oMem.getDisplayName(), (Object)oRefMem.getDisplayName(), oRes));
            oResult = new OipcrResult(oResDetails);
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-18006", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcz.resources.OipczRuntimeRes", (String)"OUI-18006")));
        }
        return oResult;
    }

    public static OipcrIResult checkSwapSpaceTwicePhysical(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        if (oRulesEngine != null) {
            try {
                OipchHost oHost = (OipchHost)oRulesEngine.getKnowledgeSource("host");
                OipchSystem oSystem = oHost.getSystem();
                oResult = OipczSystemChecks.checkSwapSpaceMultPhysical(2.0, oSystem);
            }
            catch (OipckUnknownKnowledgeSourceException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckKnowledgeSourceException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckUnknownBuilderException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    private static OipcrIResult compareMemory(OipchMemory m1, OipchMemory m2) {
        OipcrIResult oRes = OipcrResult.NOT_EXECUTED_RESULT;
        int iCompare = m1.compare(m2);
        oRes = iCompare == 1 || iCompare == 4 ? OipcrResult.PASSED_RESULT : OipcrResult.FAILED_RESULT;
        return oRes;
    }
}

