/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.util;

import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.library.util.FileInfo;

public class FilesListUpdater
implements Callable<Void> {
    private static Logger logger = Logger.getLogger(FilesListUpdater.class.getName());
    private String oracleHome;
    private String timestamp;
    private String filesLstPath;
    private String filesLstName = "files.lst";

    public FilesListUpdater(String oracleHome, String timestamp) {
        this.oracleHome = oracleHome;
        this.timestamp = timestamp;
        this.filesLstPath = oracleHome + File.separator + "install";
    }

    @Override
    public Void call() throws Exception {
        String filesLst = this.filesLstPath + File.separator + this.filesLstName;
        File filesLstFile = null;
        try {
            filesLstFile = new File(filesLst);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Could not create file object from: " + filesLst, e);
        }
        if (filesLstFile != null && filesLstFile.exists()) {
            ArrayList<String> files = null;
            try {
                files = FileInfo.getFileContentLines(filesLst);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not read the contents of file: " + filesLst, e);
            }
            if (files != null) {
                String filesLstBkp = this.filesLstPath + File.separator + this.filesLstName + "_" + this.timestamp + ".bkp";
                File filesLstBkpFile = null;
                try {
                    filesLstBkpFile = new File(filesLstBkp);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Could not create file object from: " + filesLstBkp, e);
                }
                if (filesLstBkpFile != null && !filesLstBkpFile.exists()) {
                    Path target = null;
                    try {
                        target = Files.move(filesLstFile.toPath(), filesLstBkpFile.toPath(), new CopyOption[0]);
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "Could not move the file " + filesLst + " to " + filesLstBkp, e);
                    }
                    if (target != null && !filesLstFile.exists()) {
                        boolean fileCreated = false;
                        try {
                            fileCreated = filesLstFile.createNewFile();
                        }
                        catch (Exception e) {
                            logger.log(Level.WARNING, "Could not create the files.lst file", e);
                        }
                        if (fileCreated) {
                            StringBuilder sb = new StringBuilder();
                            if (!files.isEmpty()) {
                                for (String file : files) {
                                    if (!file.startsWith("#")) {
                                        File eachFile = null;
                                        try {
                                            eachFile = new File(this.oracleHome + File.separator + file);
                                        }
                                        catch (Exception e) {
                                            logger.log(Level.WARNING, "Could not create file object from: " + eachFile, e);
                                        }
                                        if (eachFile == null || !eachFile.exists()) continue;
                                        sb.append(file + "\n");
                                        continue;
                                    }
                                    sb.append(file + "\n");
                                }
                            }
                            if (!FileInfo.appendTextToFile(filesLst, sb.toString())) {
                                logger.warning("Could not update the file: " + filesLst);
                            }
                        }
                    }
                }
            }
        } else {
            logger.log(Level.WARNING, "Could not locate file: " + filesLst);
        }
        return null;
    }
}

