/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.util;

import java.io.File;
import java.net.UnknownHostException;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.winsecurity.Credentials;
import oracle.cluster.winsecurity.User;
import oracle.cluster.winsecurity.WinSecurityFactory;
import oracle.cluster.winsecurity.WindowsSecurityException;
import oracle.install.commons.base.driver.common.Cloner;
import oracle.install.commons.base.driver.common.SetupDriver;
import oracle.install.commons.base.driver.common.SetupDriverException;
import oracle.install.commons.base.util.cli.CommandLineArgHelpConstructorImpl;
import oracle.install.commons.base.util.cli.CommandLineArgumentHandler;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ExitStatus;
import oracle.install.commons.util.ResourceURL;
import oracle.install.commons.util.StatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.UIType;
import oracle.install.commons.util.exception.Advice;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.driver.oui.OUIExitStatus;
import oracle.install.driver.oui.OUILogHandler;
import oracle.install.ivw.common.resource.CommonErrorCode;
import oracle.install.ivw.common.util.CloneCommandLineArgHelpConstructorImpl;
import oracle.install.ivw.common.validator.BaseInstallLocationValidator;
import oracle.install.ivw.db.resource.DBErrorCode;
import oracle.install.library.util.InventoryInfo;
import oracle.install.library.util.MachineInfo;
import oracle.install.library.util.OFAWrapper;
import oracle.install.library.util.PlatformInfo;
import oracle.install.library.util.WinHelper;
import oracle.ops.mgmt.cluster.Version;
import oracle.sysman.oii.oiio.oiiol.OiiolLoggerUtil;
import oracle.sysman.oii.oiix.OiixNetOps;

public class OracleCloner
extends Cloner {
    public static final String CLI_CONFIG_XML = "/oracle/install/driver/oui/resource/install_cli_args.xml";
    public static final String APPLICATION_CONFIG = "/oracle/install/ivw/common/util/clone-application-config.xml";
    private Logger logger = Logger.getLogger(OracleCloner.class.getName());

    protected void processArguments(List<String> args) throws IllegalArgumentException {
        CommandLineArgumentHandler cmdlineArgHandler = CommandLineArgumentHandler.getInstance();
        boolean skipCLIValidator = Boolean.getBoolean("application.commandline.skipCLIValidator");
        if (!skipCLIValidator) {
            cmdlineArgHandler.processCommandLineArguments(args, skipCLIValidator);
        } else {
            this.logger.log(Level.INFO, "Skipping command line argument validation");
        }
        if (cmdlineArgHandler.isArgumentPassed("help")) {
            this.showUsage();
            this.shutdown();
        }
        this.setUIType(UIType.NONE);
        super.processArguments(args);
    }

    public OracleCloner() {
        this.init();
    }

    protected void init() {
        SetupDriver.registerDriver((String)"oracle.install.ivw.common.driver.OracleCloneDriver");
        CommandLineArgumentHandler.registerSupportedCommandtArgsXML((String)CLI_CONFIG_XML);
        System.setProperty("application.commandline.validateForMandatoryDependentArgs", "true");
        System.setProperty("application.commandline.toolName", "clone.pl");
        System.setProperty("application.commandline.currentContextId", "Clone");
        System.setProperty(CommandLineArgHelpConstructorImpl.class.getName(), CloneCommandLineArgHelpConstructorImpl.class.getName());
    }

    protected void run() {
        final SetupDriver setupDriver = SetupDriver.getInstance();
        try {
            if (!InventoryInfo.getInstance().isInventoryExist()) {
                String timeStamp = OiiolLoggerUtil.getTimeStamp();
                String logName = "cloneActions" + timeStamp + ".log";
                OUILogHandler.setLogFileName((String)logName);
            }
            this.logger.log(Level.INFO, "Loading Setup Driver");
            setupDriver.load();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        OracleCloner.this.logger.log(Level.INFO, "Unloading Setup Driver");
                        setupDriver.unload();
                    }
                    catch (Exception e) {
                        OracleCloner.this.logger.log(Level.SEVERE, e.getMessage());
                    }
                }
            });
            List args = Application.getInstance().getArguments();
            this.validateArguments(args);
            this.logger.log(Level.INFO, "Calling setupDriver.setup..");
            setupDriver.setup();
        }
        catch (SetupDriverException e) {
            this.logger.log(Level.SEVERE, e.getMessage());
        }
        super.run();
        this.shutdown();
    }

    public void startup(String ... args) {
        try {
            super.startup(APPLICATION_CONFIG, args);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.log(Level.SEVERE, e.getMessage());
        }
    }

    public void validateArguments(List<String> args) {
        boolean dbCompDirExists;
        StatusMessages messages = new StatusMessages();
        CommandLineArgumentHandler cmdlineArgHandler = CommandLineArgumentHandler.getInstance();
        String oracleHome = null;
        if (cmdlineArgHandler.isArgumentPassed("ORACLE_HOME")) {
            oracleHome = cmdlineArgHandler.getArgumentValue("ORACLE_HOME");
        }
        String oracleBase = null;
        if (cmdlineArgHandler.isArgumentPassed("ORACLE_BASE")) {
            oracleBase = cmdlineArgHandler.getArgumentValue("ORACLE_BASE");
        }
        String oracleServiceUserName = null;
        if (cmdlineArgHandler.isArgumentPassed("ORACLE_HOME_USER")) {
            oracleServiceUserName = cmdlineArgHandler.getArgumentValue("ORACLE_HOME_USER");
        }
        boolean isVirtualAccount = false;
        if (cmdlineArgHandler.isArgumentPassed("virtualAccount")) {
            isVirtualAccount = true;
        }
        String clusterNodesSpecified = null;
        if (cmdlineArgHandler.isArgumentPassed("CLUSTER_NODES")) {
            clusterNodesSpecified = cmdlineArgHandler.getArgumentValue("CLUSTER_NODES");
        }
        String localNodeName = OiixNetOps.getMachineName((String)PlatformInfo.getInstance().getFullHostName());
        if (clusterNodesSpecified != null && !clusterNodesSpecified.toLowerCase().contains(localNodeName.toLowerCase())) {
            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.CLONE_LOCAL_NODE_NOT_PASSED, new Object[0]));
        }
        if (clusterNodesSpecified != null) {
            String[] clusterNodes = clusterNodesSpecified.substring(1, clusterNodesSpecified.length() - 1).split(",");
            ArrayList<String> invalidNodes = new ArrayList<String>();
            for (int i = 0; i < clusterNodes.length; ++i) {
                try {
                    String ipAddress = MachineInfo.getInstance().getIPAddressForHostName(clusterNodes[i]);
                    continue;
                }
                catch (UnknownHostException e) {
                    this.logger.log(Level.INFO, "Cluster Node :(" + clusterNodes[i] + ")is not resolvable to a ip address");
                    invalidNodes.add(clusterNodes[i]);
                }
            }
            if (invalidNodes.size() > 0) {
                messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.CLONE_CLUSTER_NODE_PASSED_NOT_VALID, new Object[]{invalidNodes}));
            }
        }
        messages.addAll(this.validateOracleHome(oracleHome));
        String crsComp = oracleHome + File.separator + "inventory" + File.separator + "Components21" + File.separator + "oracle.crs";
        File crsCompDir = new File(crsComp);
        boolean crsCompDirExists = crsCompDir.exists();
        messages.addAll(this.validateOracleBase(oracleBase, crsCompDirExists));
        String dbComp = oracleHome + File.separator + "inventory" + File.separator + "Components21" + File.separator + "oracle.server";
        File dbCompDir = new File(dbComp);
        boolean bl = dbCompDirExists = dbCompDir.exists();
        if (PlatformInfo.getInstance().isWindows()) {
            WinHelper WinHelper2;
            boolean exists;
            if (dbCompDirExists) {
                if (isVirtualAccount) {
                    if (oracleServiceUserName != null && oracleServiceUserName.length() > 0) {
                        messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.VIRTUAL_ACCOUNT_USER_NOT_SUPPORTED, new Object[0]));
                    }
                    if (!WinHelper.isVirtualAccountUserTypeSupportedOnCurrentOS()) {
                        messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)DBErrorCode.INSTALL_VIRTUAL_ACCOUNT_USER_NOT_SUPPORTED_ON_CURRENT_OS, new Object[0]));
                    }
                    if (clusterNodesSpecified != null && clusterNodesSpecified.length() > 0) {
                        messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)DBErrorCode.INSTALL_VIRTUAL_ACCOUNT_USER_NOT_SUPPORTED_ON_RAC, new Object[0]));
                    }
                    if (oracleBase != null && oracleBase.length() > 0 && (exists = new File(oracleBase).exists())) {
                        WinHelper2 = new WinHelper();
                        if (!WinHelper.userOwnsSpecifiedBase("", oracleBase, false, true)) {
                            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_HOME_USER_NOT_OWNER_OF_SPECIFIED_OB, new Object[0]));
                        }
                    }
                }
            } else if (isVirtualAccount) {
                messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.VIRTUAL_ACCOUNT_USER_NOT_SUPPORTED, new Object[0]));
            }
            if (oracleServiceUserName != null && oracleServiceUserName.length() > 0) {
                if (oracleHome != null && oracleHome.length() > 0) {
                    Version m_version = new Version();
                    try {
                        Credentials m_cred = new Credentials(oracleServiceUserName);
                        WinSecurityFactory m_winSecFactory = WinSecurityFactory.getInstance((String)(oracleHome + File.separator + "bin"), null);
                        User m_user = m_winSecFactory.getUser(m_cred, m_version);
                        if (!m_user.isExists()) {
                            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_SPECIFIED_USER_DOESNOT_EXISTS, new Object[0]));
                        }
                    }
                    catch (WindowsSecurityException e) {
                        this.logger.log(Level.INFO, "Error while checking for the user existence during clone", e);
                    }
                }
                if (!oracleServiceUserName.equals(Credentials.BuiltinUser.LOCALSYSTEM.toString()) && !oracleServiceUserName.equals(Credentials.BuiltinUser.LOCALSERVICE.toString())) {
                    if (oracleBase != null && oracleBase.length() > 0 && (exists = new File(oracleBase).exists())) {
                        WinHelper2 = new WinHelper();
                        if (!WinHelper.userOwnsSpecifiedBase(oracleServiceUserName, oracleBase, false)) {
                            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_HOME_USER_NOT_OWNER_OF_SPECIFIED_OB, new Object[0]));
                        }
                    }
                    if (crsCompDirExists) {
                        boolean isAdministrator;
                        boolean isDomainUser = WinHelper.isDomainUser(oracleServiceUserName, "");
                        if (!isDomainUser) {
                            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_NO_DOMAIN_USER, new Object[]{oracleServiceUserName}));
                        }
                        if (isAdministrator = WinHelper.isAdministrator(oracleServiceUserName, "")) {
                            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_ADMINISTRATOR_USER, new Object[]{oracleServiceUserName}));
                        }
                    }
                }
            }
        } else if (isVirtualAccount) {
            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.VIRTUAL_ACCOUNT_USER_NOT_SUPPORTED, new Object[0]));
        }
        if (messages.size() > 0) {
            Advice advice = ExceptionManager.advise((StatusMessages)messages);
            if (advice == Advice.ABORT || advice == Advice.WITHDRAW) {
                this.logger.log(Level.WARNING, "Advised to terminate the execution: " + advice.toString());
                this.shutdown((ExitStatus)OUIExitStatus.VAR_VALIDATION_FAILURE);
            } else {
                this.logger.log(Level.WARNING, "Advised to ignore error messages: " + advice.toString());
            }
        }
    }

    private StatusMessages<ValidationStatusMessage> validateOracleBase(String oracleBase, boolean isCRSHome) {
        File obFile;
        StatusMessages messages = new StatusMessages();
        String oraLocText = Application.getInstance().getProperty(ResourceURL.resURL((String)"oracle.install.ivw.common.resource.CommonDialogLabelResID", (String)"INSTALL_COMMON_ORACLE_BASE_LABEL2"), new Object[0]);
        messages.addAll(this.validateAbsoluteAndCanonicalPath(oracleBase, oraLocText));
        messages.addAll(BaseInstallLocationValidator.validateOracleBase(oracleBase));
        if (messages.isEmpty() && isCRSHome && (obFile = new File(oracleBase)).exists() && obFile.isDirectory() && obFile.canWrite() && obFile.list().length > 0) {
            this.logger.log(Level.INFO, "The oracle base is not empty: " + oracleBase);
            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_ORACLE_BASE_NOT_EMPTY, new Object[0]));
        }
        return messages;
    }

    private StatusMessages<ValidationStatusMessage> validateOracleHome(String oracleHome) {
        StatusMessages messages = new StatusMessages();
        String oraLocText = Application.getInstance().getProperty(ResourceURL.resURL((String)"oracle.install.ivw.common.resource.CommonDialogLabelResID", (String)"INSTALL_COMMON_ORACLE_HOME_LOCATION_LABEL"), new Object[0]);
        messages.addAll(this.validateAbsoluteAndCanonicalPath(oracleHome, oraLocText));
        try {
            BaseInstallLocationValidator.validateLocation(oracleHome, oraLocText);
        }
        catch (ValidationException e) {
            messages.add((StatusMessage)new ValidationStatusMessage((Throwable)e));
        }
        return messages;
    }

    private StatusMessages<ValidationStatusMessage> validateAbsoluteAndCanonicalPath(String path, String label) {
        StatusMessages messages = new StatusMessages();
        boolean isWindows = PlatformInfo.getInstance().isWindows();
        File pathFile = new File(path);
        if (!pathFile.isAbsolute()) {
            messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_PATH_NOT_ABSOLUTE, new Object[]{label, path}));
        } else {
            boolean pathCreated = false;
            if (!pathFile.exists()) {
                this.logger.log(Level.INFO, "Path " + path + " does not exist, creating it.");
                pathCreated = pathFile.mkdirs();
                if (!pathCreated) {
                    this.logger.log(Level.WARNING, "Could not create path: " + path);
                } else {
                    this.logger.log(Level.INFO, "Created path: " + path);
                }
            } else {
                this.logger.log(Level.INFO, "Path " + path + " already exists.");
            }
            if (pathCreated || pathFile.exists()) {
                boolean isCanonical = true;
                String canonicalPath = null;
                try {
                    canonicalPath = pathFile.toPath().toRealPath(LinkOption.NOFOLLOW_LINKS).toString();
                }
                catch (Exception e) {
                    this.logger.log(Level.WARNING, "Could not get the canonical path of the provided oracle home: " + path, e);
                    messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_PATH_CANNOT_GET_CANONICAL, new Object[]{label, path}));
                    isCanonical = false;
                }
                if (canonicalPath != null && (isWindows && !canonicalPath.equalsIgnoreCase(path) || !isWindows && !canonicalPath.equals(path))) {
                    messages.add((StatusMessage)new ValidationStatusMessage((ErrorCode)CommonErrorCode.INSTALL_COMMON_PATH_NOT_CANONICAL, new Object[]{label, path, canonicalPath}));
                    isCanonical = false;
                }
                if (pathCreated && !isCanonical) {
                    pathFile.delete();
                }
            }
        }
        return messages;
    }

    public static void main(String[] args) {
        try {
            OracleCloner oracleCloner = (OracleCloner)Application.getInstance(OracleCloner.class);
            PlatformInfo platInfo = PlatformInfo.getInstance();
            ArrayList<String> argList = new ArrayList<String>();
            if (platInfo.isWindows()) {
                boolean isLocalSystem = true;
                boolean isVirtualUser = false;
                if (args != null) {
                    for (int index = 0; index < args.length; ++index) {
                        String tempArg;
                        if (args[index].startsWith("ORACLE_HOME_USER")) {
                            tempArg = null;
                            String[] temp = args[index].split("=");
                            tempArg = "oracle_install_OracleHomeUserName=" + temp[1];
                            isLocalSystem = false;
                            argList.add(tempArg);
                        }
                        if (args[index].startsWith("ORACLE_BASE")) {
                            tempArg = null;
                            String[] ob = args[index].split("=");
                            tempArg = "oracle_install_isExistingBase=" + OFAWrapper.getInstance().isExistingBase(ob[1]);
                            argList.add(tempArg);
                        }
                        if (args[index].startsWith("oracle_install_IsVirtualAccount")) {
                            isVirtualUser = true;
                        }
                        argList.add(args[index]);
                    }
                }
                if (isLocalSystem && !isVirtualUser) {
                    argList.add("oracle_install_OracleHomeUserName=" + Credentials.BuiltinUser.LOCALSYSTEM.toString());
                    argList.add("oracle_install_IsOracleServiceUserExists=true");
                    argList.add("oracle_install_IsBuiltInAccount=true");
                    argList.add("oracle_install_OracleSVCUserPWDReq=false");
                } else {
                    argList.add("oracle_install_IsOracleServiceUserExists=true");
                    argList.add("oracle_install_IsBuiltInAccount=false");
                    argList.add("oracle_install_OracleSVCUserPWDReq=true");
                }
                String localUser = System.getProperty("user.name");
                String domainUser = null;
                if (System.getenv("USERDOMAIN") != null) {
                    domainUser = System.getenv("USERDOMAIN") + "\\" + System.getProperty("user.name");
                }
                if (domainUser != null && WinHelper.isDomainUser(domainUser, "")) {
                    argList.add("oracle_install_installUser=" + domainUser);
                } else {
                    argList.add("oracle_install_installUser=" + localUser);
                }
            } else if (args != null && args.length > 0) {
                for (String arg : args) {
                    argList.add(arg);
                }
            }
            argList.add("oracle_install_isHostExadata=" + MachineInfo.getInstance().isHostExadata());
            String[] argCopy = argList.toArray(new String[0]);
            oracleCloner.startup(argCopy);
        }
        catch (Exception e) {
            ExceptionManager.handle((Throwable)e);
        }
    }
}

