/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.install.ivw.crs.bean.CRSInstallSettings;
import oracle.install.library.util.MachineInfo;
import oracle.install.library.util.cluster.ClusterConfig;
import oracle.install.library.util.cluster.ClusterNode;
import oracle.install.library.util.cluster.ClusterSupport;

public class ActionableValidationHelper {
    private static Logger logger = Logger.getLogger(ActionableValidationHelper.class.getName());

    public static void removeBadNodes(List<String> badNodeNameList, CRSInstallSettings bean) {
        logger.entering(ActionableValidationHelper.class.getName(), "removeBadNodes", badNodeNameList);
        if (badNodeNameList != null && !badNodeNameList.isEmpty() && bean != null) {
            ArrayList<ClusterNode> badClusterNodes = null;
            ArrayList<String> badRemoteNodes = new ArrayList<String>();
            badClusterNodes = new ArrayList<ClusterNode>();
            ClusterConfig cconfig = bean.getClusterConfig();
            String localNode = MachineInfo.getInstance().getLocalMachineName();
            logger.info("Local Node Name : " + localNode);
            for (String badNode : badNodeNameList) {
                if (localNode.equalsIgnoreCase(badNode)) continue;
                ClusterNode clusterNode = cconfig.getClusterNode(badNode, false);
                if (clusterNode != null) {
                    badClusterNodes.add(clusterNode);
                }
                badRemoteNodes.add(badNode);
            }
            if (badClusterNodes != null && !badClusterNodes.isEmpty()) {
                logger.info("Removing problematic nodes from the selected nodes.");
                cconfig.removeClusterNodes(badClusterNodes);
                logger.info("Node list after removing problematic nodes : " + bean.getClusterConfig().getPublicNodeNames(false));
            }
            ClusterSupport.getInstance().addBadClusterNodes(badRemoteNodes);
        }
        logger.exiting(ActionableValidationHelper.class.getName(), "removeBadNodes");
    }
}

