/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.validator;

import java.util.logging.Logger;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.validation.CompositeValidator;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.flow.validation.ValidationStatusMessage;
import oracle.install.commons.util.StatusMessages;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.ivw.common.bean.InstallSettings;
import oracle.install.ivw.common.bean.WindowsSecureOptionSettings;
import oracle.install.ivw.common.resource.CommonErrorCode;
import oracle.install.library.util.GenericValidation;
import oracle.install.library.util.WinHelper;

public class WindowsSecureOptionValidator
implements CompositeValidator {
    public static final Logger logger = Logger.getLogger(WindowsSecureOptionValidator.class.getName());

    public void validate(FlowContext flowContext) throws ValidationException {
        boolean b_validatePasswordEmptiness = true;
        this.winsec_validate(flowContext, b_validatePasswordEmptiness);
    }

    public void validate(FlowContext flowContext, boolean b_validatePasswordEmpty) throws ValidationException {
        this.winsec_validate(flowContext, b_validatePasswordEmpty);
    }

    public void winsec_validate(FlowContext flowContext, boolean b_validatePasswordEmptiness) throws ValidationException {
        WindowsSecureOptionSettings secureBean = (WindowsSecureOptionSettings)((Object)flowContext.getBean(WindowsSecureOptionSettings.class));
        InstallSettings installBean = (InstallSettings)((Object)flowContext.getBean(InstallSettings.class));
        String userName = secureBean.getUserName();
        String password = secureBean.getPassword();
        if (!secureBean.isDeclineOption() && !secureBean.isVirtualUser()) {
            if (userName == null || userName.equals("")) {
                throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_NO_USERNAME_SPECIFIED, new Object[0]);
            }
            WinHelper WinHelper2 = new WinHelper();
            boolean m_userExists = WinHelper.UserExists(userName, password);
            if (!secureBean.isExistingUser()) {
                if (password == null || password.equals("")) {
                    throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_NO_PASSWORD_SPECIFIED, new Object[0]);
                }
                if (m_userExists) {
                    throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_SPECIFIED_USER_EXISTS, new Object[0]);
                }
                boolean isValidPassword = WinHelper.isValidPassword(userName, password);
                if (!isValidPassword) {
                    throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_SPECIFIED_INVALID_PASSWORD, new Object[0]);
                }
                boolean isDomainUser = WinHelper.isDomainUser(userName, password);
                WindowsSecureOptionValidator.validateUserName(userName);
            } else {
                boolean validUser = false;
                boolean isAdministrator = false;
                boolean isMSAUser = WinHelper.isMSAUser(userName, password);
                boolean isGMSAUser = WinHelper.isGMSAUser(userName);
                if (b_validatePasswordEmptiness && !isMSAUser && !isGMSAUser && (password == null || password.equals(""))) {
                    throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_NO_PASSWORD_SPECIFIED, new Object[0]);
                }
                if (!m_userExists) {
                    throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_SPECIFIED_USER_DOESNOT_EXISTS, new Object[0]);
                }
                if (b_validatePasswordEmptiness && !isMSAUser && !isGMSAUser) {
                    validUser = WinHelper.isValidUser(userName, password);
                    if (!validUser) {
                        throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_NOT_VALID_USER, new Object[]{userName});
                    }
                }
                if (isAdministrator = WinHelper.isAdministrator(userName, password)) {
                    throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_ADMINISTRATOR_USER, new Object[]{userName});
                }
            }
        }
    }

    public static void validateUserName(String userName) throws ValidationException {
        StatusMessages messages = new StatusMessages();
        String strBadChars = "\\\"/[]:;|=,+*?<>";
        String strBadCharsFound = null;
        strBadCharsFound = GenericValidation.validateBadCharGetString(strBadChars, userName);
        if (strBadCharsFound != null && !strBadCharsFound.equals("")) {
            throw new ValidationException((ErrorCode)CommonErrorCode.INSTALL_COMMON_USER_NAME_HAS_INVALID_CHAR_ERR, new Object[]{userName});
        }
    }

    public StatusMessages<ValidationStatusMessage> getValidationStatusMessages() {
        return null;
    }
}

