/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.install.commons.base.summary.Summary;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.driver.oui.util.SetupSummary;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class FinishPane
extends JPanel {
    private MultiLineLabel lblMessage;
    private JLabel lblMessage2;
    private JTextArea textArea;
    private JScrollPane scrollPane;
    private PropertyChangeListener setupSummaryPropertyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            FinishPane.this.reloadText();
        }
    };
    private SetupSummary summary;
    private static final Logger logger = Logger.getLogger(FinishPane.class.getName());
    private static Resource resource = Application.getInstance().getResource("oracle.install.ivw.common.resource.CommonDialogLabelResID");
    public static final String S_RESOURCE_BUNDLE = "oracle.sysman.oii.oiir.OiirRuntimeRes";
    public static final String SESSION_SUCCESS = OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_SESSION_SUCCESS");
    public static final String SUCCESS_MINUS_REMOTE = OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"OIIFW1203");
    public static final String SUCCESS_MINUS_CONFIGTOOLS = OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_SESSION_SUCCESS_MINUS_CONFIGTOOLS");
    public static final String SESSION_FAILURE = OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_SESSION_FAILURE");
    public static final String TYPE_INSTALL = resource.getString("INSTALL_COMMON_FINISH_PAGE_INSTALLATION", "installation", new Object[0]);
    public static final String TYPE_UPGRADE = resource.getString("INSTALL_COMMON_FINISH_PAGE_UPGRADE", "upgrade", new Object[0]);
    public static final String TYPE_CONFIG = resource.getString("INSTALL_COMMON_FINISH_PAGE_CONFIGURATION", "configuration", new Object[0]);
    public static final String TYPE_REGISTER = resource.getString("INSTALL_COMMON_FINISH_PAGE_REGISTRATION", "registration", new Object[0]);
    public static final String TYPE_ADDNODE = resource.getString("ADDNODE_FINISH_PAGE_MESSAGE", "node addition", new Object[0]);
    public static final String TYPE_DELETENODE = resource.getString("DELETENODE_FINISH_PAGE_MESSAGE", "node deletion", new Object[0]);

    public FinishPane() {
        this.buildUI();
    }

    private void buildUI() {
        this.lblMessage = new MultiLineLabel(WordWrapper.getTextWrapper(), "");
        this.lblMessage2 = new JLabel();
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.scrollPane = new JScrollPane(this.textArea);
        this.setLayout(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.lblMessage, (Container)this, (int)0, (int)0, (int)2, (int)1, (int)2, (int)17, (double)0.0, (double)0.0, (Insets)new Insets(5, 5, 5, 5));
        LayoutUtils.addComponent((Component)this.lblMessage2, (Container)this, (int)0, (int)1, (int)1, (int)1, (int)2, (int)17, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)Box.createGlue(), (Container)this, (int)0, (int)2, (int)1, (int)1, (int)1, (int)17, (double)1.0, (double)1.0);
        LayoutUtils.addComponent((Component)this.scrollPane, (Container)this, (int)0, (int)2, (int)2, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (Insets)new Insets(5, 5, 5, 5));
        this.setVisible(true);
    }

    public void setStatusText(String text) {
        this.lblMessage.setText(text);
    }

    public void toggleTextArea() {
        String text = this.textArea.getText();
        if (text == null || text.trim().length() == 0) {
            this.scrollPane.setVisible(false);
            this.lblMessage2.setVisible(false);
        } else {
            this.scrollPane.setVisible(true);
            this.lblMessage2.setVisible(true);
        }
    }

    public String calculateSessionStatus(Summary summary) {
        String status = SESSION_SUCCESS;
        boolean instSuccess = summary.isSuccessfullInstall();
        boolean toolSuccess = summary.isSuccessfulConfig();
        boolean instRemoteSuccess = summary.isSuccessfullRemoteInstall();
        logger.info("Install Succeeded: " + instSuccess);
        logger.info("Config Tool Succeeded: " + toolSuccess);
        logger.info("Remote Install Succeeded: " + instRemoteSuccess);
        if (instSuccess) {
            if (!instRemoteSuccess) {
                status = SUCCESS_MINUS_REMOTE;
            }
            if (!toolSuccess) {
                status = SUCCESS_MINUS_CONFIGTOOLS;
            }
        } else {
            status = SESSION_FAILURE;
        }
        return status;
    }

    public void setTextArea(String endMsgs) {
        this.textArea.setEditable(true);
        this.textArea.setText(endMsgs);
        this.lblMessage2.setText(resource.getString("EndOfInstallMessage.Note", "Note", new Object[0]));
        this.lblMessage2.setVisible(true);
        this.scrollPane.setVisible(true);
        this.textArea.setEditable(false);
    }

    public void setInstallMessages(SetupSummary summary) {
        if (this.summary != summary) {
            this.summary = summary;
            this.summary.addPropertyChangeListener("SetupSummary.ready", this.setupSummaryPropertyListener);
            this.reloadText();
        }
    }

    public void reloadText() {
        String endMsg;
        if (this.summary != null && (endMsg = this.summary.getText()) != null && endMsg.length() > 0) {
            this.setTextArea(endMsg);
        }
    }
}

