/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.swing.WholeNumberField;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.ivw.common.bean.HttpProxySettings;

public class ProxySettingsDialog
extends JDialog {
    private JPanel panel;
    private MultiLineLabel lblProxyDetails;
    private JTextField txtProxyServer;
    private JTextField txtProxyRealm;
    private JLabel lblProxyServer;
    private JLabel lblProxyRealm;
    private JTextField txtProxyUserName;
    private JLabel lblProxyUserName;
    private JPasswordField txtProxyPassword;
    private JLabel lblProxyPassword;
    private WholeNumberField txtProxyPort;
    private JLabel lblProxyPort;
    private JButton btnOk;
    private JButton btnCancel;
    private Logger logger = Logger.getLogger(ProxySettingsDialog.class.getName());
    private Frame owner;
    HttpProxySettings proxySettings;

    protected ProxySettingsDialog(Frame owner, HttpProxySettings proxySettings) {
        super(owner);
        this.setName(ProxySettingsDialog.class.getName());
        if (proxySettings != null) {
            this.proxySettings = proxySettings;
        }
        this.owner = owner;
        this.buildUI();
    }

    private void localize() {
        Application application = Application.getInstance();
        Resource resource = application.getResource("oracle.install.ivw.common.resource.AutoUpdatesDialogLabelResID");
        this.setTitle(resource.getString("ProxySettingsDialog.title", "Proxy Settings", new Object[0]));
        String text = resource.getString("ProxySettingsDialog.ok", "&OK", new Object[0]);
        SwingUtils.setText((AbstractButton)this.btnOk, (String)text);
        text = resource.getString("ProxySettingsDialog.cancel", "&Cancel", new Object[0]);
        SwingUtils.setText((AbstractButton)this.btnCancel, (String)text);
        text = resource.getString("ProxySettingsDialog.proxyPassword", "Proxy pass&word:", new Object[0]);
        SwingUtils.setText((JLabel)this.lblProxyPassword, (String)text);
        this.lblProxyPassword.setLabelFor(this.txtProxyPassword);
        text = resource.getString("ProxySettingsDialog.proxyUserName", "Proxy u&sername:", new Object[0]);
        SwingUtils.setText((JLabel)this.lblProxyUserName, (String)text);
        this.lblProxyUserName.setLabelFor(this.txtProxyUserName);
        text = resource.getString("ProxySettingsDialog.proxyServer", "Proxy ser&ver:", new Object[0]);
        SwingUtils.setText((JLabel)this.lblProxyServer, (String)text);
        this.lblProxyServer.setLabelFor(this.txtProxyServer);
        text = resource.getString("ProxySettingsDialog.proxyPortNumber", "Proxy po&rt number:", new Object[0]);
        SwingUtils.setText((JLabel)this.lblProxyPort, (String)text);
        this.lblProxyPort.setLabelFor((Component)this.txtProxyPort);
        text = resource.getString("ProxySettingsDialog.proxyRealm", "Proxy rea&lm:", new Object[0]);
        SwingUtils.setText((JLabel)this.lblProxyRealm, (String)text);
        this.lblProxyRealm.setLabelFor(this.txtProxyRealm);
        text = resource.getString("ProxySettingsDialog.proxyDesc", "The following fields enable Oracle Installer to connect to MyOracleSupport via a secure connection.", new Object[0]);
        this.lblProxyDetails.setText(text);
    }

    protected void acceptInput() {
        this.logger.log(Level.INFO, "Proxy Settings values accepted");
        HttpProxySettings settings = null;
        if (this.txtProxyServer.getText() != null && this.txtProxyServer.getText().length() > 0 || this.txtProxyPassword.getPassword() != null && this.txtProxyPassword.getPassword().length > 0 || this.txtProxyUserName.getText() != null && this.txtProxyUserName.getText().length() > 0 || this.txtProxyRealm.getText() != null && this.txtProxyRealm.getText().length() > 0 || this.txtProxyPort.getValue() != 0) {
            settings = new HttpProxySettings();
            settings.setHttpProxyHost(this.txtProxyServer.getText());
            settings.setHttpProxyPassword(new String(this.txtProxyPassword.getPassword()));
            settings.setHttpProxyPort(this.txtProxyPort.getValue());
            settings.setHttpProxyUserId(this.txtProxyUserName.getText());
            settings.setHttpProxyRealm(this.txtProxyRealm.getText());
        }
        this.proxySettings = settings;
        this.dispose();
    }

    protected void discardInput() {
        this.dispose();
    }

    public void buildUI() {
        this.logger.log(Level.INFO, "In createAndShowGUI method of ProxySettingsDialog");
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        JPanel proxyPanel = new JPanel();
        proxyPanel.setLayout(new GridBagLayout());
        this.btnOk = new JButton();
        this.btnOk.setName("ProxySettingsDialog.btnOk");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProxySettingsDialog.this.acceptInput();
            }
        });
        this.btnCancel = new JButton();
        this.btnCancel.setName("ProxySettingsDialog.btnCancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProxySettingsDialog.this.discardInput();
            }
        });
        this.txtProxyPassword = new JPasswordField();
        this.txtProxyPassword.setColumns(20);
        this.txtProxyPort = new WholeNumberField();
        this.txtProxyPort.setColumns(20);
        this.txtProxyServer = new JTextField(20);
        this.txtProxyUserName = new JTextField(20);
        this.txtProxyRealm = new JTextField(20);
        this.lblProxyDetails = new MultiLineLabel(WordWrapper.getTextWrapper(), "");
        this.lblProxyServer = new JLabel();
        this.lblProxyPort = new JLabel();
        this.lblProxyUserName = new JLabel();
        this.lblProxyPassword = new JLabel();
        this.lblProxyRealm = new JLabel();
        LayoutUtils.addComponent((Component)this.lblProxyDetails, (Container)proxyPanel, (int)0, (int)0, (int)2, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.lblProxyServer, (Container)proxyPanel, (int)0, (int)1, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.txtProxyServer, (Container)proxyPanel, (int)1, (int)1, (int)1, (int)1, (int)0, (int)18, (double)1.0, (double)0.0, (Insets)new Insets(5, 5, 5, 0));
        LayoutUtils.addComponent((Component)this.lblProxyPort, (Container)proxyPanel, (int)0, (int)2, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.txtProxyPort, (Container)proxyPanel, (int)1, (int)2, (int)1, (int)1, (int)0, (int)18, (double)1.0, (double)0.0, (Insets)new Insets(0, 5, 5, 0));
        LayoutUtils.addComponent((Component)this.lblProxyUserName, (Container)proxyPanel, (int)0, (int)3, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.txtProxyUserName, (Container)proxyPanel, (int)1, (int)3, (int)1, (int)1, (int)0, (int)18, (double)1.0, (double)0.0, (Insets)new Insets(0, 5, 5, 0));
        LayoutUtils.addComponent((Component)this.lblProxyPassword, (Container)proxyPanel, (int)0, (int)4, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.txtProxyPassword, (Container)proxyPanel, (int)1, (int)4, (int)1, (int)1, (int)0, (int)18, (double)1.0, (double)0.0, (Insets)new Insets(0, 5, 5, 0));
        LayoutUtils.addComponent((Component)this.lblProxyRealm, (Container)proxyPanel, (int)0, (int)5, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.txtProxyRealm, (Container)proxyPanel, (int)1, (int)5, (int)1, (int)1, (int)0, (int)18, (double)1.0, (double)0.0, (Insets)new Insets(0, 5, 5, 0));
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.btnOk, (Container)buttonsPanel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)13, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.btnCancel, (Container)buttonsPanel, (int)1, (int)0, (int)1, (int)1, (int)0, (int)13, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)proxyPanel, (Container)this.panel, (int)0, (int)0, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        LayoutUtils.addComponent((Component)buttonsPanel, (Container)this.panel, (int)0, (int)1, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0);
        this.getContentPane().add(this.panel);
        this.localize();
        this.setProxySettings(this.proxySettings);
        this.pack();
        this.setLocationRelativeTo(this.owner);
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setVisible(true);
    }

    public HttpProxySettings getProxySettings() {
        return this.proxySettings;
    }

    private void setProxySettings(HttpProxySettings proxy) {
        if (proxy != null) {
            if (proxy.getHttpProxyHost() != null && proxy.getHttpProxyHost().length() > 0) {
                this.txtProxyServer.setText(proxy.getHttpProxyHost());
            }
            if (proxy.getHttpProxyPassword() != null && proxy.getHttpProxyPassword().length() > 0) {
                this.txtProxyPassword.setText(proxy.getHttpProxyPassword());
            }
            if (proxy.getHttpProxyUserId() != null && proxy.getHttpProxyUserId().length() > 0) {
                this.txtProxyUserName.setText(proxy.getHttpProxyUserId());
            }
            if (proxy.getHttpProxyRealm() != null && proxy.getHttpProxyRealm().length() > 0) {
                this.txtProxyRealm.setText(proxy.getHttpProxyRealm());
            }
            if (proxy.getHttpProxyPort() != 0) {
                this.txtProxyPort.setText(Integer.toString(proxy.getHttpProxyPort()));
            }
            this.proxySettings = proxy;
        }
    }
}

