/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.common.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import oracle.install.commons.activehelp.ActiveHelpManager;
import oracle.install.commons.base.util.cli.CommandLineArgumentHandler;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.MultilineLabel;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.swing.TogglePane;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.ivw.common.bean.RootConfigurationSettings;

public class RootConfigurationMethodPane
extends JPanel {
    private MultilineLabel lblDescription;
    private JLabel lblRootPassword;
    private JLabel lblSudoPath;
    private JLabel lblSudoUser;
    private JLabel lblSudoPassword;
    private JLabel lblPBPath;
    private JLabel lblPBUser;
    private JLabel lblPBPassword;
    private JRadioButton rdoUseRoot;
    private JRadioButton rdoUseSudo;
    private JRadioButton rdoUsePB;
    private JCheckBox cbxRunConfigScripts;
    private JPasswordField rootPassword;
    private JPasswordField sudoPassword;
    private JPasswordField pbPassword;
    private JTextField txtSudoPath;
    private JTextField txtSudoUser;
    private JTextField txtPBPath;
    private JTextField txtPBUser;
    private JButton btnBrowseSudoPath;
    private JButton btnBrowsePBPath;
    private JFileChooser fileChooser;
    private JPanel configMethodPane;
    private Resource resource;
    private boolean disableSudoUser;

    public RootConfigurationMethodPane() {
        this.initialize();
        this.buildUI();
        this.addListeners();
        this.resource = Application.getInstance().getResource("oracle.install.ivw.common.resource.CommonDialogLabelResID");
    }

    public void initialize() {
        this.lblDescription = new MultilineLabel();
        this.lblRootPassword = new JLabel();
        this.lblSudoPath = new JLabel();
        this.lblSudoUser = new JLabel();
        this.lblSudoPassword = new JLabel();
        this.lblPBPath = new JLabel();
        this.lblPBUser = new JLabel();
        this.lblPBPassword = new JLabel();
        this.rdoUseRoot = new JRadioButton();
        this.rdoUseSudo = new JRadioButton();
        this.rdoUsePB = new JRadioButton();
        this.cbxRunConfigScripts = new JCheckBox();
        this.rootPassword = new JPasswordField(25);
        this.sudoPassword = new JPasswordField(25);
        this.pbPassword = new JPasswordField(25);
        this.txtSudoPath = new JTextField();
        this.txtSudoUser = new JTextField();
        this.txtPBPath = new JTextField();
        this.txtPBUser = new JTextField();
        this.btnBrowseSudoPath = new JButton();
        this.btnBrowsePBPath = new JButton();
        this.fileChooser = new JFileChooser();
        this.fileChooser.setFileSelectionMode(2);
        this.lblDescription.setName("RootConfigurationMethodPane.lblDescription");
        this.lblRootPassword.setName("RootConfigurationMethodPane.lblRootPassword");
        this.lblSudoPath.setName("RootConfigurationMethodPane.lblSudoPath");
        this.lblSudoUser.setName("RootConfigurationMethodPane.lblSudoUser");
        this.lblSudoPassword.setName("RootConfigurationMethodPane.lblSudoPassword");
        this.lblPBPath.setName("RootConfigurationMethodPane.lblPBPath");
        this.lblPBUser.setName("RootConfigurationMethodPane.lblPBUser");
        this.lblPBPassword.setName("RootConfigurationMethodPane.lblPBPassword");
        this.rdoUseRoot.setName("RootConfigurationMethodPane.rdoUseRoot");
        this.rdoUseSudo.setName("RootConfigurationMethodPane.rdoUseSudo");
        this.rdoUsePB.setName("RootConfigurationMethodPane.rdoUsePB");
        this.cbxRunConfigScripts.setName("RootConfigurationMethodPane.cbxRunConfigScripts");
        this.rootPassword.setName("RootConfigurationMethodPane.rootPassword");
        this.sudoPassword.setName("RootConfigurationMethodPane.sudoPassword");
        this.pbPassword.setName("RootConfigurationMethodPane.pbPassword");
        this.txtSudoPath.setName("RootConfigurationMethodPane.txtSudoPath");
        this.txtSudoUser.setName("RootConfigurationMethodPane.txtSudoUser");
        this.txtPBPath.setName("RootConfigurationMethodPane.txtPBPath");
        this.txtPBUser.setName("RootConfigurationMethodPane.txtPBUser");
        this.btnBrowseSudoPath.setName("RootConfigurationMethodPane.btnBrowseSudoPath");
        this.btnBrowsePBPath.setName("RootConfigurationMethodPane.btnBrowsePBPath");
    }

    private void addListeners() {
        this.btnBrowsePBPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = RootConfigurationMethodPane.this.txtPBPath.getText();
                File newFile = RootConfigurationMethodPane.this.showFileChooserFor(path);
                if (newFile != null) {
                    RootConfigurationMethodPane.this.txtPBPath.setText(newFile.getPath());
                }
            }
        });
        this.btnBrowseSudoPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = RootConfigurationMethodPane.this.txtSudoPath.getText();
                File newFile = RootConfigurationMethodPane.this.showFileChooserFor(path);
                if (newFile != null) {
                    RootConfigurationMethodPane.this.txtSudoPath.setText(newFile.getPath());
                }
            }
        });
        this.rdoUseRoot.addItemListener(new ConfigOptionItemListener(RootConfigurationSettings.ConfigMethod.ROOT));
        this.rdoUseSudo.addItemListener(new ConfigOptionItemListener(RootConfigurationSettings.ConfigMethod.SUDO));
        this.rdoUsePB.addItemListener(new ConfigOptionItemListener(RootConfigurationSettings.ConfigMethod.PB));
        this.cbxRunConfigScripts.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected = e.getStateChange() == 1;
                RootConfigurationMethodPane.this.rdoUseRoot.setEnabled(selected);
                RootConfigurationMethodPane.this.rdoUseSudo.setEnabled(selected);
                RootConfigurationMethodPane.this.rdoUsePB.setEnabled(selected);
                if (!selected) {
                    RootConfigurationMethodPane.this.enableCompsForOption(RootConfigurationSettings.ConfigMethod.DEFAULT);
                } else {
                    RootConfigurationSettings.ConfigMethod method = RootConfigurationMethodPane.this.getConfigMethod();
                    if (method != RootConfigurationSettings.ConfigMethod.DEFAULT) {
                        RootConfigurationMethodPane.this.enableCompsForOption(method);
                    } else {
                        RootConfigurationMethodPane.this.rdoUseRoot.setSelected(true);
                    }
                }
            }
        });
    }

    public void buildUI() {
        ButtonGroup btnGroup = new ButtonGroup();
        btnGroup.add(this.rdoUseRoot);
        btnGroup.add(this.rdoUseSudo);
        btnGroup.add(this.rdoUsePB);
        this.lblRootPassword.setLabelFor(this.rootPassword);
        this.lblSudoPath.setLabelFor(this.txtSudoPath);
        this.lblSudoUser.setLabelFor(this.txtSudoUser);
        this.lblSudoPassword.setLabelFor(this.sudoPassword);
        this.lblPBPath.setLabelFor(this.txtPBPath);
        this.lblPBUser.setLabelFor(this.txtPBUser);
        this.lblPBPassword.setLabelFor(this.pbPassword);
        this.setLayout(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.lblDescription, (Container)this, (int)0, (int)0, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)new TogglePane((JToggleButton)this.cbxRunConfigScripts, (Component)this.getConfigMethodsPane()), (Container)this, (int)0, (int)1, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
        LayoutUtils.addComponent((Component)Box.createGlue(), (Container)this, (int)0, (int)10, (int)3, (int)1, (int)2, (int)18, (double)1.0, (double)1.0);
        ActiveHelpManager.registerComponent((JComponent)this.rdoUseRoot, (String)"RootConfigurationMethodPane.rdoUseRoot");
        ActiveHelpManager.registerComponent((JComponent)this.rootPassword, (String)"RootConfigurationMethodPane.rootPassword");
        ActiveHelpManager.registerComponent((JComponent)this.rdoUseSudo, (String)"RootConfigurationMethodPane.rdoUseSudo");
        ActiveHelpManager.registerComponent((JComponent)this.txtSudoPath, (String)"RootConfigurationMethodPane.txtSudoPath");
        ActiveHelpManager.registerComponent((JComponent)this.btnBrowseSudoPath, (String)"RootConfigurationMethodPane.btnBrowseSudoPath");
        ActiveHelpManager.registerComponent((JComponent)this.txtSudoUser, (String)"RootConfigurationMethodPane.txtSudoUser");
        ActiveHelpManager.registerComponent((JComponent)this.sudoPassword, (String)"RootConfigurationMethodPane.sudoPassword");
        ActiveHelpManager.registerComponent((JComponent)this.rdoUsePB, (String)"RootConfigurationMethodPane.rdoUsePB");
        ActiveHelpManager.registerComponent((JComponent)this.txtPBPath, (String)"RootConfigurationMethodPane.txtPBPath");
        ActiveHelpManager.registerComponent((JComponent)this.btnBrowsePBPath, (String)"RootConfigurationMethodPane.btnBrowsePBPath");
        ActiveHelpManager.registerComponent((JComponent)this.txtPBUser, (String)"RootConfigurationMethodPane.txtPBUser");
        ActiveHelpManager.registerComponent((JComponent)this.pbPassword, (String)"RootConfigurationMethodPane.pbPassword");
        ActiveHelpManager.registerComponent((JComponent)this.cbxRunConfigScripts, (String)"RootConfigurationMethodPane.cbxRunConfigScripts");
    }

    private JPanel getConfigMethodsPane() {
        if (this.configMethodPane == null) {
            this.configMethodPane = new JPanel();
            this.configMethodPane.setLayout(new GridBagLayout());
            LayoutUtils.addComponent((Component)this.rdoUseRoot, (Container)this.configMethodPane, (int)0, (int)0, (int)3, (int)1, (int)2, (int)18, (double)0.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
            LayoutUtils.addComponent((Component)this.lblRootPassword, (Container)this.configMethodPane, (int)0, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(5, 35, 5, 5));
            LayoutUtils.addComponent((Component)this.rootPassword, (Container)this.configMethodPane, (int)1, (int)1, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(5, 5, 5, 45));
            LayoutUtils.addComponent((Component)this.rdoUseSudo, (Container)this.configMethodPane, (int)0, (int)2, (int)3, (int)1, (int)2, (int)18, (double)0.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
            LayoutUtils.addComponent((Component)this.lblSudoPath, (Container)this.configMethodPane, (int)0, (int)3, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(5, 35, 5, 5));
            LayoutUtils.addComponent((Component)this.txtSudoPath, (Container)this.configMethodPane, (int)1, (int)3, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0, (Insets)new Insets(5, 5, 5, 5));
            LayoutUtils.addComponent((Component)this.btnBrowseSudoPath, (Container)this.configMethodPane, (int)2, (int)3, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(5, 5, 5, 5));
            LayoutUtils.addComponent((Component)this.lblSudoUser, (Container)this.configMethodPane, (int)0, (int)4, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(5, 35, 5, 5));
            LayoutUtils.addComponent((Component)this.txtSudoUser, (Container)this.configMethodPane, (int)1, (int)4, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(5, 5, 5, 45));
            LayoutUtils.addComponent((Component)this.lblSudoPassword, (Container)this.configMethodPane, (int)0, (int)5, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(5, 35, 5, 5));
            LayoutUtils.addComponent((Component)this.sudoPassword, (Container)this.configMethodPane, (int)1, (int)5, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(5, 5, 5, 45));
            LayoutUtils.addComponent((Component)this.rdoUsePB, (Container)this.configMethodPane, (int)0, (int)6, (int)3, (int)1, (int)2, (int)18, (double)0.0, (double)0.0, (Insets)LayoutUtils.STANDARD_INSETS);
            LayoutUtils.addComponent((Component)this.lblPBPath, (Container)this.configMethodPane, (int)0, (int)7, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(5, 35, 5, 5));
            LayoutUtils.addComponent((Component)this.txtPBPath, (Container)this.configMethodPane, (int)1, (int)7, (int)1, (int)1, (int)2, (int)18, (double)1.0, (double)0.0, (Insets)new Insets(5, 5, 5, 5));
            LayoutUtils.addComponent((Component)this.btnBrowsePBPath, (Container)this.configMethodPane, (int)2, (int)7, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(5, 5, 5, 5));
            LayoutUtils.addComponent((Component)this.lblPBUser, (Container)this.configMethodPane, (int)0, (int)8, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(5, 35, 5, 5));
            LayoutUtils.addComponent((Component)this.txtPBUser, (Container)this.configMethodPane, (int)1, (int)8, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(5, 5, 5, 45));
            LayoutUtils.addComponent((Component)this.lblPBPassword, (Container)this.configMethodPane, (int)0, (int)9, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(5, 35, 5, 5));
            LayoutUtils.addComponent((Component)this.pbPassword, (Container)this.configMethodPane, (int)1, (int)9, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0, (Insets)new Insets(5, 5, 5, 45));
        }
        return this.configMethodPane;
    }

    public void localize() {
        String text = this.resource.getString("RootConfigurationMethodPane.page.description.text", "During the software configuration, certain operations have to be performed as \"root\" user. You can choose to have the installer perform these operations automatically by specifying inputs for one of the options below.", new Object[0]);
        CommandLineArgumentHandler cmdLineArgumentHandler = CommandLineArgumentHandler.getInstance();
        if (cmdLineArgumentHandler == null || !cmdLineArgumentHandler.isArgumentPassed("executeConfigTools")) {
            text = text + " " + this.resource.getString("RootConfigurationMethodPane.page.description.prereqs.text", "The input specified will also be used by the installer to perform additional prerequisite checks.", new Object[0]);
        }
        this.lblDescription.setText(text);
        text = this.resource.getString("RootConfigurationMethodPane.rdoUseRoot.text", "Use \"root\" user &credential", new Object[0]);
        SwingUtils.setText((AbstractButton)this.rdoUseRoot, (String)text);
        text = this.resource.getString("RootConfigurationMethodPane.lblRootPassword.text", "Pass&word", new Object[0]);
        SwingUtils.setText((JLabel)this.lblRootPassword, (String)text);
        text = this.resource.getString("RootConfigurationMethodPane.rdoUseSudo.text", "Use &sudo", new Object[0]);
        SwingUtils.setText((AbstractButton)this.rdoUseSudo, (String)text);
        text = this.resource.getString("RootConfigurationMethodPane.lblSudoPath.text", "Pro&gram path", new Object[0]);
        SwingUtils.setText((JLabel)this.lblSudoPath, (String)text);
        text = this.resource.getString("RootConfigurationMethodPane.lblSudoUser.text", "&User Name", new Object[0]);
        SwingUtils.setText((JLabel)this.lblSudoUser, (String)text);
        text = this.resource.getString("RootConfigurationMethodPane.lblSudoPassword.text", "Passw&ord", new Object[0]);
        SwingUtils.setText((JLabel)this.lblSudoPassword, (String)text);
        text = this.resource.getString("RootConfigurationMethodPane.rdoUsePB.text", "Use &Power Broker", new Object[0]);
        SwingUtils.setText((AbstractButton)this.rdoUsePB, (String)text);
        text = this.resource.getString("RootConfigurationMethodPane.lblPBPath.text", "Progra&m path", new Object[0]);
        SwingUtils.setText((JLabel)this.lblPBPath, (String)text);
        text = this.resource.getString("RootConfigurationMethodPane.lblPBUser.text", "User Na&me", new Object[0]);
        SwingUtils.setText((JLabel)this.lblPBUser, (String)text);
        text = this.resource.getString("RootConfigurationMethodPane.lblPBPassword.text", "Passwor&d", new Object[0]);
        SwingUtils.setText((JLabel)this.lblPBPassword, (String)text);
        text = this.resource.getString("RootConfigurationMethodPane.cbxRunConfigScripts.text", "&Automatically run configuration scripts", new Object[0]);
        SwingUtils.setText((AbstractButton)this.cbxRunConfigScripts, (String)text);
        text = this.resource.getString("RootConfigurationMethodPane.btnBrowsePBPath.text", "Brows&e", new Object[0]);
        SwingUtils.setText((AbstractButton)this.btnBrowsePBPath, (String)text);
        text = this.resource.getString("RootConfigurationMethodPane.btnBrowseSudoPath.text", "B&rowse", new Object[0]);
        SwingUtils.setText((AbstractButton)this.btnBrowseSudoPath, (String)text);
        this.fileChooser.setDialogTitle(this.resource.getString("INSTALL_COMMON_CHOOSE_FILE_LABEL", "Select File*", new Object[0]));
        this.fileChooser.setApproveButtonText(this.resource.getString("INSTALL_COMMON_SELECT_LABEL", "Select*", new Object[0]));
    }

    private File showFileChooserFor(String path) {
        Frame parent;
        int returnVal;
        File resultFile = null;
        if (path != null) {
            File file = new File(path);
            if (file.isDirectory()) {
                this.fileChooser.setCurrentDirectory(file);
            } else if (file.isFile()) {
                this.fileChooser.setSelectedFile(file);
            }
        }
        if ((returnVal = this.fileChooser.showOpenDialog(parent = (Frame)SwingUtilities.windowForComponent(this.btnBrowsePBPath))) == 0) {
            resultFile = this.fileChooser.getSelectedFile();
        }
        return resultFile;
    }

    public void enableRootUserComps(boolean enabled) {
        this.lblRootPassword.setEnabled(enabled);
        this.rootPassword.setEnabled(enabled);
    }

    public void enableSudoComps(boolean enabled) {
        this.lblSudoPath.setEnabled(enabled);
        this.txtSudoPath.setEnabled(enabled);
        this.btnBrowseSudoPath.setEnabled(enabled);
        if (!this.disableSudoUser) {
            this.lblSudoUser.setEnabled(enabled);
            this.txtSudoUser.setEnabled(enabled);
        }
        this.lblSudoPassword.setEnabled(enabled);
        this.sudoPassword.setEnabled(enabled);
    }

    public void enablePBComps(boolean enabled) {
        this.lblPBPath.setEnabled(enabled);
        this.txtPBPath.setEnabled(enabled);
        this.btnBrowsePBPath.setEnabled(enabled);
        this.lblPBUser.setEnabled(enabled);
        this.txtPBUser.setEnabled(enabled);
        this.lblPBPassword.setEnabled(enabled);
        this.pbPassword.setEnabled(enabled);
    }

    public void setConfigMethod(RootConfigurationSettings.ConfigMethod method) {
        if (method != null) {
            this.cbxRunConfigScripts.setSelected(true);
            switch (method) {
                case ROOT: {
                    this.rdoUseRoot.setSelected(true);
                    break;
                }
                case SUDO: {
                    this.rdoUseSudo.setSelected(true);
                    break;
                }
                case PB: {
                    this.rdoUsePB.setSelected(true);
                    break;
                }
                case DEFAULT: {
                    this.cbxRunConfigScripts.setSelected(false);
                }
            }
        } else {
            this.cbxRunConfigScripts.setSelected(false);
        }
    }

    public void enableCompsForOption(RootConfigurationSettings.ConfigMethod configMethod) {
        switch (configMethod) {
            case ROOT: {
                this.enableRootUserComps(true);
                this.enableSudoComps(false);
                this.enablePBComps(false);
                break;
            }
            case SUDO: {
                this.enableRootUserComps(false);
                this.enableSudoComps(true);
                this.enablePBComps(false);
                break;
            }
            case PB: {
                this.enableRootUserComps(false);
                this.enableSudoComps(false);
                this.enablePBComps(true);
                break;
            }
            case DEFAULT: {
                this.enableRootUserComps(false);
                this.enableSudoComps(false);
                this.enablePBComps(false);
            }
        }
    }

    public RootConfigurationSettings.ConfigMethod getConfigMethod() {
        if (this.cbxRunConfigScripts.isSelected()) {
            if (this.rdoUseRoot.isShowing() && this.rdoUseRoot.isSelected()) {
                return RootConfigurationSettings.ConfigMethod.ROOT;
            }
            if (this.rdoUseSudo.isShowing() && this.rdoUseSudo.isSelected()) {
                return RootConfigurationSettings.ConfigMethod.SUDO;
            }
            if (this.rdoUsePB.isShowing() && this.rdoUsePB.isSelected()) {
                return RootConfigurationSettings.ConfigMethod.PB;
            }
        }
        return RootConfigurationSettings.ConfigMethod.DEFAULT;
    }

    public String getRootPassword() {
        char[] password = this.rootPassword.getPassword();
        return password == null || password.length == 0 ? null : new String(password);
    }

    public String getSudoPassword() {
        char[] password = this.sudoPassword.getPassword();
        return password == null || password.length == 0 ? "" : new String(password);
    }

    public String getPBPassword() {
        char[] password = this.pbPassword.getPassword();
        return password == null || password.length == 0 ? null : new String(password);
    }

    public void setSudoProgramPath(String path) {
        this.txtSudoPath.setText(path);
    }

    public String getSudoProgramPath() {
        return this.txtSudoPath.getText().trim();
    }

    public void setSudoUser(String user) {
        this.txtSudoUser.setText(user);
    }

    public String getSudoUser() {
        return this.txtSudoUser.getText();
    }

    public void setPBPath(String path) {
        this.txtPBPath.setText(path);
    }

    public String getPBPath() {
        return this.txtPBPath.getText();
    }

    public void setPBUser(String user) {
        this.txtPBUser.setText(user);
    }

    public String getPBUser() {
        return this.txtPBUser.getText();
    }

    public void supportRootOption(boolean support) {
        this.rdoUseRoot.setVisible(support);
        this.lblRootPassword.setVisible(support);
        this.rootPassword.setVisible(support);
    }

    public void supportSudoOption(boolean support) {
        this.rdoUseSudo.setVisible(support);
        this.lblSudoPath.setVisible(support);
        this.txtSudoPath.setVisible(support);
        this.btnBrowseSudoPath.setVisible(support);
        this.lblSudoUser.setVisible(support);
        this.txtSudoUser.setVisible(support);
        this.lblSudoPassword.setVisible(support);
        this.sudoPassword.setVisible(support);
    }

    public void supportPBRunOption(boolean support) {
        this.rdoUsePB.setVisible(support);
        this.lblPBPath.setVisible(support);
        this.txtPBPath.setVisible(support);
        this.btnBrowsePBPath.setVisible(support);
        this.lblPBUser.setVisible(support);
        this.txtPBUser.setVisible(support);
        this.lblPBPassword.setVisible(support);
        this.pbPassword.setVisible(support);
    }

    public void disableSudoUserField(boolean value) {
        this.disableSudoUser = value;
        if (value) {
            this.txtSudoUser.setEnabled(!value);
            this.lblSudoUser.setEnabled(!value);
        } else if (this.cbxRunConfigScripts.isSelected() && this.rdoUseSudo.isEnabled() && this.rdoUseSudo.isSelected()) {
            this.txtSudoUser.setEnabled(!value);
            this.lblSudoUser.setEnabled(!value);
        }
    }

    class ConfigOptionItemListener
    implements ItemListener {
        RootConfigurationSettings.ConfigMethod configMethod;

        public ConfigOptionItemListener(RootConfigurationSettings.ConfigMethod method) {
            this.configMethod = method;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            boolean selected;
            boolean bl = selected = e.getStateChange() == 1;
            if (selected) {
                RootConfigurationMethodPane.this.enableCompsForOption(this.configMethod);
            }
        }
    }
}

