/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import oracle.install.library.util.InventoryInfo;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiis.OiisCompContext;
import oracle.sysman.oii.oiis.OiisGenericConstant;
import oracle.sysman.oii.oiis.OiisVariable;

public class OracleHomeInfo {
    private static OracleHomeInfo instance = null;
    private Map<String, OiisCompContext> contextCache = new HashMap<String, OiisCompContext>();

    public static OracleHomeInfo getInstance() {
        if (instance == null) {
            instance = new OracleHomeInfo();
        }
        return instance;
    }

    private OracleHomeInfo() {
    }

    private OiisCompContext getContext(String home, String compName) {
        OiiiInstallCompInvEntry oicie;
        OiisCompContext context = null;
        if (this.contextCache != null) {
            context = this.contextCache.get(compName);
        }
        if (context == null && (oicie = InventoryInfo.getInstance().getCompInvEntryObj(home, compName)) != null && (context = OiisCompContext.createContextFromInstallInv((OiiiInstallCompInvEntry)oicie, (int)InventoryInfo.getInstance().getHomeIndex(home))) != null) {
            this.contextCache.put(compName, context);
        }
        return context;
    }

    public Map<String, String> getAllValues(String home, String compName) {
        OiisCompContext context = this.getContext(home, compName);
        if (context != null) {
            HashMap<String, String> vars = new HashMap<String, String>();
            Enumeration enumvars = context.getAllVariables();
            while (enumvars.hasMoreElements()) {
                OiisVariable var = (OiisVariable)enumvars.nextElement();
                vars.put(var.getName(), var.getValueAsString());
            }
            return vars;
        }
        return null;
    }

    public String getValue(String home, String variable, String compName) {
        OiisCompContext context = this.getContext(home, compName);
        if (context != null) {
            OiisVariable var = context.getVariable(variable);
            if (var != null) {
                return context.getVariable(variable).getValueAsString();
            }
            Enumeration e = context.getConstants();
            while (e.hasMoreElements()) {
                OiisGenericConstant constant = (OiisGenericConstant)e.nextElement();
                if (constant == null || !constant.getName().equals(variable)) continue;
                return constant.getValue().toString();
            }
        }
        return null;
    }
}

