/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.library.util;

import java.nio.charset.Charset;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.verification.NodeResultStatus;
import oracle.cluster.verification.OverallStatus;
import oracle.cluster.verification.VerificationResult;
import oracle.cluster.verification.VerificationResultSet;
import oracle.i18n.util.LocaleMapper;
import oracle.i18n.util.OraLocaleInfo;
import oracle.install.commons.util.ProxyFactory;
import oracle.install.driver.oui.DriverHelper;
import oracle.install.library.util.PlatformInfo;
import oracle.install.library.util.cvu.CVUHelper;

public class SystemInfo {
    private static SystemInfo instance = null;
    private static final Logger logger = Logger.getLogger(SystemInfo.class.getName());

    public static SystemInfo getInstance() {
        ProxyFactory proxyFactory;
        if (instance == null && (instance = (SystemInfo)(proxyFactory = ProxyFactory.getInstance()).createProxy(SystemInfo.class)) == null) {
            instance = new SystemInfo();
        }
        return instance;
    }

    public String getSystemLocaleCharset() {
        Locale locale = this.getHostLocale();
        String lang = LocaleMapper.getOraLanguage((Locale)locale);
        String[][] charsets = OraLocaleInfo.getLocalCommonCharacterSets((String)lang);
        if (charsets.length > 0) {
            return charsets[0][0];
        }
        return "";
    }

    public Locale getHostLocale() {
        String strLanguage = System.getProperty("user.language");
        String strCountry = System.getProperty("user.country");
        Locale locale = null;
        locale = strLanguage != null ? (strCountry != null ? new Locale(strLanguage, strCountry) : new Locale(strLanguage)) : Locale.getDefault();
        return locale;
    }

    public boolean isPackageInstalled(String packageName, String minVersion, String[] nodes) {
        if (!DriverHelper.isCVUEnabled()) {
            return false;
        }
        try {
            CVUHelper cvuObj = CVUHelper.getInstance();
            if (cvuObj != null) {
                VerificationResult result = null;
                VerificationResultSet resultSet = null;
                if (nodes == null || nodes.length == 0 ? DriverHelper.isCVUOperationEnabled((String)"oracle.install.cvu.checkPackage") && (result = cvuObj.checkPackage(packageName, minVersion)) != null && result.hasResultValues() && result.getNodeResultStatus() == NodeResultStatus.SUCCESSFUL : DriverHelper.isCVUOperationEnabled((String)"oracle.install.cvu.multiNodeCheckPackage") && (resultSet = cvuObj.checkPackage(nodes, packageName, minVersion)) != null && resultSet.hasNodeResults() && resultSet.getOverallStatus() == OverallStatus.SUCCESSFUL) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage());
        }
        return false;
    }

    public boolean isPackageInstalled(String packageName, String minVersion) {
        return this.isPackageInstalled(packageName, minVersion, null);
    }

    public static String getLanguageID() {
        String lang_terr = LocaleMapper.getOraLocale((Locale)Locale.getDefault());
        Charset charsetObj = Charset.defaultCharset();
        String charset = LocaleMapper.getOraCharacterSet((int)3, (String)charsetObj.name());
        if (charset == null || charset.length() <= 0) {
            String lang = LocaleMapper.getOraLanguage((Locale)Locale.getDefault());
            String[][] charsets = OraLocaleInfo.getLocalCommonCharacterSets((String)lang);
            charset = charsets[0][0];
        }
        if (charset.equals("US7ASCII")) {
            charset = PlatformInfo.getInstance().isWindows() ? "WE8MSWIN1252" : "WE8ISO8859P1";
        }
        return lang_terr + "." + charset;
    }
}

